/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaRelationshipMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.JavaCascade;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaRelationshipMapping<T extends RelationshipMappingAnnotation>
extends AbstractJavaAttributeMapping<T>
implements JavaRelationshipMapping {
    protected String specifiedTargetEntity;
    protected String defaultTargetEntity;
    protected Entity resolvedTargetEntity;
    protected final JavaCascade cascade = new JavaCascade(this);
    protected FetchType specifiedFetch;

    protected AbstractJavaRelationshipMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public String getTargetEntity() {
        return this.getSpecifiedTargetEntity() == null ? this.getDefaultTargetEntity() : this.getSpecifiedTargetEntity();
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String newSpecifiedTargetEntity) {
        String oldSpecifiedTargetEntity = this.specifiedTargetEntity;
        this.specifiedTargetEntity = newSpecifiedTargetEntity;
        ((RelationshipMappingAnnotation)this.getMappingResource()).setTargetEntity(newSpecifiedTargetEntity);
        this.firePropertyChanged("specifiedTargetEntityProperty", oldSpecifiedTargetEntity, newSpecifiedTargetEntity);
    }

    protected void setSpecifiedTargetEntity_(String newSpecifiedTargetEntity) {
        String oldSpecifiedTargetEntity = this.specifiedTargetEntity;
        this.specifiedTargetEntity = newSpecifiedTargetEntity;
        this.firePropertyChanged("specifiedTargetEntityProperty", oldSpecifiedTargetEntity, newSpecifiedTargetEntity);
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String newDefaultTargetEntity) {
        String oldDefaultTargetEntity = this.defaultTargetEntity;
        this.defaultTargetEntity = newDefaultTargetEntity;
        this.firePropertyChanged("defaultTargetEntityProperty", oldDefaultTargetEntity, newDefaultTargetEntity);
    }

    @Override
    public Entity getResolvedTargetEntity() {
        return this.resolvedTargetEntity;
    }

    protected void setResolvedTargetEntity(Entity newResolvedTargetEntity) {
        Entity oldResolvedTargetEntity = this.resolvedTargetEntity;
        this.resolvedTargetEntity = newResolvedTargetEntity;
        this.firePropertyChanged("resolvedTargetEntityProperty", oldResolvedTargetEntity, newResolvedTargetEntity);
    }

    @Override
    public JavaCascade getCascade() {
        return this.cascade;
    }

    @Override
    public FetchType getFetch() {
        return this.getSpecifiedFetch() == null ? this.getDefaultFetch() : this.getSpecifiedFetch();
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        ((RelationshipMappingAnnotation)this.getMappingResource()).setFetch(FetchType.toJavaResourceModel(newSpecifiedFetch));
        this.firePropertyChanged("specifiedFetchProperty", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected void setSpecifiedFetch_(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        this.firePropertyChanged("specifiedFetchProperty", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    @Override
    public void initializeFromResource(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        this.defaultTargetEntity = this.defaultTargetEntity(resourcePersistentAttribute);
        super.initializeFromResource(resourcePersistentAttribute);
    }

    @Override
    public void update(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        this.setDefaultTargetEntity(this.defaultTargetEntity(resourcePersistentAttribute));
        super.update(resourcePersistentAttribute);
    }

    @Override
    protected void initialize(T relationshipMapping) {
        this.specifiedFetch = this.fetch(relationshipMapping);
        this.cascade.initialize((RelationshipMappingAnnotation)relationshipMapping);
        this.specifiedTargetEntity = this.specifiedTargetEntity(relationshipMapping);
        this.resolvedTargetEntity = this.resolveTargetEntity(relationshipMapping);
    }

    @Override
    protected void update(T relationshipMapping) {
        super.update(relationshipMapping);
        this.setSpecifiedFetch_(this.fetch(relationshipMapping));
        this.cascade.update((RelationshipMappingAnnotation)relationshipMapping);
        this.setSpecifiedTargetEntity_(this.specifiedTargetEntity(relationshipMapping));
        this.setResolvedTargetEntity(this.resolveTargetEntity(relationshipMapping));
    }

    protected FetchType fetch(T relationshipMapping) {
        return FetchType.fromJavaResourceModel(relationshipMapping.getFetch());
    }

    protected String specifiedTargetEntity(T relationshipMapping) {
        return relationshipMapping.getTargetEntity();
    }

    protected abstract String defaultTargetEntity(JavaResourcePersistentAttribute var1);

    protected Entity resolveTargetEntity(T relationshipMapping) {
        String qualifiedTargetEntity = this.getDefaultTargetEntity();
        if (this.getSpecifiedTargetEntity() != null) {
            qualifiedTargetEntity = relationshipMapping.getFullyQualifiedTargetEntity();
        }
        if (qualifiedTargetEntity == null) {
            return null;
        }
        PersistentType persistentType = this.getPersistenceUnit().getPersistentType(qualifiedTargetEntity);
        if (persistentType != null && persistentType.getMappingKey() == "entity") {
            return (Entity)persistentType.getMapping();
        }
        return null;
    }

    @Override
    public Entity getEntity() {
        if (this.getTypeMapping() instanceof Entity) {
            return (Entity)this.getTypeMapping();
        }
        return null;
    }

    public Iterator<String> allTargetEntityAttributeNames() {
        Entity targetEntity = this.getResolvedTargetEntity();
        return targetEntity == null ? EmptyIterator.instance() : targetEntity.getPersistentType().allAttributeNames();
    }

    public Iterator<String> candidateMappedByAttributeNames() {
        return this.allTargetEntityAttributeNames();
    }

    protected Iterator<String> candidateMappedByAttributeNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateMappedByAttributeNames(), filter);
    }

    protected Iterator<String> quotedCandidateMappedByAttributeNames(Filter<String> filter) {
        return StringTools.quote(this.candidateMappedByAttributeNames(filter));
    }

    @Override
    public boolean targetEntityIsValid(String targetEntity) {
        return MappingTools.targetEntityIsValid(targetEntity);
    }
}

