/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.orm.OrmBaseColumn;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmNamedColumn;
import org.eclipse.jpt.core.resource.orm.XmlAbstractColumn;
import org.eclipse.jpt.core.utility.TextRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmBaseColumn<T extends XmlAbstractColumn>
extends AbstractOrmNamedColumn<T>
implements OrmBaseColumn {
    protected String specifiedTable;
    protected String defaultTable;
    protected Boolean specifiedUnique;
    protected Boolean specifiedNullable;
    protected Boolean specifiedInsertable;
    protected Boolean specifiedUpdatable;

    protected AbstractOrmBaseColumn(OrmJpaContextNode parent, OrmBaseColumn.Owner owner) {
        super(parent, owner);
    }

    public void initializeFrom(BaseColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedTable(oldColumn.getSpecifiedTable());
        this.setSpecifiedUnique(oldColumn.getSpecifiedUnique());
        this.setSpecifiedNullable(oldColumn.getSpecifiedNullable());
        this.setSpecifiedInsertable(oldColumn.getSpecifiedInsertable());
        this.setSpecifiedUpdatable(oldColumn.getSpecifiedUpdatable());
    }

    @Override
    public OrmBaseColumn.Owner getOwner() {
        return (OrmBaseColumn.Owner)super.getOwner();
    }

    @Override
    public String getTable() {
        return this.getSpecifiedTable() == null ? this.getDefaultTable() : this.getSpecifiedTable();
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        if (oldSpecifiedTable != newSpecifiedTable) {
            if (this.getColumnResource() != null) {
                ((XmlAbstractColumn)this.getColumnResource()).setTable(newSpecifiedTable);
                if (((XmlAbstractColumn)this.getColumnResource()).isAllFeaturesUnset()) {
                    this.removeColumnResource();
                }
            } else if (newSpecifiedTable != null) {
                this.addColumnResource();
                ((XmlAbstractColumn)this.getColumnResource()).setTable(newSpecifiedTable);
            }
        }
        this.firePropertyChanged("specifiedTableProperty", oldSpecifiedTable, newSpecifiedTable);
    }

    protected void setSpecifiedTable_(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        this.firePropertyChanged("specifiedTableProperty", oldSpecifiedTable, newSpecifiedTable);
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    protected void setDefaultTable(String newDefaultTable) {
        String oldDefaultTable = this.defaultTable;
        this.defaultTable = newDefaultTable;
        this.firePropertyChanged("defaultTableProperty", oldDefaultTable, newDefaultTable);
    }

    @Override
    public Boolean getUnique() {
        return this.getSpecifiedUnique() == null ? this.getDefaultUnique() : this.getSpecifiedUnique();
    }

    @Override
    public Boolean getDefaultUnique() {
        return BaseColumn.DEFAULT_UNIQUE;
    }

    @Override
    public Boolean getSpecifiedUnique() {
        return this.specifiedUnique;
    }

    @Override
    public void setSpecifiedUnique(Boolean newSpecifiedUnique) {
        Boolean oldSpecifiedUnique = this.specifiedUnique;
        this.specifiedUnique = newSpecifiedUnique;
        if (oldSpecifiedUnique != newSpecifiedUnique) {
            if (this.getColumnResource() != null) {
                ((XmlAbstractColumn)this.getColumnResource()).setUnique(newSpecifiedUnique);
                if (((XmlAbstractColumn)this.getColumnResource()).isAllFeaturesUnset()) {
                    this.removeColumnResource();
                }
            } else if (newSpecifiedUnique != null) {
                this.addColumnResource();
                ((XmlAbstractColumn)this.getColumnResource()).setUnique(newSpecifiedUnique);
            }
        }
        this.firePropertyChanged("specifiedUniqueProperty", oldSpecifiedUnique, newSpecifiedUnique);
    }

    protected void setSpecifiedUnique_(Boolean newSpecifiedUnique) {
        Boolean oldSpecifiedUnique = this.specifiedUnique;
        this.specifiedUnique = newSpecifiedUnique;
        this.firePropertyChanged("specifiedUniqueProperty", oldSpecifiedUnique, newSpecifiedUnique);
    }

    @Override
    public Boolean getNullable() {
        return this.getSpecifiedNullable() == null ? this.getDefaultNullable() : this.getSpecifiedNullable();
    }

    @Override
    public Boolean getDefaultNullable() {
        return BaseColumn.DEFAULT_NULLABLE;
    }

    @Override
    public Boolean getSpecifiedNullable() {
        return this.specifiedNullable;
    }

    @Override
    public void setSpecifiedNullable(Boolean newSpecifiedNullable) {
        Boolean oldSpecifiedNullable = this.specifiedNullable;
        this.specifiedNullable = newSpecifiedNullable;
        if (oldSpecifiedNullable != newSpecifiedNullable) {
            if (this.getColumnResource() != null) {
                ((XmlAbstractColumn)this.getColumnResource()).setNullable(newSpecifiedNullable);
                if (((XmlAbstractColumn)this.getColumnResource()).isAllFeaturesUnset()) {
                    this.removeColumnResource();
                }
            } else if (newSpecifiedNullable != null) {
                this.addColumnResource();
                ((XmlAbstractColumn)this.getColumnResource()).setNullable(newSpecifiedNullable);
            }
        }
        this.firePropertyChanged("specifiedNullableProperty", oldSpecifiedNullable, newSpecifiedNullable);
    }

    protected void setSpecifiedNullable_(Boolean newSpecifiedNullable) {
        Boolean oldSpecifiedNullable = this.specifiedNullable;
        this.specifiedNullable = newSpecifiedNullable;
        this.firePropertyChanged("specifiedNullableProperty", oldSpecifiedNullable, newSpecifiedNullable);
    }

    @Override
    public Boolean getInsertable() {
        return this.getSpecifiedInsertable() == null ? this.getDefaultInsertable() : this.getSpecifiedInsertable();
    }

    @Override
    public Boolean getDefaultInsertable() {
        return BaseColumn.DEFAULT_INSERTABLE;
    }

    @Override
    public Boolean getSpecifiedInsertable() {
        return this.specifiedInsertable;
    }

    @Override
    public void setSpecifiedInsertable(Boolean newSpecifiedInsertable) {
        Boolean oldSpecifiedInsertable = this.specifiedInsertable;
        this.specifiedInsertable = newSpecifiedInsertable;
        if (oldSpecifiedInsertable != newSpecifiedInsertable) {
            if (this.getColumnResource() != null) {
                ((XmlAbstractColumn)this.getColumnResource()).setInsertable(newSpecifiedInsertable);
                if (((XmlAbstractColumn)this.getColumnResource()).isAllFeaturesUnset()) {
                    this.removeColumnResource();
                }
            } else if (newSpecifiedInsertable != null) {
                this.addColumnResource();
                ((XmlAbstractColumn)this.getColumnResource()).setInsertable(newSpecifiedInsertable);
            }
        }
        this.firePropertyChanged("specifiedInsertableProperty", oldSpecifiedInsertable, newSpecifiedInsertable);
    }

    protected void setSpecifiedInsertable_(Boolean newSpecifiedInsertable) {
        Boolean oldSpecifiedInsertable = this.specifiedInsertable;
        this.specifiedInsertable = newSpecifiedInsertable;
        this.firePropertyChanged("specifiedInsertableProperty", oldSpecifiedInsertable, newSpecifiedInsertable);
    }

    @Override
    public Boolean getUpdatable() {
        return this.getSpecifiedUpdatable() == null ? this.getDefaultUpdatable() : this.getSpecifiedUpdatable();
    }

    @Override
    public Boolean getDefaultUpdatable() {
        return BaseColumn.DEFAULT_UPDATABLE;
    }

    @Override
    public Boolean getSpecifiedUpdatable() {
        return this.specifiedUpdatable;
    }

    @Override
    public void setSpecifiedUpdatable(Boolean newSpecifiedUpdatable) {
        Boolean oldSpecifiedUpdatable = this.specifiedUpdatable;
        this.specifiedUpdatable = newSpecifiedUpdatable;
        if (oldSpecifiedUpdatable != newSpecifiedUpdatable) {
            if (this.getColumnResource() != null) {
                ((XmlAbstractColumn)this.getColumnResource()).setUpdatable(newSpecifiedUpdatable);
                if (((XmlAbstractColumn)this.getColumnResource()).isAllFeaturesUnset()) {
                    this.removeColumnResource();
                }
            } else if (newSpecifiedUpdatable != null) {
                this.addColumnResource();
                ((XmlAbstractColumn)this.getColumnResource()).setUpdatable(newSpecifiedUpdatable);
            }
        }
        this.firePropertyChanged("specifiedUpdatableProperty", oldSpecifiedUpdatable, newSpecifiedUpdatable);
    }

    protected void setSpecifiedUpdatable_(Boolean newSpecifiedUpdatable) {
        Boolean oldSpecifiedUpdatable = this.specifiedUpdatable;
        this.specifiedUpdatable = newSpecifiedUpdatable;
        this.firePropertyChanged("specifiedUpdatableProperty", oldSpecifiedUpdatable, newSpecifiedUpdatable);
    }

    @Override
    protected String tableName() {
        return this.getTable();
    }

    @Override
    public TextRange getTableTextRange() {
        TextRange textRange;
        if (this.getColumnResource() != null && (textRange = ((XmlAbstractColumn)this.getColumnResource()).getTableTextRange()) != null) {
            return textRange;
        }
        return this.getParent().getValidationTextRange();
    }

    @Override
    protected void initialize(T column) {
        super.initialize(column);
        this.specifiedTable = this.specifiedTable(column);
        this.defaultTable = this.defaultTable();
        this.specifiedNullable = this.specifiedNullable(column);
        this.specifiedUpdatable = this.specifiedUpdatable(column);
        this.specifiedUnique = this.specifiedUnique(column);
        this.specifiedInsertable = this.specifiedInsertable(column);
    }

    @Override
    protected void update(T column) {
        super.update(column);
        this.setSpecifiedTable_(this.specifiedTable(column));
        this.setDefaultTable(this.defaultTable());
        this.setSpecifiedNullable_(this.specifiedNullable(column));
        this.setSpecifiedUpdatable_(this.specifiedUpdatable(column));
        this.setSpecifiedUnique_(this.specifiedUnique(column));
        this.setSpecifiedInsertable_(this.specifiedInsertable(column));
    }

    protected String specifiedTable(T column) {
        return column == null ? null : column.getTable();
    }

    protected Boolean specifiedNullable(T column) {
        return column == null ? null : column.getNullable();
    }

    protected Boolean specifiedUpdatable(T column) {
        return column == null ? null : column.getUpdatable();
    }

    protected Boolean specifiedUnique(T column) {
        return column == null ? null : column.getUnique();
    }

    protected Boolean specifiedInsertable(T column) {
        return column == null ? null : column.getInsertable();
    }

    protected String defaultTable() {
        return this.getOwner().getDefaultTableName();
    }
}

