/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.eclipselink.core.internal.context.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.PersistenceUnitPropertyListListener;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EclipseLinkPersistenceUnitProperties
extends AbstractModel
implements PersistenceUnitProperties {
    private PersistenceUnit persistenceUnit;
    private PersistenceUnitPropertyListListener propertyListListener;
    private Map<String, String> propertyNames;
    private static final long serialVersionUID = 1L;

    protected EclipseLinkPersistenceUnitProperties(PersistenceUnit parent, ListValueModel<Property> propertyListAdapter) {
        this.initialize(parent, propertyListAdapter);
    }

    protected void initialize(PersistenceUnit parent, ListValueModel<Property> propertyListAdapter) {
        this.persistenceUnit = parent;
        this.propertyListListener = new PersistenceUnitPropertyListListener(this);
        propertyListAdapter.addListChangeListener("list values", (ListChangeListener)this.propertyListListener);
        this.initializePropertyNames();
        this.initializeProperties();
    }

    protected void initializePropertyNames() {
        this.propertyNames = new HashMap<String, String>();
        this.addPropertyNames(this.propertyNames);
    }

    protected abstract void initializeProperties();

    @Override
    public PersistenceUnit persistenceUnit() {
        return this.persistenceUnit;
    }

    @Override
    public JpaProject getJpaProject() {
        return this.persistenceUnit.getJpaProject();
    }

    public PersistenceUnitPropertyListListener propertyListListener() {
        return this.propertyListListener;
    }

    private Map<String, String> propertyNames() {
        return this.propertyNames;
    }

    protected abstract void addPropertyNames(Map<String, String> var1);

    @Override
    public boolean itemIsProperty(Property item) {
        if (item == null) {
            throw new IllegalArgumentException("Property is null");
        }
        return this.propertyNames().keySet().contains(item.getName());
    }

    @Override
    public String propertyIdFor(Property property) {
        String propertyId = this.propertyNames().get(property.getName());
        if (propertyId == null) {
            throw new IllegalArgumentException("Illegal property: " + property.toString());
        }
        return propertyId;
    }

    protected String eclipseLinkKeyFor(String propertyId) {
        for (String eclipseLinkKey : this.propertyNames().keySet()) {
            if (!this.propertyNames().get(eclipseLinkKey).equals(propertyId)) continue;
            return eclipseLinkKey;
        }
        throw new IllegalArgumentException("Illegal property: " + propertyId);
    }

    protected String getStringValue(String elKey) {
        return this.getStringValue(elKey, null);
    }

    protected String getStringValue(String key, String keySuffix) {
        String elKey;
        String string = elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        if (this.persistenceUnit().containsProperty(elKey)) {
            return this.persistenceUnit().getProperty(elKey).getValue();
        }
        return null;
    }

    protected void putStringValue(String key, String newValue) {
        this.putStringValue(key, null, newValue, false);
    }

    protected void putStringValue(String key, String newValue, boolean allowDuplicate) {
        this.putStringValue(key, null, newValue, allowDuplicate);
    }

    protected void putStringValue(String key, String keySuffix, String newValue, boolean allowDuplicate) {
        String elKey;
        String string = elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        if (newValue == null) {
            this.persistenceUnit().removeProperty(elKey);
        } else {
            this.persistenceUnit().putProperty(elKey, newValue, allowDuplicate);
        }
    }

    protected Integer getIntegerValue(String elKey) {
        return this.getIntegerValue(elKey, null);
    }

    protected Integer getIntegerValue(String key, String keySuffix) {
        String elKey;
        String string = elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        if (this.persistenceUnit().containsProperty(elKey)) {
            String eclipseLinkValue = this.persistenceUnit().getProperty(elKey).getValue();
            return EclipseLinkPersistenceUnitProperties.getIntegerValueOf(eclipseLinkValue);
        }
        return null;
    }

    protected void putIntegerValue(String key, Integer newValue) {
        this.putIntegerValue(key, null, newValue, false);
    }

    protected void putIntegerValue(String key, Integer newValue, boolean allowDuplicate) {
        this.putIntegerValue(key, null, newValue, allowDuplicate);
    }

    protected void putIntegerValue(String key, String keySuffix, Integer newValue, boolean allowDuplicate) {
        String elKey;
        String string = elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        if (newValue == null) {
            this.persistenceUnit().removeProperty(elKey);
        } else {
            this.persistenceUnit().putProperty(elKey, newValue.toString(), allowDuplicate);
        }
    }

    protected Boolean getBooleanValue(String elKey) {
        return this.getBooleanValue(elKey, null);
    }

    protected Boolean getBooleanValue(String key, String keySuffix) {
        String elKey;
        String string = elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        if (this.persistenceUnit().containsProperty(elKey)) {
            String eclipseLinkValue = this.persistenceUnit().getProperty(elKey).getValue();
            return EclipseLinkPersistenceUnitProperties.getBooleanValueOf(eclipseLinkValue);
        }
        return null;
    }

    protected void putBooleanValue(String key, Boolean newValue) {
        this.putBooleanValue(key, null, newValue, false);
    }

    protected void putBooleanValue(String key, Boolean newValue, boolean allowDuplicate) {
        this.putBooleanValue(key, null, newValue, allowDuplicate);
    }

    protected void putBooleanValue(String key, String keySuffix, Boolean newValue, boolean allowDuplicate) {
        String elKey;
        String string = elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        if (newValue == null) {
            this.persistenceUnit().removeProperty(elKey);
        } else {
            this.persistenceUnit().putProperty(elKey, newValue.toString(), allowDuplicate);
        }
    }

    protected <T extends Enum<T>> T getEnumValue(String elKey, T[] enumValues) {
        return (T)this.getEnumValue(elKey, null, (Enum[])enumValues);
    }

    protected <T extends Enum<T>> T getEnumValue(String key, String keySuffix, T[] enumValues) {
        String elKey;
        String string = elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        if (this.persistenceUnit().containsProperty(elKey)) {
            String elStringValue = this.persistenceUnit().getProperty(elKey).getValue();
            return (T)EclipseLinkPersistenceUnitProperties.getEnumValueOf((String)elStringValue, enumValues);
        }
        return null;
    }

    protected <T extends Enum<T>> void putEnumValue(String key, T newValue) {
        this.putEnumValue(key, null, newValue, false);
    }

    protected <T extends Enum<T>> void putEnumValue(String key, T newValue, boolean allowDuplicate) {
        this.putEnumValue(key, null, newValue, allowDuplicate);
    }

    protected <T extends Enum<T>> void putEnumValue(String key, String keySuffix, T newValue, boolean allowDuplicate) {
        String elKey;
        String string = elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        if (newValue == null) {
            this.persistenceUnit().removeProperty(elKey);
        } else {
            this.persistenceUnit().putProperty(elKey, EclipseLinkPersistenceUnitProperties.getEclipseLinkStringValueOf(newValue), allowDuplicate);
        }
    }

    protected void putProperty(String key, Object value) {
        String elKey = this.eclipseLinkKeyFor(key);
        if (value == null) {
            this.removeProperty(elKey);
        } else if (value.getClass().isEnum()) {
            this.putEnumValue(elKey, (Enum)value);
        } else {
            this.putProperty_(elKey, value);
        }
    }

    private void putProperty_(String key, Object value) {
        this.persistenceUnit().putProperty(key, value.toString(), false);
    }

    protected void removeProperty(String elKey) {
        this.persistenceUnit().removeProperty(elKey);
    }

    protected Set<Property> getPropertiesSetWithPrefix(String keyPrefix) {
        return CollectionTools.set((Iterator)this.persistenceUnit().propertiesWithPrefix(keyPrefix));
    }

    protected String getEntityName(Property property) {
        return this.getEntityName(property.getName());
    }

    protected String getEntityName(String propertyName) {
        int index = propertyName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return propertyName.substring(index + 1);
    }

    public static String getEclipseLinkStringValueOf(Object value) {
        if (value.getClass().isEnum()) {
            return (String)ClassTools.staticFieldValue(value.getClass(), (String)value.toString().toUpperCase(Locale.ENGLISH));
        }
        return value.toString();
    }

    public static <T extends Enum<T>> T getEnumValueOf(String elStringValue, T[] enumValues) {
        T[] TArray = enumValues;
        int n = enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            T enumValue = TArray[n2];
            if (EclipseLinkPersistenceUnitProperties.getEclipseLinkStringValueOf(enumValue).equals(elStringValue)) {
                return enumValue;
            }
            ++n2;
        }
        return null;
    }

    public static Boolean getBooleanValueOf(String elStringValue) {
        if (elStringValue == null) {
            return null;
        }
        return Boolean.valueOf(elStringValue);
    }

    public static Integer getIntegerValueOf(String elStringValue) {
        if (elStringValue == null) {
            return null;
        }
        return Integer.valueOf(elStringValue);
    }
}

