/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.internal.context.java.GenericJavaNullAttributeMapping;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaEmbeddedMappingTests
extends ContextModelTestCase {
    public static final String EMBEDDABLE_TYPE_NAME = "MyEmbeddable";
    public static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.MyEmbeddable";

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createEmbeddableAnnotation() throws Exception {
        this.createAnnotationAndMembers("Embeddable", "");
    }

    private void createEmbeddedAnnotation() throws Exception {
        this.createAnnotationAndMembers("Embedded", "");
    }

    private ICompilationUnit createTestEntityWithEmbeddedMapping() throws Exception {
        this.createEntityAnnotation();
        this.createEmbeddedAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embedded"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded").append(CR);
                sb.append("    private MyEmbeddable myEmbedded;").append(CR);
                sb.append(CR);
            }
        });
    }

    private void createEmbeddableType() throws Exception {
        this.createEmbeddableAnnotation();
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(JavaEmbeddedMappingTests.EMBEDDABLE_TYPE_NAME).append(" {");
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "MyEmbeddable.java", sourceWriter);
    }

    public JavaEmbeddedMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaEmbeddedMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaEmbeddedMappingTests.assertTrue((boolean)((EmbeddedMapping)persistentAttribute.getMapping()).attributeOverrides().hasNext());
        JavaEmbeddedMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testDefaultEmbeddedMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof GenericJavaNullAttributeMapping));
        JavaEmbeddedMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        this.createEmbeddableType();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaEmbeddedMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testDefaultEmbeddedMappingGenericEmbeddable() throws Exception {
        this.createTestEntityWithDefaultEmbeddedMapping();
        this.createTestGenericEmbeddable();
        this.addXmlClassRef("test.Entity1");
        this.addXmlClassRef("test.Embeddable1");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaEmbeddedMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        JavaEmbeddedMappingTests.assertNotNull((Object)persistentAttribute.getMapping());
        JavaEmbeddedMappingTests.assertEquals((String)"embedded", (String)persistentAttribute.getDefaultMappingKey());
        JavaEmbeddedMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    private void createTestEntityWithDefaultEmbeddedMapping() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Entity1 { ").append(CR);
                sb.append("private Embeddable1<Integer> myEmbeddable;").append(CR);
                sb.append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Entity1.java", sourceWriter);
    }

    private void createTestGenericEmbeddable() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class Embeddable1<T> {}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Embeddable1.java", sourceWriter);
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToOne"));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToMany"));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.javaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        ListIterator specifiedAttributeOverrides = embeddedMapping.specifiedAttributeOverrides();
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        specifiedAttributeOverrides = embeddedMapping.specifiedAttributeOverrides();
        JavaEmbeddedMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        specifiedAttributeOverrides = embeddedMapping.specifiedAttributeOverrides();
        JavaEmbeddedMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAZ");
        specifiedAttributeOverrides = embeddedMapping.specifiedAttributeOverrides();
        JavaEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.move(1, 0, "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = embeddedMapping.specifiedAttributeOverrides();
        JavaEmbeddedMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = embeddedMapping.specifiedAttributeOverrides();
        JavaEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = embeddedMapping.specifiedAttributeOverrides();
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = embeddedMapping.specifiedAttributeOverrides();
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.javaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaEmbeddedMappingTests.assertEquals((String)"myEmbedded", (String)attributeResource.getName());
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)embeddedMapping.virtualAttributeOverridesSize());
        AttributeOverride defaultAttributeOverride = (AttributeOverride)embeddedMapping.virtualAttributeOverrides().next();
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedMappingTests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTable());
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        classRefs.next();
        Embeddable embeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)embeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        JavaEmbeddedMappingTests.assertEquals((String)"myEmbedded", (String)attributeResource.getName());
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEmbeddedMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)embeddedMapping.virtualAttributeOverridesSize());
        defaultAttributeOverride = (AttributeOverride)embeddedMapping.virtualAttributeOverrides().next();
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedMappingTests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        defaultAttributeOverride = (AttributeOverride)embeddedMapping.virtualAttributeOverrides().next();
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedMappingTests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTable());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("city");
        JavaEmbeddedMappingTests.assertEquals((int)1, (int)embeddedMapping.virtualAttributeOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.javaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)embeddedMapping.specifiedAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)embeddedMapping.specifiedAttributeOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.javaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)embeddedMapping.attributeOverridesSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        JavaEmbeddedMappingTests.assertEquals((int)4, (int)embeddedMapping.attributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        JavaEmbeddedMappingTests.assertEquals((int)4, (int)embeddedMapping.attributeOverridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.javaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)embeddedMapping.virtualAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)embeddedMapping.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        JavaEmbeddedMappingTests.assertEquals((int)1, (int)embeddedMapping.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("state");
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)embeddedMapping.virtualAttributeOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.javaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        ((AttributeOverride)embeddedMapping.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)embeddedMapping.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)embeddedMapping.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)((AttributeOverride)embeddedMapping.virtualAttributeOverrides().next()).getName());
        JavaEmbeddedMappingTests.assertEquals((int)1, (int)embeddedMapping.virtualAttributeOverridesSize());
        ((AttributeOverride)embeddedMapping.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        Iterator virtualAttributeOverrides = embeddedMapping.virtualAttributeOverrides();
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"state", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)embeddedMapping.virtualAttributeOverridesSize());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.javaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        ListIterator virtualAttributeOverrides = embeddedMapping.virtualAttributeOverrides();
        virtualAttributeOverrides.next();
        ((AttributeOverride)virtualAttributeOverrides.next()).setVirtual(false);
        ((AttributeOverride)embeddedMapping.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.javaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        ((AttributeOverride)embeddedMapping.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)embeddedMapping.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.move(1, 0, "javax.persistence.AttributeOverrides");
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }
}

