/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.core.context.java.JavaIdMapping;
import org.eclipse.jpt.core.resource.java.EmbeddedAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaPersistentAttributeTests
extends ContextModelTestCase {
    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private ICompilationUnit createTestEntityAnnotatedField() throws Exception {
        this.createEntityAnnotation();
        this.createAnnotationAndMembers("Id", "");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedMethod() throws Exception {
        this.createEntityAnnotation();
        this.createAnnotationAndMembers("Id", "");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public JavaPersistentAttributeTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getName());
    }

    public void testGetMapping() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaIdMapping));
        persistentAttribute.setSpecifiedMappingKey(null);
        JavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaBasicMapping));
    }

    public void testGetSpecifiedMapping() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getSpecifiedMapping() instanceof JavaIdMapping));
        persistentAttribute.setSpecifiedMappingKey(null);
        JavaPersistentAttributeTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetSpecifiedMappingNull() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaPersistentAttributeTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        JavaPersistentAttributeTests.assertNotNull((Object)persistentAttribute.getMapping());
    }

    public void testMappingKey() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setSpecifiedMappingKey(null);
        JavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getMappingKey());
    }

    public void testDefaultMappingKey() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        JavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getDefaultMappingKey());
    }

    public void testSetSpecifiedMappingKey() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaPersistentAttributeTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaPersistentAttributeTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        JavaPersistentAttributeTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof EmbeddedAnnotation));
        JavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
        JavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getSpecifiedMapping() instanceof JavaEmbeddedMapping));
    }

    public void testSetSpecifiedMappingKey2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaPersistentAttributeTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        JavaPersistentAttributeTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof EmbeddedAnnotation));
        JavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
        JavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getSpecifiedMapping() instanceof JavaEmbeddedMapping));
    }

    public void testSetSpecifiedMappingKeyNull() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaPersistentAttributeTests.assertNull((Object)attributeResource.getMappingAnnotation());
        JavaPersistentAttributeTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaPersistentAttributeTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetMappingKeyMappingChangeInResourceModel() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.setMappingAnnotation("javax.persistence.Embedded");
        JavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
    }

    public void testGetMappingKeyMappingChangeInResourceModel2() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        JavaPersistentAttributeTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.setMappingAnnotation("javax.persistence.Basic");
        JavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getSpecifiedMapping().getKey());
    }
}

