/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class ColumnTests
extends JavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_TABLE = "MY_TABLE";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";

    public ColumnTests(String name) {
        super(name);
    }

    private void createColumnAnnotation() throws Exception {
        this.createAnnotationAndMembers("Column", "String name() default \"\"; boolean unique() default false; boolean nullable() default true; boolean insertable() default true; boolean updatable() default true; String columnDefinition() default \"\"; String table() default \"\"; int length() default 255; int precision() default 0; int scale() default 0;");
    }

    private ICompilationUnit createTestColumn() throws Exception {
        this.createColumnAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Column"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column");
            }
        });
    }

    private ICompilationUnit createTestColumnWithName() throws Exception {
        this.createColumnAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Column"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(name=\"MY_COLUMN\")");
            }
        });
    }

    private ICompilationUnit createTestColumnWithTable() throws Exception {
        this.createColumnAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Column"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(table=\"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestColumnWithColumnDefinition() throws Exception {
        this.createColumnAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Column"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(columnDefinition=\"COLUMN_DEFINITION\")");
            }
        });
    }

    private ICompilationUnit createTestColumnWithBooleanElement(final String booleanElement) throws Exception {
        this.createColumnAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Column"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(" + booleanElement + "=true)");
            }
        });
    }

    private ICompilationUnit createTestColumnWithIntElement(final String intElement) throws Exception {
        this.createColumnAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Column"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(" + intElement + "=5)");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getName());
        ColumnTests.assertNull((Object)column.getNullable());
        ColumnTests.assertNull((Object)column.getInsertable());
        ColumnTests.assertNull((Object)column.getUnique());
        ColumnTests.assertNull((Object)column.getUpdatable());
        ColumnTests.assertNull((Object)column.getTable());
        ColumnTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getName());
        column.setName("Foo");
        ColumnTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@Column(name=\"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        ColumnTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testGetTable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((String)COLUMN_TABLE, (String)column.getTable());
    }

    public void testSetTable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getTable());
        column.setTable("Foo");
        ColumnTests.assertEquals((String)"Foo", (String)column.getTable());
        this.assertSourceContains("@Column(table=\"Foo\")", cu);
        column.setTable(null);
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithColumnDefinition();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        ColumnTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@Column(columnDefinition=\"Foo\")", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testGetUnique() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("unique");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getUnique());
    }

    public void testSetUnique() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getUnique());
        column.setUnique(Boolean.FALSE);
        ColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUnique());
        this.assertSourceContains("@Column(unique=false)", cu);
        column.setUnique(null);
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testGetNullable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("nullable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getNullable());
    }

    public void testSetNullable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getNullable());
        column.setNullable(Boolean.FALSE);
        ColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getNullable());
        this.assertSourceContains("@Column(nullable=false)", cu);
        column.setNullable(null);
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testGetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("insertable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getInsertable());
    }

    public void testSetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getInsertable());
        column.setInsertable(Boolean.FALSE);
        ColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getInsertable());
        this.assertSourceContains("@Column(insertable=false)", cu);
        column.setInsertable(null);
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testGetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("updatable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getUpdatable());
    }

    public void testSetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getUpdatable());
        column.setUpdatable(Boolean.FALSE);
        ColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUpdatable());
        this.assertSourceContains("@Column(updatable=false)", cu);
        column.setUpdatable(null);
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testGetLength() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithIntElement("length");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)5, (Object)column.getLength());
    }

    public void testSetLength() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getLength());
        column.setLength(Integer.valueOf(5));
        ColumnTests.assertEquals((Object)5, (Object)column.getLength());
        this.assertSourceContains("@Column(length=5)", cu);
        column.setLength(null);
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testGetPrecision() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithIntElement("precision");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)5, (Object)column.getPrecision());
    }

    public void testSetPrecision() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertEquals(null, (Object)column.getPrecision());
        column.setPrecision(Integer.valueOf(5));
        ColumnTests.assertEquals((Object)5, (Object)column.getPrecision());
        this.assertSourceContains("@Column(precision=5)", cu);
        column.setPrecision(null);
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testGetScale() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithIntElement("scale");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertEquals((Object)5, (Object)column.getScale());
    }

    public void testSetScale() throws Exception {
        ICompilationUnit cu = this.createTestColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        ColumnTests.assertNotNull((Object)column);
        ColumnTests.assertNull((Object)column.getScale());
        column.setScale(Integer.valueOf(5));
        ColumnTests.assertEquals((Object)5, (Object)column.getScale());
        this.assertSourceContains("@Column(scale=5)", cu);
        column.setScale(null);
        this.assertSourceDoesNotContain("@Column", cu);
    }
}

