/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.IdImpl;
import org.eclipse.jpt.core.internal.resource.java.OneToOneImpl;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.IdAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaResourcePersistentAttributeTests
extends JavaResourceModelTestCase {
    public JavaResourcePersistentAttributeTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonResolvingField() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private Foo foo;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonResolvingMethod() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private Foo foo;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
                sb.append(CR);
                sb.append("    public Foo getFoo() {").append(CR);
                sb.append("        return this.foo;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append(CR);
                sb.append("    public void setFoo(Foo foo) {").append(CR);
                sb.append("        this.foo = foo;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private ICompilationUnit createTestEntityMultipleVariableDeclarationsPerLine() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name();");
        this.createAnnotationAndMembers("Column", "String name();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    ");
                sb.append("@Id");
                sb.append(CR);
                sb.append("    ");
                sb.append("@Column(name=\"baz\")");
                sb.append("    private String foo, bar;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdAndBasic() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name();");
        this.createAnnotationAndMembers("Id", "");
        this.createAnnotationAndMembers("Basic", "");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Basic"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append(CR);
                sb.append("@Basic");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedField() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name();");
        this.createAnnotationAndMembers("Column", "String name();");
        this.createAnnotationAndMembers("Id", "String name();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append(CR);
                sb.append("    ");
                sb.append("@Column");
            }
        });
    }

    private ICompilationUnit createTestEntityWithColumn() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name();");
        this.createAnnotationAndMembers("Column", "String name(); String table();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(name=\"FOO\", table=\"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdColumnGeneratedValue() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name();");
        this.createAnnotationAndMembers("Column", "String name(); String table();");
        this.createAnnotationAndMembers("GeneratedValue", "");
        this.createAnnotationAndMembers("Id", "");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Column", "javax.persistence.Id", "javax.persistence.GeneratedValue"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append(CR);
                sb.append("@Column");
                sb.append(CR);
                sb.append("@GeneratedValue");
            }
        });
    }

    private ICompilationUnit createTestEntityMultipleColumns() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name();");
        this.createAnnotationAndMembers("Column", "String name();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(name=\"FOO\")");
                sb.append(CR);
                sb.append("@Column(name=\"BAR\")");
            }
        });
    }

    private ICompilationUnit createTestEmbeddedWithAttributeOverride() throws Exception {
        this.createAnnotationAndMembers("Embedded", "String name();");
        this.createAnnotationAndMembers("AttributeOverride", "String name();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embedded", "javax.persistence.AttributeOverride"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded");
                sb.append(CR);
                sb.append("@AttributeOverride(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEmbeddedWithAttributeOverrides() throws Exception {
        this.createAnnotationAndMembers("Embedded", "String name();");
        this.createAnnotationAndMembers("AttributeOverride", "String name();");
        this.createAnnotationAndMembers("AttributeOverrides", "AttributeOverride[] value();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embedded", "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded");
                sb.append(CR);
                sb.append("@AttributeOverrides(@AttributeOverride(name=\"FOO\"))");
            }
        });
    }

    private ICompilationUnit createTestEmbeddedWithAttributeOverridesEmpty() throws Exception {
        this.createAnnotationAndMembers("Embedded", "String name();");
        this.createAnnotationAndMembers("AttributeOverrides", "AttributeOverride[] value();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embedded", "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded");
                sb.append(CR);
                sb.append("@AttributeOverrides()");
            }
        });
    }

    private ICompilationUnit createTestEmbeddedWith2AttributeOverrides() throws Exception {
        this.createAnnotationAndMembers("Embedded", "String name();");
        this.createAnnotationAndMembers("AttributeOverride", "String name();");
        this.createAnnotationAndMembers("AttributeOverrides", "AttributeOverride[] value();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embedded", "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded");
                sb.append(CR);
                sb.append("@AttributeOverrides({@AttributeOverride(name=\"FOO\"), @AttributeOverride(name=\"BAR\")})");
            }
        });
    }

    private ICompilationUnit createTestEmbeddedWithAttributeOverrideAndAttributeOverrides() throws Exception {
        this.createAnnotationAndMembers("Embedded", "String name();");
        this.createAnnotationAndMembers("AttributeOverride", "String name();");
        this.createAnnotationAndMembers("AttributeOverrides", "AttributeOverride[] value();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embedded", "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded");
                sb.append(CR);
                sb.append("@AttributeOverride(name=\"FOO\")");
                sb.append(CR);
                sb.append("@AttributeOverrides({@AttributeOverride(name=\"BAR\"), @AttributeOverride(name=\"BAZ\")})");
            }
        });
    }

    private ICompilationUnit createTestTypePublicAttribute() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("   public String foo;");
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypePackageAttribute() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("   String foo;");
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeFinalAttribute() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("   public final String foo;");
                sb.append(CR);
            }
        });
    }

    public void testJavaAttributeAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertEquals((int)1, (int)attributeResource.annotationsSize());
    }

    public void testJavaAttributeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
    }

    public void testJavaAttributeAnnotationNull() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Table"));
    }

    public void testDuplicateAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestEntityMultipleColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation columnResource = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaResourcePersistentAttributeTests.assertEquals((String)"FOO", (String)columnResource.getName());
    }

    public void testRemoveColumn() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        attributeResource.removeAnnotation("javax.persistence.Column");
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testRemoveColumnName() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ColumnAnnotation columnResource = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        columnResource.setTable(null);
        this.assertSourceContains("@Column(name=\"FOO\")", cu);
        columnResource.setName(null);
        this.assertSourceDoesNotContain("@Column", cu);
        JavaResourcePersistentAttributeTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Table"));
    }

    public void testMultipleAttributeMappings() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithIdAndBasic();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertEquals((int)2, (int)attributeResource.mappingAnnotationsSize());
        JavaResourcePersistentAttributeTests.assertEquals((int)0, (int)attributeResource.annotationsSize());
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaResourceNode javaAttributeMappingAnnotation = attributeResource.getMappingAnnotation();
        JavaResourcePersistentAttributeTests.assertTrue((boolean)(javaAttributeMappingAnnotation instanceof BasicAnnotation));
        this.assertSourceContains("@Basic", cu);
        this.assertSourceContains("@Id", cu);
        this.createAnnotationAndMembers("OneToMany", "");
        attributeResource.setMappingAnnotation("javax.persistence.OneToMany");
        JavaResourcePersistentAttributeTests.assertEquals((int)1, (int)attributeResource.mappingAnnotationsSize());
        javaAttributeMappingAnnotation = attributeResource.getMappingAnnotation();
        JavaResourcePersistentAttributeTests.assertTrue((boolean)(javaAttributeMappingAnnotation instanceof OneToManyAnnotation));
        this.assertSourceDoesNotContain("@Id", cu);
        this.assertSourceContains("@OneToMany", cu);
        this.assertSourceDoesNotContain("@Basic", cu);
    }

    public void testSetJavaAttributeMappingAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertEquals((int)0, (int)attributeResource.mappingAnnotationsSize());
        this.createAnnotationAndMembers("Id", "");
        attributeResource.setMappingAnnotation("javax.persistence.Id");
        JavaResourcePersistentAttributeTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof IdAnnotation));
        this.assertSourceContains("@Id", cu);
    }

    public void testSetJavaAttributeMappingAnnotation2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertNull((Object)attributeResource.getMappingAnnotation());
        this.createAnnotationAndMembers("Id", "");
        attributeResource.setMappingAnnotation("javax.persistence.Id");
        JavaResourcePersistentAttributeTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof IdAnnotation));
        this.assertSourceContains("@Id", cu);
        this.assertSourceContains("@Column", cu);
    }

    public void testSetJavaAttributeMappingAnnotation3() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithIdColumnGeneratedValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof IdAnnotation));
        this.createAnnotationAndMembers("Basic", "");
        attributeResource.setMappingAnnotation("javax.persistence.Basic");
        JavaResourcePersistentAttributeTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof BasicAnnotation));
        this.assertSourceDoesNotContain("@Id", cu);
        this.assertSourceContains("@GeneratedValue", cu);
        this.assertSourceContains("@Column", cu);
    }

    public void testSetJavaAttributeMappingAnnotationNull() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithIdColumnGeneratedValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof IdAnnotation));
        attributeResource.setMappingAnnotation(null);
        JavaResourcePersistentAttributeTests.assertNull((Object)attributeResource.getMappingAnnotation());
        this.assertSourceDoesNotContain("@Id", cu);
        this.assertSourceContains("@GeneratedValue", cu);
        this.assertSourceContains("@Column", cu);
    }

    public void testAddJavaAttributeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        this.assertSourceDoesNotContain("@Column", cu);
        attributeResource.addAnnotation("javax.persistence.Column");
        this.assertSourceContains("@Column", cu);
    }

    public void testRemoveJavaAttributeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntityAnnotatedField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        this.assertSourceContains("@Column", cu);
        attributeResource.removeAnnotation("javax.persistence.Column");
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testChangeAttributeMappingInSource() throws Exception {
        ICompilationUnit cu = this.createTestEntityAnnotatedField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        final JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        this.idField(cu).edit(new Member.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ((IdImpl)attributeResource.getMappingAnnotation()).getDeclarationAnnotationAdapter().removeAnnotation(declaration);
            }
        });
        this.createAnnotationAndMembers("OneToOne", "");
        cu.createImport("javax.persistence.OneToOne", null, (IProgressMonitor)new NullProgressMonitor());
        this.idField(cu).edit(new Member.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                OneToOneImpl.DECLARATION_ANNOTATION_ADAPTER.newMarkerAnnotation(declaration);
            }
        });
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaResourcePersistentAttributeTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToOne"));
        this.assertSourceContains("@Column", cu);
    }

    public void testJavaAttributeAnnotationsNestable() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverride();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides").next();
        JavaResourcePersistentAttributeTests.assertEquals((String)"FOO", (String)attributeOverride.getName());
    }

    public void testJavaAttributeAnnotationsNoNestable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
    }

    public void testJavaAttributeAnnotationsContainerNoNestable() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverridesEmpty();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
    }

    public void testJavaAttributeAnnotationsNestableAndContainer() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverrideAndAttributeOverrides();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaResourcePersistentAttributeTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides").next();
        JavaResourcePersistentAttributeTests.assertEquals((String)"BAR", (String)attributeOverrideResource.getName());
    }

    public void testAddJavaAttributeAnnotationNestableContainer() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        this.assertSourceContains("@AttributeOverride(name=\"FOO\")", cu);
    }

    public void testAddJavaAttributeAnnotationNestableContainer2() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverride();
        this.createAnnotationAndMembers("AttributeOverrides", "String name();");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name=\"FOO\"),@AttributeOverride(name=\"BAR\")})", cu);
        JavaResourcePersistentAttributeTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaResourcePersistentAttributeTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
    }

    public void testAddJavaAttributeAnnotationNestableContainer3() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverrides();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name=\"FOO\"),@AttributeOverride(name=\"BAR\")})", cu);
        JavaResourcePersistentAttributeTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaResourcePersistentAttributeTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
    }

    public void testAddJavaAttributeAnnotationNestableContainer5() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverrides();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name=\"BAR\"),@AttributeOverride(name=\"FOO\")})", cu);
        JavaResourcePersistentAttributeTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaResourcePersistentAttributeTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
    }

    public void testAddJavaAttributeAnnotationNestableContainer4() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverrideAndAttributeOverrides();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaResourcePersistentAttributeTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(2, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name=\"BAR\"), @AttributeOverride(name=\"BAZ\"),", cu);
        this.assertSourceContains("@AttributeOverride})", cu);
        attributeOverride.setName("BOO");
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaResourcePersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaResourcePersistentAttributeTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides")));
        Iterator attributeOverrideAnnotations = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride = (AttributeOverrideAnnotation)attributeOverrideAnnotations.next();
        JavaResourcePersistentAttributeTests.assertEquals((String)"BAR", (String)attributeOverride.getName());
        attributeOverride = (AttributeOverrideAnnotation)attributeOverrideAnnotations.next();
        JavaResourcePersistentAttributeTests.assertEquals((String)"BAZ", (String)attributeOverride.getName());
        attributeOverride = (AttributeOverrideAnnotation)attributeOverrideAnnotations.next();
        JavaResourcePersistentAttributeTests.assertEquals((String)"BOO", (String)attributeOverride.getName());
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name=\"BAR\"), @AttributeOverride(name=\"BAZ\"),", cu);
        this.assertSourceContains("@AttributeOverride(name=\"BOO\")})", cu);
    }

    public void testRemoveJavaAttributeAnnotationNestableContainer() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverride();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.assertSourceDoesNotContain("@AttributeOverride", cu);
    }

    public void testRemoveJavaAttributeAnnotationNestableContainer2() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverrides();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.assertSourceDoesNotContain("@AttributeOverride", cu);
        this.assertSourceDoesNotContain("@AttributeOverrides", cu);
    }

    public void testRemoveJavaAttributeAnnotationIndex() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWith2AttributeOverrides();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.assertSourceDoesNotContain("@AttributeOverride(name=\"FOO\"", cu);
        this.assertSourceContains("@AttributeOverride(name=\"BAR\"", cu);
        this.assertSourceDoesNotContain("@AttributeOverrides", cu);
    }

    public void testRemoveJavaAttributeAnnotationIndex2() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWith2AttributeOverrides();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation newAnnotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(2, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name=\"FOO\"), @AttributeOverride(name=\"BAR\"),", cu);
        this.assertSourceContains("@AttributeOverride(name=\"BAZ\")})", cu);
        attributeResource.removeAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name=\"FOO\"), @AttributeOverride(name=\"BAZ\")})", cu);
    }

    public void testMoveJavaTypeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWith2AttributeOverrides();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation newAnnotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(2, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name=\"FOO\"), @AttributeOverride(name=\"BAR\"),", cu);
        this.assertSourceContains("@AttributeOverride(name=\"BAZ\")})", cu);
        attributeResource.move(0, 2, "javax.persistence.AttributeOverrides");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name=\"BAZ\"), @AttributeOverride(name=\"FOO\"),", cu);
        this.assertSourceContains("@AttributeOverride(name=\"BAR\")})", cu);
    }

    public void testMoveJavaTypeAnnotation2() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWith2AttributeOverrides();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AttributeOverrideAnnotation newAnnotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(2, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name=\"FOO\"), @AttributeOverride(name=\"BAR\"),", cu);
        this.assertSourceContains("@AttributeOverride(name=\"BAZ\")})", cu);
        attributeResource.move(1, 0, "javax.persistence.AttributeOverrides");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name=\"BAR\"), @AttributeOverride(name=\"FOO\"),", cu);
        this.assertSourceContains("@AttributeOverride(name=\"BAZ\")})", cu);
    }

    public void testIsPersistableField() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JavaResourcePersistentAttributeTests.assertTrue((boolean)attributeResource.isPersistable());
    }

    public void testIsPersistableField2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithNonResolvingField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        List attributes = (List)ClassTools.fieldValue((Object)typeResource, (String)"fields");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)attributes.get(0);
        JavaResourcePersistentAttributeTests.assertEquals((String)"foo", (String)attributeResource.getName());
        JavaResourcePersistentAttributeTests.assertTrue((boolean)attributeResource.isForField());
        JavaResourcePersistentAttributeTests.assertTrue((boolean)attributeResource.isPersistable());
        this.javaProject.createCompilationUnit("test", "Foo.java", "public class Foo {}");
        this.javaResourceModel.resolveTypes();
        JavaResourcePersistentAttributeTests.assertTrue((boolean)attributeResource.isPersistable());
    }

    public void testGetQualifiedTypeName() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithNonResolvingField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        List attributes = (List)ClassTools.fieldValue((Object)typeResource, (String)"fields");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)attributes.get(0);
        JavaResourcePersistentAttributeTests.assertEquals((String)"foo", (String)attributeResource.getName());
        JavaResourcePersistentAttributeTests.assertEquals((String)"test.Foo", (String)attributeResource.getQualifiedTypeName());
        this.javaProject.createCompilationUnit("test", "Foo.java", "public class Foo {}");
        this.javaResourceModel.resolveTypes();
        JavaResourcePersistentAttributeTests.assertEquals((String)"test.Foo", (String)attributeResource.getQualifiedTypeName());
    }

    public void testIsPersistableMethod() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.properties().next();
        JavaResourcePersistentAttributeTests.assertTrue((boolean)attributeResource.isPersistable());
    }

    public void testIsPersistableMethod2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithNonResolvingMethod();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        List attributes = (List)ClassTools.fieldValue((Object)typeResource, (String)"methods");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)attributes.get(0);
        JavaResourcePersistentAttributeTests.assertEquals((String)"foo", (String)attributeResource.getName());
        JavaResourcePersistentAttributeTests.assertTrue((boolean)attributeResource.isForProperty());
        JavaResourcePersistentAttributeTests.assertTrue((boolean)attributeResource.isPersistable());
        this.javaProject.createCompilationUnit("test", "Foo.java", "public class Foo {}");
        this.javaResourceModel.resolveTypes();
        JavaResourcePersistentAttributeTests.assertTrue((boolean)attributeResource.isPersistable());
    }

    public void testMultipleVariableDeclarationsPerLine() throws Exception {
        ICompilationUnit cu = this.createTestEntityMultipleVariableDeclarationsPerLine();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttributeTests.assertEquals((int)4, (int)CollectionTools.size((Iterator)typeResource.fields()));
        Iterator fields = typeResource.fields();
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)fields.next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaResourcePersistentAttributeTests.assertEquals((String)"baz", (String)column.getName());
        attributeResource = (JavaResourcePersistentAttribute)fields.next();
        column = (ColumnAnnotation)attributeResource.getAnnotation("javax.persistence.Column");
        JavaResourcePersistentAttributeTests.assertEquals((String)"baz", (String)column.getName());
    }

    public void testIsPublic() throws Exception {
        ICompilationUnit cu = this.createTestTypePublicAttribute();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attribute = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaResourcePersistentAttributeTests.assertTrue((boolean)attribute.isPublic());
    }

    public void testIsPublicFalse() throws Exception {
        ICompilationUnit cu = this.createTestTypePackageAttribute();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attribute = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaResourcePersistentAttributeTests.assertFalse((boolean)attribute.isPublic());
    }

    public void testIsFinal() throws Exception {
        ICompilationUnit cu = this.createTestTypeFinalAttribute();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attribute = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaResourcePersistentAttributeTests.assertTrue((boolean)attribute.isFinal());
    }

    public void testIsFinalFalse() throws Exception {
        ICompilationUnit cu = this.createTestTypePackageAttribute();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attribute = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaResourcePersistentAttributeTests.assertFalse((boolean)attribute.isFinal());
    }
}

