/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.core.resource.java.JpaCompilationUnit;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JpaCompilationUnitTests
extends AnnotationTestCase {
    public JpaCompilationUnitTests(String name) {
        super(name);
    }

    protected TestJavaProject buildJavaProject(String projectName, boolean autoBuild) throws Exception {
        return new TestJpaProject(projectName, autoBuild);
    }

    private void createAnnotationAndMembers(String annotationName, String annotationBody) throws Exception {
        this.javaProject.createCompilationUnit("javax.persistence", String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    private ICompilationUnit createTestEntity() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name();");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    protected JpaCompilationUnit getJpaCompilationUnitResource(ICompilationUnit testCompilationUnit) throws CoreException {
        JpaProject jpaProject = ((TestJpaProject)this.javaProject).getJpaProject();
        JpaFile jpaFile = jpaProject.getJpaFile((IFile)testCompilationUnit.getResource());
        JavaResourceModel javaResourceModel = (JavaResourceModel)jpaFile.getResourceModel();
        return javaResourceModel.getJpaCompilationUnit();
    }

    public void testGetPersistentType() throws Exception {
        ICompilationUnit compilationUnit = this.createTestEntity();
        JpaCompilationUnit jpaCompilationUnit = this.getJpaCompilationUnitResource(compilationUnit);
        JpaCompilationUnitTests.assertTrue((boolean)(jpaCompilationUnit.getPersistentType().getMappingAnnotation() instanceof EntityAnnotation));
    }
}

