/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.core.JpaFactory;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaNode;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.ResourceModel;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.CallbackChangeSupport;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaNode
extends AbstractModel
implements JpaNode,
CallbackChangeSupport.Source {
    private final JpaNode parent;
    private static final HashMap<Class<? extends AbstractJpaNode>, HashSet<String>> nonUpdateAspectNameSets = new HashMap();

    protected AbstractJpaNode(JpaNode parent) {
        this.checkParent(parent);
        this.parent = parent;
    }

    protected void checkParent(JpaNode p) {
        if (p == null) {
            if (this.requiresParent()) {
                throw new IllegalArgumentException("'parent' cannot be null");
            }
        } else if (this.forbidsParent()) {
            throw new IllegalArgumentException("'parent' must be null");
        }
    }

    protected boolean requiresParent() {
        return true;
    }

    protected boolean forbidsParent() {
        return !this.requiresParent();
    }

    protected ChangeSupport buildChangeSupport() {
        return new CallbackChangeSupport((CallbackChangeSupport.Source)this);
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public JpaNode getParent() {
        return this.parent;
    }

    @Override
    public IResource getResource() {
        return this.parent.getResource();
    }

    @Override
    public JpaProject getJpaProject() {
        return this.parent.getJpaProject();
    }

    public String displayString() {
        return this.toString();
    }

    protected JpaPlatform getJpaPlatform() {
        return this.getJpaProject().getJpaPlatform();
    }

    protected JpaFactory getJpaFactory() {
        return this.getJpaPlatform().getJpaFactory();
    }

    protected JpaFile getJpaFile(ResourceModel resourceModel) {
        return this.getJpaProject().getJpaFile(resourceModel.getFile());
    }

    protected ConnectionProfile getConnectionProfile() {
        return this.getJpaProject().getConnectionProfile();
    }

    protected Database getDatabase() {
        return this.getConnectionProfile().getDatabase();
    }

    public boolean connectionProfileIsActive() {
        return this.getConnectionProfile().isActive();
    }

    public void aspectChanged(String aspectName) {
        if (this.aspectTriggersUpdate(aspectName)) {
            this.getJpaProject().update();
        }
    }

    private boolean aspectTriggersUpdate(String aspectName) {
        return !this.aspectDoesNotTriggerUpdate(aspectName);
    }

    private boolean aspectDoesNotTriggerUpdate(String aspectName) {
        return this.nonUpdateAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<String> nonUpdateAspectNames() {
        HashMap<Class<? extends AbstractJpaNode>, HashSet<String>> hashMap = nonUpdateAspectNameSets;
        synchronized (hashMap) {
            HashSet<String> nonUpdateAspectNames = nonUpdateAspectNameSets.get(this.getClass());
            if (nonUpdateAspectNames == null) {
                nonUpdateAspectNames = new HashSet();
                this.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
                nonUpdateAspectNameSets.put(this.getClass(), nonUpdateAspectNames);
            }
            return nonUpdateAspectNames;
        }
    }

    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
    }
}

