/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.jpt.core.JpaDataSource;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.AbstractJpaNode;
import org.eclipse.jpt.db.ConnectionAdapter;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.ConnectionProfileListener;
import org.eclipse.jpt.db.ConnectionProfileRepository;
import org.eclipse.jpt.db.JptDbPlugin;

public class GenericJpaDataSource
extends AbstractJpaNode
implements JpaDataSource {
    protected String connectionProfileName;
    protected transient ConnectionProfile connectionProfile;
    protected final ConnectionProfileListener connectionProfileListener = this.buildConnectionProfileListener();
    protected final ConnectionListener connectionListener;
    private static final long serialVersionUID = 1L;

    private ConnectionProfileRepository getConnectionProfileRepository() {
        return JptDbPlugin.instance().getConnectionProfileRepository();
    }

    public GenericJpaDataSource(JpaProject jpaProject, String connectionProfileName) {
        super(jpaProject);
        this.getConnectionProfileRepository().addConnectionProfileListener(this.connectionProfileListener);
        this.connectionListener = this.buildConnectionListener();
        this.connectionProfileName = connectionProfileName;
        this.connectionProfile = this.connectionProfileNamed(connectionProfileName);
        this.connectionProfile.addConnectionListener(this.connectionListener);
    }

    protected ConnectionProfileListener buildConnectionProfileListener() {
        return new LocalConnectionProfileListener();
    }

    protected ConnectionListener buildConnectionListener() {
        return new LocalConnectionListener();
    }

    public String getConnectionProfileName() {
        return this.connectionProfileName;
    }

    public void setConnectionProfileName(String connectionProfileName) {
        String old = this.connectionProfileName;
        this.connectionProfileName = connectionProfileName;
        this.firePropertyChanged("connectionProfileName", old, connectionProfileName);
        this.setConnectionProfile(this.connectionProfileNamed(connectionProfileName));
    }

    public ConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    public boolean hasAConnection() {
        return !this.connectionProfile.isNull();
    }

    public void dispose() {
        this.connectionProfile.removeConnectionListener(this.connectionListener);
        this.getConnectionProfileRepository().removeConnectionProfileListener(this.connectionProfileListener);
    }

    private ConnectionProfile connectionProfileNamed(String name) {
        return this.getConnectionProfileRepository().connectionProfileNamed(name);
    }

    protected void setConnectionProfile(ConnectionProfile connectionProfile) {
        ConnectionProfile old = this.connectionProfile;
        this.connectionProfile.removeConnectionListener(this.connectionListener);
        this.connectionProfile = connectionProfile;
        this.connectionProfile.addConnectionListener(this.connectionListener);
        this.firePropertyChanged("connectionProfile", old, connectionProfile);
    }

    public boolean connectionProfileIsActive() {
        return this.connectionProfile.isActive();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.connectionProfileName);
    }

    protected class LocalConnectionListener
    extends ConnectionAdapter {
        protected LocalConnectionListener() {
        }

        public void opened(ConnectionProfile profile) {
            GenericJpaDataSource.this.getJpaProject().update();
        }

        public void closed(ConnectionProfile profile) {
            GenericJpaDataSource.this.getJpaProject().update();
        }
    }

    protected class LocalConnectionProfileListener
    implements ConnectionProfileListener {
        protected LocalConnectionProfileListener() {
        }

        public void connectionProfileChanged(ConnectionProfile profile) {
            if (profile == GenericJpaDataSource.this.connectionProfile) {
                GenericJpaDataSource.this.setConnectionProfileName(profile.getName());
                JptCorePlugin.setConnectionProfileName(GenericJpaDataSource.this.getJpaProject().getProject(), profile.getName());
            }
        }

        public void connectionProfileReplaced(ConnectionProfile oldProfile, ConnectionProfile newProfile) {
            if (GenericJpaDataSource.this.hasAConnection() && oldProfile == GenericJpaDataSource.this.connectionProfile) {
                GenericJpaDataSource.this.setConnectionProfile(newProfile);
            }
        }
    }
}

