/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.JavaResourcePersistentTypeImpl;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JpaCompilationUnit;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.utility.CommandExecutorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaCompilationUnitImpl
extends AbstractJavaResourceNode
implements JpaCompilationUnit {
    protected final JpaAnnotationProvider annotationProvider;
    protected final CommandExecutorProvider modifySharedDocumentCommandExecutorProvider;
    protected final AnnotationEditFormatter annotationEditFormatter;
    protected final JavaResourceModel javaResourceModel;
    protected final ICompilationUnit compilationUnit;
    protected JavaResourcePersistentType persistentType;

    public JpaCompilationUnitImpl(IFile file, JpaAnnotationProvider annotationProvider, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter, JavaResourceModel javaResourceModel) {
        super(null);
        this.annotationProvider = annotationProvider;
        this.modifySharedDocumentCommandExecutorProvider = modifySharedDocumentCommandExecutorProvider;
        this.annotationEditFormatter = annotationEditFormatter;
        this.javaResourceModel = javaResourceModel;
        this.compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
        this.openCompilationUnit();
        this.persistentType = this.buildJavaResourcePersistentType();
    }

    protected void openCompilationUnit() {
        try {
            this.compilationUnit.open(null);
        }
        catch (JavaModelException javaModelException) {}
    }

    protected JavaResourcePersistentType buildJavaResourcePersistentType() {
        return this.buildJavaResourcePersistentType(this.buildASTRoot());
    }

    protected JavaResourcePersistentType buildJavaResourcePersistentType(CompilationUnit astRoot) {
        TypeDeclaration td = this.getPrimaryType(astRoot);
        return td == null ? null : this.buildJavaResourcePersistentType(astRoot, td);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public JpaCompilationUnit getJpaCompilationUnit() {
        return this;
    }

    @Override
    public JpaAnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    @Override
    public CommandExecutorProvider getModifySharedDocumentCommandExecutorProvider() {
        return this.modifySharedDocumentCommandExecutorProvider;
    }

    @Override
    public AnnotationEditFormatter getAnnotationEditFormatter() {
        return this.annotationEditFormatter;
    }

    @Override
    public JavaResourceModel getResourceModel() {
        return this.javaResourceModel;
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    @Override
    public JavaResourcePersistentType getJavaPersistentTypeResource(String fullyQualifiedTypeName) {
        return this.persistentType == null ? null : this.persistentType.getJavaPersistentTypeResource(fullyQualifiedTypeName);
    }

    @Override
    public JavaResourcePersistentType getPersistentType() {
        return this.persistentType;
    }

    protected void setPersistentType(JavaResourcePersistentType persistentType) {
        JavaResourcePersistentType old = this.persistentType;
        this.persistentType = persistentType;
        this.firePropertyChanged("persistentType", old, persistentType);
    }

    @Override
    public void updateFromJava() {
        this.updateFromJava(this.buildASTRoot());
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        TypeDeclaration td = this.getPrimaryType(astRoot);
        if (td == null) {
            this.setPersistentType(null);
        } else if (this.persistentType == null) {
            this.setPersistentType(this.buildJavaResourcePersistentType(astRoot, td));
        } else {
            this.persistentType.updateFromJava(astRoot);
        }
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return null;
    }

    @Override
    public void resourceChanged() {
        this.javaResourceModel.resourceChanged();
    }

    @Override
    public void resolveTypes() {
        if (this.persistentType != null) {
            this.persistentType.resolveTypes(this.buildASTRoot());
        }
    }

    protected CompilationUnit buildASTRoot() {
        return JDTTools.buildASTRoot(this.compilationUnit);
    }

    protected JavaResourcePersistentType buildJavaResourcePersistentType(CompilationUnit astRoot, TypeDeclaration typeDeclaration) {
        return JavaResourcePersistentTypeImpl.newInstance(this, typeDeclaration, astRoot);
    }

    protected TypeDeclaration getPrimaryType(CompilationUnit astRoot) {
        String primaryTypeName = this.getPrimaryTypeName();
        for (AbstractTypeDeclaration atd : JpaCompilationUnitImpl.types(astRoot)) {
            if (atd.getNodeType() != 55 || !atd.getName().getFullyQualifiedName().equals(primaryTypeName)) continue;
            return atd.resolveBinding() != null ? (TypeDeclaration)atd : null;
        }
        return null;
    }

    protected static List<AbstractTypeDeclaration> types(CompilationUnit astRoot) {
        return astRoot.types();
    }

    protected String getPrimaryTypeName() {
        return JpaCompilationUnitImpl.removeJavaExtension(this.compilationUnit.getElementName());
    }

    protected static String removeJavaExtension(String fileName) {
        int index = fileName.lastIndexOf(".java");
        return index == -1 ? fileName : fileName.substring(0, index);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.persistentType.getName());
    }
}

