/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTMember;
import org.eclipse.jpt.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.CommandExecutorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTType
extends JDTMember
implements Type {
    public JDTType(TypeDeclaration typeDeclaration, ICompilationUnit compilationUnit, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider) {
        this(typeDeclaration, compilationUnit, modifySharedDocumentCommandExecutorProvider, DefaultAnnotationEditFormatter.instance());
    }

    public JDTType(TypeDeclaration typeDeclaration, ICompilationUnit compilationUnit, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter) {
        this(null, typeDeclaration, 1, compilationUnit, modifySharedDocumentCommandExecutorProvider, annotationEditFormatter);
    }

    public JDTType(Type declaringType, TypeDeclaration typeDeclaration, int occurrence, ICompilationUnit compilationUnit, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider) {
        this(declaringType, typeDeclaration, occurrence, compilationUnit, modifySharedDocumentCommandExecutorProvider, (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    public JDTType(Type declaringType, TypeDeclaration typeDeclaration, int occurrence, ICompilationUnit compilationUnit, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter) {
        super(declaringType, typeDeclaration.getName().getFullyQualifiedName(), occurrence, compilationUnit, modifySharedDocumentCommandExecutorProvider, annotationEditFormatter);
    }

    public JDTType(Type declaringType, String name, int occurrence, ICompilationUnit compilationUnit) {
        super(declaringType, name, occurrence, compilationUnit, CommandExecutorProvider.Default.instance(), DefaultAnnotationEditFormatter.instance());
    }

    @Override
    public ITypeBinding getBinding(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).resolveBinding();
    }

    @Override
    public TypeDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        Type declaringType = this.getDeclaringType();
        return declaringType == null ? this.getTopLevelTypeDeclaration(astRoot) : this.getNestedTypeDeclaration(declaringType.getBodyDeclaration(astRoot));
    }

    @Override
    public boolean isPersistable(CompilationUnit astRoot) {
        ITypeBinding binding = this.getBinding(astRoot);
        return binding == null ? false : JPTTools.typeIsPersistable(binding);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return new ASTNodeTextRange((ASTNode)this.getBodyDeclaration(astRoot).getName());
    }

    @Override
    public TypeDeclaration[] getTypes(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).getTypes();
    }

    @Override
    public FieldDeclaration[] getFields(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).getFields();
    }

    @Override
    public MethodDeclaration[] getMethods(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).getMethods();
    }

    protected TypeDeclaration getTopLevelTypeDeclaration(CompilationUnit astRoot) {
        return this.getTypeDeclaration(JDTType.types(astRoot));
    }

    protected TypeDeclaration getTypeDeclaration(List<TypeDeclaration> typeDeclarations) {
        return this.getTypeDeclaration(typeDeclarations.toArray(new TypeDeclaration[typeDeclarations.size()]));
    }

    protected TypeDeclaration getNestedTypeDeclaration(TypeDeclaration declaringTypeDeclaration) {
        return this.getTypeDeclaration(declaringTypeDeclaration.getTypes());
    }

    protected TypeDeclaration getTypeDeclaration(TypeDeclaration[] typeDeclarations) {
        String name = this.getName_();
        int occurrence = this.getOccurrence();
        int count = 0;
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration typeDeclaration = typeDeclarationArray[n2];
            if (typeDeclaration.getName().getFullyQualifiedName().equals(name) && ++count == occurrence) {
                return typeDeclaration;
            }
            ++n2;
        }
        return null;
    }

    protected static List<TypeDeclaration> types(CompilationUnit astRoot) {
        return astRoot.types();
    }
}

