/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsf.common.internal.policy.OrderedListProvider;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.DefaultJSPTagResolver;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TagIntrospectingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence.PersistedDataTagStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLDRegistryPreferences {
    private final IPreferenceStore _prefStore;
    private static final String KEY_STRATEGY_ID_ORDER = "org.eclipse.jst.jsf.designtime.jsp.registry.StrategyIDOrder";
    private static final List<OrderedListProvider.OrderableObject> DEFAULT_STRATEGY_ORDER;
    private List<OrderedListProvider.OrderableObject> _ids;
    private List<OrderedListProvider.OrderableObject> _originalIds;

    static {
        ArrayList<OrderedListProvider.OrderableObject> list = new ArrayList<OrderedListProvider.OrderableObject>();
        list.add(new OrderedListProvider.OrderableObject((Object)new StrategyIdentifier(PersistedDataTagStrategy.DISPLAY_NAME, "org.eclipse.jst.jsf.designtime.PersistedDataTagStrategy"), true));
        list.add(new OrderedListProvider.OrderableObject((Object)new StrategyIdentifier(DefaultJSPTagResolver.DISPLAY_NAME, "org.eclipse.jst.jsf.metadata.DefaultJSPTagResolver"), true));
        list.add(new OrderedListProvider.OrderableObject((Object)new StrategyIdentifier(TagIntrospectingStrategy.DISPLAY_NAME, "org.eclipse.jst.jsf.designtime.TagIntrospectingStrategy"), true));
        DEFAULT_STRATEGY_ORDER = Collections.unmodifiableList(list);
    }

    public TLDRegistryPreferences(IPreferenceStore prefStore) {
        this._prefStore = prefStore;
        this._ids = new ArrayList<OrderedListProvider.OrderableObject>();
    }

    public void load() {
        this.load(this._prefStore);
    }

    public OrderedListProvider getOrderedListProvider() {
        return new MyOrderedListProvider();
    }

    public List<OrderedListProvider.OrderableObject> getStrategyIdOrdering() {
        return this._ids;
    }

    public void setStrategyIdOrdering(List<OrderedListProvider.OrderableObject> ids) {
        this._ids = ids;
    }

    public List<String> getEnabledIds() {
        ArrayList<String> strategies = new ArrayList<String>();
        for (OrderedListProvider.OrderableObject id : this._ids) {
            if (!id.isEnabled()) continue;
            StrategyIdentifier strategyId = (StrategyIdentifier)id.getObject();
            strategies.add(strategyId.getId());
        }
        return strategies;
    }

    private void load(IPreferenceStore prefStore) {
        List<OrderedListProvider.OrderableObject> ids;
        if (!prefStore.contains(KEY_STRATEGY_ID_ORDER)) {
            prefStore.setDefault(KEY_STRATEGY_ID_ORDER, this.serialize(DEFAULT_STRATEGY_ORDER));
        }
        if ((ids = this.deserialize(prefStore.getString(KEY_STRATEGY_ID_ORDER))) == null) {
            ids = this.deserialize(this.serialize(DEFAULT_STRATEGY_ORDER));
        }
        this._ids = ids;
        ArrayList<OrderedListProvider.OrderableObject> originalList = new ArrayList<OrderedListProvider.OrderableObject>();
        for (OrderedListProvider.OrderableObject id : this._ids) {
            OrderedListProvider.OrderableObject copy = id.clone();
            originalList.add(copy);
        }
        this._originalIds = Collections.unmodifiableList(originalList);
    }

    private String serialize(List<OrderedListProvider.OrderableObject> ids) {
        StringBuffer buffer = new StringBuffer();
        for (OrderedListProvider.OrderableObject id : ids) {
            StrategyIdentifier strategyId = (StrategyIdentifier)id.getObject();
            buffer.append(strategyId.getDisplayName());
            buffer.append(",");
            buffer.append(strategyId.getId());
            buffer.append(",");
            buffer.append(id.isEnabled());
            buffer.append(",");
        }
        return buffer.toString();
    }

    private List<OrderedListProvider.OrderableObject> deserialize(String serializedList) {
        ArrayList<OrderedListProvider.OrderableObject> list = new ArrayList<OrderedListProvider.OrderableObject>();
        String[] ids = serializedList.split(",");
        if (ids.length % 3 != 0) {
            return new ArrayList<OrderedListProvider.OrderableObject>();
        }
        int i = 0;
        while (i < ids.length) {
            String displayName = ids[i];
            String id = ids[i + 1];
            String enabled = ids[i + 2];
            if ("org.eclipse.jst.jsf.THISISTEMPORARY".equals(id)) {
                id = "org.eclipse.jst.jsf.metadata.DefaultJSPTagResolver";
            }
            StrategyIdentifier strategyIdentifier = new StrategyIdentifier(displayName, id);
            list.add(new OrderedListProvider.OrderableObject((Object)strategyIdentifier, Boolean.valueOf(enabled).booleanValue()));
            i += 3;
        }
        return list;
    }

    public void commit(IPreferenceStore prefStore) {
        prefStore.setValue(KEY_STRATEGY_ID_ORDER, this.serialize(this.getStrategyIdOrdering()));
    }

    public void setDefaults() {
        this.setStrategyIdOrdering(new ArrayList<OrderedListProvider.OrderableObject>(DEFAULT_STRATEGY_ORDER));
    }

    public boolean isDirty() {
        return !this._ids.equals(this._originalIds);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyOrderedListProvider
    extends OrderedListProvider {
        private MyOrderedListProvider() {
        }

        protected List<OrderedListProvider.OrderableObject> createAndPopulateOrderedObjects() {
            return TLDRegistryPreferences.this._ids;
        }
    }

    public static class StrategyIdentifier {
        private final String _id;
        private final String _displayName;

        StrategyIdentifier(String displayName, String id) {
            this._displayName = displayName;
            this._id = id;
        }

        public String getId() {
            return this._id;
        }

        public String getDisplayName() {
            return this._displayName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StrategyIdentifier) {
                return this._id.equals(((StrategyIdentifier)obj)._id);
            }
            return false;
        }

        public int hashCode() {
            return this._id.hashCode();
        }
    }
}

