/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfigurationWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatServerWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.jst.server.tomcat.core.internal.command.AddModuleCommand;
import org.eclipse.jst.server.tomcat.core.internal.command.AddWebModuleCommand;
import org.eclipse.jst.server.tomcat.core.internal.command.ModifyWebModuleCommand;
import org.eclipse.jst.server.tomcat.core.internal.command.RemoveModuleCommand;
import org.eclipse.jst.server.tomcat.core.internal.command.RemoveWebModuleCommand;
import org.eclipse.jst.server.tomcat.ui.internal.Messages;
import org.eclipse.jst.server.tomcat.ui.internal.TomcatUIPlugin;
import org.eclipse.jst.server.tomcat.ui.internal.editor.WebModuleDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;

public class ConfigurationWebModuleEditorPart
extends ServerEditorPart {
    protected ITomcatServerWorkingCopy server2;
    protected TomcatConfiguration configuration;
    protected Table webAppTable;
    protected int selection = -1;
    protected Button addProject;
    protected Button addExtProject;
    protected Button remove;
    protected Button edit;
    protected PropertyChangeListener listener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void addChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("modifyWebModule".equals(event.getPropertyName())) {
                    ConfigurationWebModuleEditorPart.this.initialize();
                } else if ("addWebModule".equals(event.getPropertyName())) {
                    ConfigurationWebModuleEditorPart.this.initialize();
                } else if ("removeWebModule".equals(event.getPropertyName())) {
                    ConfigurationWebModuleEditorPart.this.initialize();
                }
            }
        };
        this.configuration.addPropertyChangeListener(this.listener);
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        toolkit.decorateFormHeading(form.getForm());
        form.setText(Messages.configurationEditorWebModulesPageTitle);
        form.setImage(TomcatUIPlugin.getImage("webModule"));
        GridLayout layout = new GridLayout();
        layout.marginTop = 6;
        layout.marginLeft = 6;
        form.getBody().setLayout((Layout)layout);
        Section section = toolkit.createSection(form.getBody(), 384);
        section.setText(Messages.configurationEditorWebModulesSection);
        section.setDescription(Messages.configurationEditorWebModulesDescription);
        section.setLayoutData((Object)new GridData(1808));
        Composite composite = toolkit.createComposite((Composite)section);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.jst.server.tomcat.ui.tecw0000");
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.webAppTable = toolkit.createTable(composite, 66052);
        this.webAppTable.setHeaderVisible(true);
        this.webAppTable.setLinesVisible(true);
        whs.setHelp((Control)this.webAppTable, "org.eclipse.jst.server.tomcat.ui.tecw0002");
        TableLayout tableLayout = new TableLayout();
        TableColumn col = new TableColumn(this.webAppTable, 0);
        col.setText(Messages.configurationEditorPathColumn);
        ColumnWeightData colData = new ColumnWeightData(8, 85, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        TableColumn col2 = new TableColumn(this.webAppTable, 0);
        col2.setText(Messages.configurationEditorDocBaseColumn);
        colData = new ColumnWeightData(13, 135, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        TableColumn col3 = new TableColumn(this.webAppTable, 0);
        col3.setText(Messages.configurationEditorProjectColumn);
        colData = new ColumnWeightData(8, 85, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        TableColumn col4 = new TableColumn(this.webAppTable, 0);
        col4.setText(Messages.configurationEditorReloadColumn);
        colData = new ColumnWeightData(7, 75, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        this.webAppTable.setLayout((Layout)tableLayout);
        GridData data = new GridData(768);
        data.widthHint = 450;
        data.heightHint = 120;
        this.webAppTable.setLayoutData((Object)data);
        this.webAppTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationWebModuleEditorPart.this.selectWebApp();
            }
        });
        Composite rightPanel = toolkit.createComposite(composite);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        rightPanel.setLayout((Layout)layout);
        data = new GridData();
        rightPanel.setLayoutData((Object)new GridData(258));
        this.addProject = toolkit.createButton(rightPanel, Messages.configurationEditorAddProjectModule, 8);
        data = new GridData(768);
        this.addProject.setLayoutData((Object)data);
        whs.setHelp((Control)this.addProject, "org.eclipse.jst.server.tomcat.ui.tecw0004");
        if (!this.canAddWebModule()) {
            this.addProject.setEnabled(false);
        } else {
            this.addProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WebModuleDialog dialog = new WebModuleDialog(ConfigurationWebModuleEditorPart.this.getEditorSite().getShell(), (IServerAttributes)ConfigurationWebModuleEditorPart.this.getServer(), (ITomcatServer)ConfigurationWebModuleEditorPart.this.server2, (ITomcatConfiguration)ConfigurationWebModuleEditorPart.this.configuration, true);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        ConfigurationWebModuleEditorPart.this.execute((IUndoableOperation)new AddModuleCommand(ConfigurationWebModuleEditorPart.this.getServer(), dialog.module4));
                    }
                }
            });
        }
        this.addExtProject = toolkit.createButton(rightPanel, Messages.configurationEditorAddExternalModule, 8);
        data = new GridData(768);
        this.addExtProject.setLayoutData((Object)data);
        this.addExtProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebModuleDialog dialog = new WebModuleDialog(ConfigurationWebModuleEditorPart.this.getEditorSite().getShell(), (IServerAttributes)ConfigurationWebModuleEditorPart.this.getServer(), (ITomcatServer)ConfigurationWebModuleEditorPart.this.server2, (ITomcatConfiguration)ConfigurationWebModuleEditorPart.this.configuration, false);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    ConfigurationWebModuleEditorPart.this.execute((IUndoableOperation)new AddWebModuleCommand((ITomcatConfigurationWorkingCopy)ConfigurationWebModuleEditorPart.this.configuration, dialog.getWebModule()));
                }
            }
        });
        whs.setHelp((Control)this.addExtProject, "org.eclipse.jst.server.tomcat.ui.tecw0006");
        this.edit = toolkit.createButton(rightPanel, Messages.editorEdit, 8);
        data = new GridData(768);
        this.edit.setLayoutData((Object)data);
        this.edit.setEnabled(false);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigurationWebModuleEditorPart.this.selection < 0) {
                    return;
                }
                WebModule module = (WebModule)ConfigurationWebModuleEditorPart.this.configuration.getWebModules().get(ConfigurationWebModuleEditorPart.this.selection);
                WebModuleDialog dialog = new WebModuleDialog(ConfigurationWebModuleEditorPart.this.getEditorSite().getShell(), (IServerAttributes)ConfigurationWebModuleEditorPart.this.getServer(), (ITomcatServer)ConfigurationWebModuleEditorPart.this.server2, (ITomcatConfiguration)ConfigurationWebModuleEditorPart.this.configuration, module);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    ConfigurationWebModuleEditorPart.this.execute((IUndoableOperation)new ModifyWebModuleCommand((ITomcatConfigurationWorkingCopy)ConfigurationWebModuleEditorPart.this.configuration, ConfigurationWebModuleEditorPart.this.selection, dialog.getWebModule()));
                }
            }
        });
        whs.setHelp((Control)this.edit, "org.eclipse.jst.server.tomcat.ui.tecw0008");
        this.remove = toolkit.createButton(rightPanel, Messages.editorRemove, 8);
        data = new GridData(768);
        this.remove.setLayoutData((Object)data);
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigurationWebModuleEditorPart.this.selection < 0) {
                    return;
                }
                TableItem item = ConfigurationWebModuleEditorPart.this.webAppTable.getItem(ConfigurationWebModuleEditorPart.this.selection);
                if (item.getData() != null) {
                    IModule module = (IModule)item.getData();
                    ConfigurationWebModuleEditorPart.this.execute((IUndoableOperation)new RemoveModuleCommand(ConfigurationWebModuleEditorPart.this.getServer(), module));
                } else {
                    ConfigurationWebModuleEditorPart.this.execute((IUndoableOperation)new RemoveWebModuleCommand((ITomcatConfigurationWorkingCopy)ConfigurationWebModuleEditorPart.this.configuration, ConfigurationWebModuleEditorPart.this.selection));
                }
                ConfigurationWebModuleEditorPart.this.remove.setEnabled(false);
                ConfigurationWebModuleEditorPart.this.edit.setEnabled(false);
                ConfigurationWebModuleEditorPart.this.selection = -1;
            }
        });
        whs.setHelp((Control)this.remove, "org.eclipse.jst.server.tomcat.ui.tecw0010");
        form.setContent((Control)section);
        form.reflow(true);
        this.initialize();
    }

    protected boolean canAddWebModule() {
        IModule[] modules = ServerUtil.getModules((IModuleType[])this.server.getServerType().getRuntimeType().getModuleTypes());
        if (modules != null) {
            int size = modules.length;
            int i = 0;
            while (i < size) {
                IStatus status;
                IWebModule webModule;
                IModule iModule = modules[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jst.server.core.IWebModule");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((webModule = (IWebModule)iModule.loadAdapter((Class)clazz, null)) != null && (status = this.server.canModifyModules(new IModule[]{modules[i]}, null, null)) != null && status.isOK()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.configuration != null) {
            this.configuration.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TomcatServer ts = (TomcatServer)this.server.loadAdapter((Class)clazz, null);
        try {
            this.configuration = ts.getTomcatConfiguration();
        }
        catch (Exception exception) {}
        if (this.configuration != null) {
            this.addChangeListener();
        }
        if (this.server != null) {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.ITomcatServerWorkingCopy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.server2 = (ITomcatServerWorkingCopy)this.server.loadAdapter((Class)clazz2, null);
        }
        this.initialize();
    }

    protected void initialize() {
        if (this.webAppTable == null) {
            return;
        }
        this.webAppTable.removeAll();
        this.setErrorMessage(null);
        ILabelProvider labelProvider = ServerUICore.getLabelProvider();
        List list = this.configuration.getWebModules();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            WebModule module = (WebModule)iterator.next();
            TableItem item = new TableItem(this.webAppTable, 0);
            String memento = module.getMemento();
            String projectName = "";
            Image projectImage = null;
            if (memento != null && memento.length() > 0) {
                projectName = NLS.bind((String)Messages.configurationEditorProjectMissing, (Object[])new String[]{memento});
                projectImage = TomcatUIPlugin.getImage("projectMissing");
                IModule module2 = ServerUtil.getModule((String)memento);
                if (module2 != null) {
                    projectName = labelProvider.getText((Object)module2);
                    projectImage = labelProvider.getImage((Object)module2);
                    item.setData((Object)module2);
                }
            }
            String reload = module.isReloadable() ? Messages.configurationEditorReloadEnabled : Messages.configurationEditorReloadDisabled;
            String[] s = new String[]{module.getPath(), module.getDocumentBase(), projectName, reload};
            item.setText(s);
            item.setImage(0, TomcatUIPlugin.getImage("webModule"));
            if (projectImage != null) {
                item.setImage(2, projectImage);
            }
            if (this.isDocumentBaseValid(module.getDocumentBase())) continue;
            item.setImage(1, TomcatUIPlugin.getImage("projectMissing"));
            this.setErrorMessage(NLS.bind((String)Messages.errorMissingWebModule, (Object)module.getDocumentBase()));
        }
        labelProvider = null;
        if (this.readOnly) {
            this.addProject.setEnabled(false);
            this.addExtProject.setEnabled(false);
            this.edit.setEnabled(false);
            this.remove.setEnabled(false);
        } else {
            this.addProject.setEnabled(this.canAddWebModule());
            this.addExtProject.setEnabled(true);
        }
    }

    protected void selectWebApp() {
        if (this.readOnly) {
            return;
        }
        try {
            this.selection = this.webAppTable.getSelectionIndex();
            this.remove.setEnabled(true);
            this.edit.setEnabled(true);
        }
        catch (Exception exception) {
            this.selection = -1;
            this.remove.setEnabled(false);
            this.edit.setEnabled(false);
        }
    }

    protected boolean isDocumentBaseValid(String s) {
        if (s == null || s.length() < 2) {
            return true;
        }
        File f = new File(s);
        if (f.exists()) {
            return true;
        }
        try {
            if (ResourcesPlugin.getWorkspace().getRoot().getProject(s).exists()) {
                return true;
            }
        }
        catch (Exception exception) {}
        if (s.startsWith(this.configuration.getDocBasePrefix())) {
            try {
                String t = s.substring(this.configuration.getDocBasePrefix().length());
                if (ResourcesPlugin.getWorkspace().getRoot().getProject(t).exists()) {
                    return true;
                }
            }
            catch (Exception exception) {}
        }
        try {
            f = this.server.getRuntime().getLocation().append(s).toFile();
            if (f.exists()) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void setFocus() {
        if (this.webAppTable != null) {
            this.webAppTable.setFocus();
        }
    }
}

