/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class ArithmeticAddTestCase
extends SingleJSPTestCase {
    public ArithmeticAddTestCase() {
        super("/testdata/jsps/arithmeticAdd.jsp.data", "/arithmeticAdd.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSanity() {
        super.testSanity();
        ArithmeticAddTestCase.assertEquals((String)"myBean.integerProperty  + 3", (String)this.getELText(this._structuredDocument, 874));
        ArithmeticAddTestCase.assertEquals((String)"myBean.stringProperty + 3", (String)this.getELText(this._structuredDocument, 934));
        ArithmeticAddTestCase.assertEquals((String)"myBean.integerProperty + myBean.integerProperty", (String)this.getELText(this._structuredDocument, 992));
        ArithmeticAddTestCase.assertEquals((String)"myBean.bigIntegerProperty + 4", (String)this.getELText(this._structuredDocument, 1072));
        ArithmeticAddTestCase.assertEquals((String)"myBean.bigIntegerProperty + 5.5", (String)this.getELText(this._structuredDocument, 1134));
        ArithmeticAddTestCase.assertEquals((String)"myBean.bigDoubleProperty + 5.5", (String)this.getELText(this._structuredDocument, 1198));
        ArithmeticAddTestCase.assertEquals((String)"myBean.doubleProperty + 5", (String)this.getELText(this._structuredDocument, 1261));
        ArithmeticAddTestCase.assertEquals((String)"5 + 3", (String)this.getELText(this._structuredDocument, 1343));
        ArithmeticAddTestCase.assertEquals((String)"5.5 + 4", (String)this.getELText(this._structuredDocument, 1378));
        ArithmeticAddTestCase.assertEquals((String)"5.5 + null", (String)this.getELText(this._structuredDocument, 1415));
        ArithmeticAddTestCase.assertEquals((String)"'5' + '4'", (String)this.getELText(this._structuredDocument, 1458));
        ArithmeticAddTestCase.assertEquals((String)"null + null", (String)this.getELText(this._structuredDocument, 1500));
        ArithmeticAddTestCase.assertEquals((String)"5.5 + 3.5", (String)this.getELText(this._structuredDocument, 1545));
        ArithmeticAddTestCase.assertEquals((String)"5 + true", (String)this.getELText(this._structuredDocument, 1605));
        ArithmeticAddTestCase.assertEquals((String)"myBean.integerProperty + myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 1643));
        ArithmeticAddTestCase.assertEquals((String)"myBean.stringArrayProperty + myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 1720));
        ArithmeticAddTestCase.assertEquals((String)"myBean.integerProperty + true ", (String)this.getELText(this._structuredDocument, 1804));
        ArithmeticAddTestCase.assertEquals((String)"'a' + 'b'", (String)this.getELText(this._structuredDocument, 1867));
        ArithmeticAddTestCase.assertEquals((String)"myBean.bigIntegerProperty + true", (String)this.getELText(this._structuredDocument, 1909));
    }

    public void testNoErrorExprs() {
        this.assertNoError(874, "J");
        this.assertNoError(934, "J");
        this.assertNoError(992, "J");
        this.assertNoError(1072, "Ljava.math.BigInteger;");
        this.assertNoError(1134, "Ljava.math.BigDecimal;");
        this.assertNoError(1198, "Ljava.math.BigDecimal;");
        this.assertNoError(1261, "D");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(1343, "J", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1378, "D", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1415, "D", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1458, "J", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1500, "J", 1);
        this.assertContainsProblem(list, 0);
        list = this.assertSemanticWarning(1545, "D", 1);
        this.assertContainsProblem(list, 3);
    }

    public void testErrorExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticError(1605, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1643, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1720, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1804, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1867, null, 1);
        this.assertContainsProblem(list, 9);
        list = this.assertSemanticError(1909, null, 1);
        this.assertContainsProblem(list, 2);
    }
}

