/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class ArithmeticModuloTestCase
extends SingleJSPTestCase {
    public ArithmeticModuloTestCase() {
        super("/testdata/jsps/arithmeticModulo.jsp.data", "/WEB-INF/arithmeticModulo.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSanity() {
        super.testSanity();
        ArithmeticModuloTestCase.assertEquals((String)"myBean.integerProperty % 3", (String)this.getELText(this._structuredDocument, 828));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.integerProperty mod 3", (String)this.getELText(this._structuredDocument, 887));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.stringProperty % 3", (String)this.getELText(this._structuredDocument, 948));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.stringProperty mod 3", (String)this.getELText(this._structuredDocument, 1006));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.integerProperty % myBean.integerProperty", (String)this.getELText(this._structuredDocument, 1066));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.integerProperty mod myBean.integerProperty", (String)this.getELText(this._structuredDocument, 1146));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.bigIntegerProperty mod 4", (String)this.getELText(this._structuredDocument, 1228));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.doubleProperty mod 4", (String)this.getELText(this._structuredDocument, 1292));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.doubleProperty mod 5.43", (String)this.getELText(this._structuredDocument, 1351));
        ArithmeticModuloTestCase.assertEquals((String)"5 % 3", (String)this.getELText(this._structuredDocument, 1437));
        ArithmeticModuloTestCase.assertEquals((String)"5 mod 3", (String)this.getELText(this._structuredDocument, 1472));
        ArithmeticModuloTestCase.assertEquals((String)"5.5 % 4 ", (String)this.getELText(this._structuredDocument, 1509));
        ArithmeticModuloTestCase.assertEquals((String)"5.5 mod 4 ", (String)this.getELText(this._structuredDocument, 1547));
        ArithmeticModuloTestCase.assertEquals((String)"'5' % '4'", (String)this.getELText(this._structuredDocument, 1590));
        ArithmeticModuloTestCase.assertEquals((String)"'5' mod '4'", (String)this.getELText(this._structuredDocument, 1632));
        ArithmeticModuloTestCase.assertEquals((String)"null % null", (String)this.getELText(this._structuredDocument, 1676));
        ArithmeticModuloTestCase.assertEquals((String)"null mod null", (String)this.getELText(this._structuredDocument, 1720));
        ArithmeticModuloTestCase.assertEquals((String)"5 % true", (String)this.getELText(this._structuredDocument, 1784));
        ArithmeticModuloTestCase.assertEquals((String)"5 mod true", (String)this.getELText(this._structuredDocument, 1822));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.stringArrayProperty % myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 1862));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.stringArrayProperty mod myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 1943));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.integerProperty % true ", (String)this.getELText(this._structuredDocument, 2029));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.integerProperty mod true ", (String)this.getELText(this._structuredDocument, 2092));
        ArithmeticModuloTestCase.assertEquals((String)"'a' % 'b'", (String)this.getELText(this._structuredDocument, 2157));
        ArithmeticModuloTestCase.assertEquals((String)"'a' mod 'b'", (String)this.getELText(this._structuredDocument, 2199));
        ArithmeticModuloTestCase.assertEquals((String)"5.5 % null", (String)this.getELText(this._structuredDocument, 2240));
        ArithmeticModuloTestCase.assertEquals((String)"5.5 mod null", (String)this.getELText(this._structuredDocument, 2280));
        ArithmeticModuloTestCase.assertEquals((String)"5%0", (String)this.getELText(this._structuredDocument, 2322));
        ArithmeticModuloTestCase.assertEquals((String)"5 mod 0", (String)this.getELText(this._structuredDocument, 2355));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.integerProperty % myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 2392));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.integerProperty mod myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 2469));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.bigIntegerProperty % myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 2548));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.bigIntegerProperty mod null", (String)this.getELText(this._structuredDocument, 2628));
        ArithmeticModuloTestCase.assertEquals((String)"myBean.doubleProperty % true", (String)this.getELText(this._structuredDocument, 2691));
    }

    public void testNoErrorExprs() {
        this.assertNoError(828, "J");
        this.assertNoError(887, "J");
        this.assertNoError(948, "J");
        this.assertNoError(1006, "J");
        this.assertNoError(1066, "J");
        this.assertNoError(1146, "J");
        this.assertNoError(1228, "Ljava.math.BigInteger;");
        this.assertNoError(1292, "D");
        this.assertNoError(1351, "D");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(1437, "J", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1472, "J", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1509, "D", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1547, "D", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1590, "J", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1632, "J", 1);
        this.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1676, "J", 1);
        this.assertContainsProblem(list, 0);
        list = this.assertSemanticWarning(1720, "J", 1);
        this.assertContainsProblem(list, 0);
    }

    public void testErrorExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticError(1784, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1822, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1862, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1943, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2029, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2092, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2157, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2199, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2240, null, 1);
        this.assertContainsProblem(list, 1);
        list = this.assertSemanticError(2280, null, 1);
        this.assertContainsProblem(list, 1);
        list = this.assertSemanticError(2322, null, 1);
        this.assertContainsProblem(list, 1);
        list = this.assertSemanticError(2355, null, 1);
        this.assertContainsProblem(list, 1);
        list = this.assertSemanticError(2392, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2469, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2548, null, 1);
        this.assertContainsProblem(list, 2);
        list = this.assertSemanticError(2628, null, 1);
        this.assertContainsProblem(list, 1);
        list = this.assertSemanticError(2691, null, 1);
        this.assertContainsProblem(list, 2);
    }
}

