/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class LogicalOrTestCase
extends SingleJSPTestCase {
    public LogicalOrTestCase() {
        super("/testdata/jsps/logicalOR.jsp.data", "/logicalOR.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSanity() {
        LogicalOrTestCase.assertEquals((String)"myBean.booleanProperty or myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 828));
        LogicalOrTestCase.assertEquals((String)"myBean.booleanProperty || myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 909));
        LogicalOrTestCase.assertEquals((String)"false || myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 990));
        LogicalOrTestCase.assertEquals((String)"false or myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 1054));
        LogicalOrTestCase.assertEquals((String)"null || myBean.booleanProperty ", (String)this.getELText(this._structuredDocument, 1118));
        LogicalOrTestCase.assertEquals((String)"null or myBean.booleanProperty ", (String)this.getELText(this._structuredDocument, 1182));
        LogicalOrTestCase.assertEquals((String)"'notTrue' || myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 1246));
        LogicalOrTestCase.assertEquals((String)"myBean.booleanProperty || false", (String)this.getELText(this._structuredDocument, 1321));
        LogicalOrTestCase.assertEquals((String)"myBean.booleanProperty or false", (String)this.getELText(this._structuredDocument, 1385));
        LogicalOrTestCase.assertEquals((String)"myBean.booleanProperty || null ", (String)this.getELText(this._structuredDocument, 1449));
        LogicalOrTestCase.assertEquals((String)"myBean.booleanProperty or null", (String)this.getELText(this._structuredDocument, 1513));
        LogicalOrTestCase.assertEquals((String)"myBean.booleanProperty || 'notTrue'", (String)this.getELText(this._structuredDocument, 1576));
        LogicalOrTestCase.assertEquals((String)"myBean.booleanProperty or 'notTrue'", (String)this.getELText(this._structuredDocument, 1646));
        LogicalOrTestCase.assertEquals((String)"'true' or myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 1738));
        LogicalOrTestCase.assertEquals((String)"'true' || myBean.booleanProperty", (String)this.getELText(this._structuredDocument, 1804));
        LogicalOrTestCase.assertEquals((String)"myBean.booleanProperty or true ", (String)this.getELText(this._structuredDocument, 1867));
        LogicalOrTestCase.assertEquals((String)"myBean.booleanProperty || true ", (String)this.getELText(this._structuredDocument, 1928));
        LogicalOrTestCase.assertEquals((String)"myBean.booleanProperty || 'true'", (String)this.getELText(this._structuredDocument, 1989));
        LogicalOrTestCase.assertEquals((String)"false || true", (String)this.getELText(this._structuredDocument, 2051));
        LogicalOrTestCase.assertEquals((String)"null || true", (String)this.getELText(this._structuredDocument, 2094));
        LogicalOrTestCase.assertEquals((String)"myBean.integerProperty || false", (String)this.getELText(this._structuredDocument, 2161));
        LogicalOrTestCase.assertEquals((String)"false || myBean.integerProperty", (String)this.getELText(this._structuredDocument, 2225));
        LogicalOrTestCase.assertEquals((String)"4 || false", (String)this.getELText(this._structuredDocument, 2289));
    }

    public void testNoErrorExprs() {
        this.assertNoError(828, "Z");
        this.assertNoError(909, "Z");
        this.assertNoError(990, "Z");
        this.assertNoError(1054, "Z");
        this.assertNoError(1118, "Z");
        this.assertNoError(1182, "Z");
        this.assertNoError(1246, "Z");
        this.assertNoError(1321, "Z");
        this.assertNoError(1385, "Z");
        this.assertNoError(1449, "Z");
        this.assertNoError(1513, "Z");
        this.assertNoError(1576, "Z");
        this.assertNoError(1646, "Z");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(1738, "Z", 1);
        this.assertContainsProblem(list, 6);
        list = this.assertSemanticWarning(1804, "Z", 1);
        this.assertContainsProblem(list, 6);
        list = this.assertSemanticWarning(1867, "Z", 1);
        this.assertContainsProblem(list, 7);
        list = this.assertSemanticWarning(1928, "Z", 1);
        this.assertContainsProblem(list, 7);
        list = this.assertSemanticWarning(1989, "Z", 1);
        this.assertContainsProblem(list, 7);
        list = this.assertSemanticWarning(2051, "Z", 1);
        this.assertContainsProblem(list, 7);
        list = this.assertSemanticWarning(2094, "Z", 1);
        this.assertContainsProblem(list, 7);
    }

    public void testErrorExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticError(2161, null, 1);
        this.assertContainsProblem(list, 5);
        this.assertSemanticError(2225, null, 1);
        this.assertContainsProblem(list, 5);
        this.assertSemanticError(2289, null, 1);
        this.assertContainsProblem(list, 5);
    }
}

