/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.classpath;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorationsManager;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainerUtils;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class J2EEComponentClasspathContainer
implements IClasspathContainer {
    public static final String CONTAINER_ID = "org.eclipse.jst.j2ee.internal.module.container";
    public static final IPath CONTAINER_PATH = new Path("org.eclipse.jst.j2ee.internal.module.container");
    private static IPath WEBLIB = new Path("/WEB-INF/lib");
    private static ClasspathDecorationsManager decorationsManager = new ClasspathDecorationsManager("org.eclipse.jst.j2ee");
    private IPath containerPath;
    private IJavaProject javaProject;
    private IClasspathEntry[] entries = new IClasspathEntry[0];
    private boolean exportEntries = true;
    private static Map keys = new Hashtable();
    private static int MAX_RETRIES = 10;
    private static Map retries = new Hashtable();
    private LastUpdate lastUpdate = new LastUpdate();
    private boolean isUpdating = false;

    public static ClasspathDecorationsManager getDecorationsManager() {
        return decorationsManager;
    }

    public J2EEComponentClasspathContainer(IPath path, IJavaProject javaProject) {
        this.containerPath = path;
        this.javaProject = javaProject;
    }

    private boolean requiresUpdate() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.javaProject.getProject());
        if (component == null) {
            return false;
        }
        IVirtualReference[] refs = component instanceof J2EEModuleVirtualComponent ? ((J2EEModuleVirtualComponent)component).getReferences(false, true) : component.getReferences();
        IVirtualComponent comp = null;
        if (refs.length == this.lastUpdate.refCount) {
            int i = 0;
            while (i < this.lastUpdate.refCount) {
                comp = refs[i].getReferencedComponent();
                if (comp.isBinary() != this.lastUpdate.isBinary[i]) {
                    return true;
                }
                IPath path = null;
                if (comp.isBinary()) {
                    VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)comp;
                    File diskFile = archiveComp.getUnderlyingDiskFile();
                    if (diskFile.exists()) {
                        path = new Path(diskFile.getAbsolutePath());
                    } else {
                        IFile iFile = archiveComp.getUnderlyingWorkbenchFile();
                        path = iFile.getFullPath();
                    }
                } else {
                    path = comp.getProject().getFullPath();
                }
                if (!path.equals((Object)this.lastUpdate.paths[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void update() {
        component = ComponentCore.createComponent((IProject)this.javaProject.getProject());
        if (component == null) {
            return;
        }
        key = null;
        if (!this.javaProject.getProject().getFile(StructureEdit.MODULE_META_FILE_NAME).exists()) {
            hashCode = new Integer(this.javaProject.getProject().hashCode());
            key = (Integer)J2EEComponentClasspathContainer.keys.get(hashCode);
            if (key == null) {
                J2EEComponentClasspathContainer.keys.put(hashCode, hashCode);
                key = hashCode;
            }
            if ((retryCount = (Integer)J2EEComponentClasspathContainer.retries.get(key)) == null) {
                retryCount = new Integer(1);
            } else {
                if (retryCount > J2EEComponentClasspathContainer.MAX_RETRIES) {
                    return;
                }
                retryCount = new Integer(retryCount + 1);
            }
            J2EEComponentClasspathContainer.retries.put(key, retryCount);
            J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.javaProject.getProject());
            return;
        }
        if (key != null) {
            J2EEComponentClasspathContainer.retries.remove(key);
            J2EEComponentClasspathContainer.keys.remove(key);
        }
        comp = null;
        ref = null;
        refs = component instanceof J2EEModuleVirtualComponent != false ? ((J2EEModuleVirtualComponent)component).getReferences(false, true) : component.getReferences();
        refsList = new ArrayList<IVirtualReference>();
        refedComps = new HashSet<IVirtualComponent>();
        refedComps.add(component);
        i = 0;
        while (i < refs.length) {
            refsList.add(refs[i]);
            refedComps.add(refs[i].getReferencedComponent());
            ++i;
        }
        var12_12 = referencingList = component.getReferencingComponents();
        var11_13 = referencingList.length;
        var10_15 = 0;
        while (var10_15 < var11_13) {
            referencingComp = var12_12[var10_15];
            if (EarUtilities.isEARProject(referencingComp.getProject()) && (libDir = this.getEARLibDir(earComp = (EARVirtualComponent)referencingComp)) != null && !libDir.equals(earComp.getReference(component.getName()).getRuntimePath().toString())) {
                var19_35 = earRefs = earComp.getReferences();
                var18_33 = earRefs.length;
                var17_30 = 0;
                while (var17_30 < var18_33) {
                    earRef = var19_35[var17_30];
                    if (libDir.equals(earRef.getRuntimePath().toString()) && !refedComps.contains(earRefComp = earRef.getReferencedComponent())) {
                        refsList.add(earRef);
                        refedComps.add(earRefComp);
                    }
                    ++var17_30;
                }
            }
            ++var10_15;
        }
        i = 0;
        while (i < refsList.size()) {
            comp = ((IVirtualReference)refsList.get(i)).getReferencedComponent();
            if (comp.isBinary()) {
                binaryRefs = comp.getReferences();
                j = 0;
                while (j < binaryRefs.length) {
                    if (!refedComps.contains(binaryRefs[j].getReferencedComponent())) {
                        refsList.add(binaryRefs[j]);
                        refedComps.add(binaryRefs[j].getReferencedComponent());
                    }
                    ++j;
                }
            }
            ++i;
        }
        LastUpdate.access$4(this.lastUpdate, refsList.size());
        LastUpdate.access$5(this.lastUpdate, new boolean[LastUpdate.access$1(this.lastUpdate)]);
        LastUpdate.access$6(this.lastUpdate, new IPath[LastUpdate.access$1(this.lastUpdate)]);
        isWeb = JavaEEProjectUtilities.isDynamicWebProject(component.getProject());
        shouldAdd = true;
        entriesList = new ArrayList<IClasspathEntry>();
        try {
            javaProject = JavaCore.create((IProject)component.getProject());
            useJDTToControlExport = J2EEComponentClasspathContainerUtils.getDefaultUseEARLibrariesJDTExport();
            if (useJDTToControlExport) {
                try {
                    rawEntries = javaProject.getRawClasspath();
                    i = 0;
                    while (i < rawEntries.length) {
                        entry = rawEntries[i];
                        if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)J2EEComponentClasspathContainer.CONTAINER_PATH)) {
                            this.exportEntries = entry.isExported();
                            break;
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    J2EEPlugin.logError((CoreException)e);
                }
            }
            i = 0;
            while (i < refsList.size()) {
                ref = (IVirtualReference)refsList.get(i);
                comp = ref.getReferencedComponent();
                LastUpdate.access$2((LastUpdate)this.lastUpdate)[i] = comp.isBinary();
                v0 = shouldAdd = isWeb == false || ref.getRuntimePath().equals((Object)J2EEComponentClasspathContainer.WEBLIB) == false;
                if (shouldAdd) {
                    if (comp.isBinary()) {
                        archiveComp = (VirtualArchiveComponent)comp;
                        if (!archiveComp.getArchiveType().equals("cpe")) {
                            diskFile = archiveComp.getUnderlyingDiskFile();
                            if (diskFile.exists()) {
                                LastUpdate.access$3((LastUpdate)this.lastUpdate)[i] = new Path(diskFile.getAbsolutePath());
                            } else {
                                iFile = archiveComp.getUnderlyingWorkbenchFile();
                                LastUpdate.access$3((LastUpdate)this.lastUpdate)[i] = iFile.getFullPath();
                            }
                            dec = J2EEComponentClasspathContainer.decorationsManager.getDecorations(this.getPath().toString(), LastUpdate.access$3(this.lastUpdate)[i].toString());
                            srcpath = null;
                            srcrootpath = null;
                            attrs = new IClasspathAttribute[]{};
                            access = new IAccessRule[]{};
                            if (dec != null) {
                                srcpath = dec.getSourceAttachmentPath();
                                srcrootpath = dec.getSourceAttachmentRootPath();
                                attrs = dec.getExtraAttributes();
                            }
                            newEntry = JavaCore.newLibraryEntry((IPath)LastUpdate.access$3(this.lastUpdate)[i], (IPath)srcpath, (IPath)srcrootpath, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)this.exportEntries);
                            entriesList.add(newEntry);
                        }
                    } else {
                        project = comp.getProject();
                        LastUpdate.access$3((LastUpdate)this.lastUpdate)[i] = project.getFullPath();
                        entriesList.add(JavaCore.newProjectEntry((IPath)LastUpdate.access$3(this.lastUpdate)[i], (boolean)this.exportEntries));
                    }
                }
                ++i;
            }
        }
        finally {
            this.entries = new IClasspathEntry[entriesList.size()];
            i = 0;
            ** while (i < this.entries.length)
        }
lbl-1000:
        // 1 sources

        {
            this.entries[i] = (IClasspathEntry)entriesList.get(i);
            ++i;
            continue;
        }
lbl145:
        // 1 sources

    }

    public static void install(IPath containerPath, IJavaProject javaProject) {
        try {
            J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
            IJavaProject[] projects = new IJavaProject[]{javaProject};
            J2EEComponentClasspathContainer container = new J2EEComponentClasspathContainer(containerPath, javaProject);
            container.update();
            IClasspathContainer[] conts = new IClasspathContainer[]{container};
            try {
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])projects, (IClasspathContainer[])conts, null);
            }
            catch (JavaModelException e) {
                J2EEPlugin.logError((CoreException)((Object)e));
            }
        }
        finally {
            J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
        }
    }

    public void refresh(boolean force) {
        if (force || this.requiresUpdate()) {
            J2EEComponentClasspathContainer.install(this.containerPath, this.javaProject);
        }
    }

    public void refresh() {
        this.refresh(false);
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (!this.isUpdating && this != J2EEComponentClasspathContainerUtils.getInstalledEARLibrariesContainer(this.javaProject.getProject())) {
            try {
                this.isUpdating = true;
                this.update();
            }
            finally {
                this.isUpdating = false;
            }
        }
        return this.entries;
    }

    public String getDescription() {
        return J2EECommonMessages.J2EE_MODULE_CLASSPATH_CONTAINER_NAME;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    private String getEARLibDir(EARVirtualComponent earComponent) {
        IProject project = earComponent.getProject();
        if (!JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)earComponent, 1)) {
            return null;
        }
        IModelProvider modelProvider = ModelProviderManager.getModelProvider(project);
        if (modelProvider == null) {
            return null;
        }
        Application app = (Application)modelProvider.getModelObject();
        if (app == null) {
            return null;
        }
        String libDir = app.getLibraryDirectory();
        if (libDir == null) {
            libDir = "/lib";
        }
        return libDir;
    }

    private class LastUpdate {
        private int refCount = 0;
        private boolean[] isBinary = new boolean[this.refCount];
        private IPath[] paths = new IPath[this.refCount];

        private LastUpdate() {
        }

        static /* synthetic */ void access$4(LastUpdate lastUpdate, int n) {
            lastUpdate.refCount = n;
        }

        static /* synthetic */ void access$5(LastUpdate lastUpdate, boolean[] blArray) {
            lastUpdate.isBinary = blArray;
        }

        static /* synthetic */ void access$6(LastUpdate lastUpdate, IPath[] iPathArray) {
            lastUpdate.paths = iPathArray;
        }
    }
}

