/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.servertarget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class ServerTargetHelper {
    public static final String JAVA_NATURE_ID = "org.eclipse.jdt.core.javanature";
    public static final String SERVER_CONTAINER = "org.eclipse.jst.server.core.container";

    public static void cleanUpNonServerTargetClasspath(IProject project) {
        List existingClasspathEntries = ServerTargetHelper.getExistingNonServerTargetClasspath(project);
        if (!existingClasspathEntries.isEmpty()) {
            ServerTargetHelper.removeNonSeverTargetClasspathEntries(project, existingClasspathEntries);
        }
    }

    public static void removeNonSeverTargetClasspathEntries(IProject project, List existingClasspathEntries) {
        try {
            JemProjectUtilities.removeFromJavaClassPath((IProject)project, (List)existingClasspathEntries);
        }
        catch (JavaModelException jme) {
            Logger.getLogger().logError((Throwable)jme);
        }
    }

    public static String[] getProjectTypeAndJ2EELevel(IProject project) {
        String[] projectAttr = new String[2];
        return projectAttr;
    }

    public static boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature(JAVA_NATURE_ID);
        }
        catch (CoreException ce) {
            Logger.getLogger().logTrace((Throwable)ce);
            return false;
        }
    }

    public static int getExistingServerTargetIndex(List validServerTargets, IProject project) {
        IRuntime st;
        if (validServerTargets != null && (st = ServerCore.getProjectProperties((IProject)project).getRuntimeTarget()) != null) {
            int i = 0;
            while (i < validServerTargets.size()) {
                if (((IRuntime)validServerTargets.get(i)).getId() == st.getId()) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static List getExistingNonServerTargetClasspath(IProject project) {
        IJavaProject javaProject = null;
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        try {
            javaProject = (IJavaProject)project.getNature(JAVA_NATURE_ID);
        }
        catch (Exception exception) {}
        if (javaProject != null) {
            try {
                IClasspathEntry[] cp = javaProject.getRawClasspath();
                int size = cp.length;
                int i = 0;
                while (i < size) {
                    int entryKind = cp[i].getEntryKind();
                    if (entryKind != 3 && entryKind != 1 && entryKind != 2 && entryKind == 4 && ServerTargetHelper.isWASVariable(cp[i]) && (entryKind != 5 || !cp[i].getPath().segment(0).equals(SERVER_CONTAINER))) {
                        list.add(cp[i]);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
            return list;
        }
        return list;
    }

    private static boolean isWASVariable(IClasspathEntry entry) {
        return false;
    }

    public static List getServerTargets(String type, String version) {
        List<IRuntime> targets = Arrays.asList(ServerUtil.getRuntimes((String)type, (String)version));
        return targets;
    }
}

