/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.Tool;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.ResourceUtils;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dnd.internal.DesignerSourceMouseTrackAdapter;
import org.eclipse.jst.pagedesigner.editors.DesignerStructuredTextEditorJSP;
import org.eclipse.jst.pagedesigner.editors.IDesignViewer;
import org.eclipse.jst.pagedesigner.editors.IPropertySheetPageFactory;
import org.eclipse.jst.pagedesigner.editors.SimpleGraphicalEditor;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.PageDesignerResources;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.IPageVariablesProvider;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.adapter.IDocumentPageVariableAdapter;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.preview.PreviewHandlerNew;
import org.eclipse.jst.pagedesigner.preview.WindowsIEBrowser;
import org.eclipse.jst.pagedesigner.properties.WPETabbedPropertySheetPage;
import org.eclipse.jst.pagedesigner.tools.RangeSelectionTool;
import org.eclipse.jst.pagedesigner.ui.common.PartActivationHandler;
import org.eclipse.jst.pagedesigner.ui.common.sash.SashEditorPart;
import org.eclipse.jst.pagedesigner.ui.preferences.PDPreferences;
import org.eclipse.jst.pagedesigner.utils.EditorUtil;
import org.eclipse.jst.pagedesigner.utils.PreviewUtil;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.common.ui.provisional.editors.PostMultiPageEditorSite;
import org.eclipse.wst.common.ui.provisional.editors.PostMultiPageSelectionProvider;
import org.eclipse.wst.common.ui.provisional.editors.PostSelectionMultiPageEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.provisional.IDOMSourceEditingTextTools;
import org.w3c.dom.Document;

public final class HTMLEditor
extends PostSelectionMultiPageEditorPart
implements IPropertyListener,
ITabbedPropertySheetPageContributor {
    public static final String TABBED_PROPERTIES_CONTRIBUTOR_ID = "org.eclipse.jst.pagedesigner.tabPropertyContributor";
    public static final int MODE_SASH_VERTICAL = 0;
    public static final int MODE_SASH_HORIZONTAL = 1;
    public static final int MODE_DESIGNER = 2;
    public static final int MODE_SOURCE = 3;
    private Logger _log = PDPlugin.getLogger(HTMLEditor.class);
    private boolean _sash = true;
    private int _mode = 0;
    private SashEditorPart _sashEditorPart = null;
    private int _previewPageIndex;
    private SimpleGraphicalEditor _designViewer;
    private StructuredTextEditor _textEditor;
    private PartActivationHandler _partListener;
    private PaletteViewerPage _paletteViewerPage;
    private DefaultEditDomain _editDomain;
    private WindowsIEBrowser _browser;
    private Composite _previewComposite;
    private List PREVIEW_FILES_LIST = new ArrayList();
    private IPropertySheetPage _tabbedPropSheet;
    private ISelectionChangedListener _selChangedListener;

    private void _firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    public String getContributorId() {
        return TABBED_PROPERTIES_CONTRIBUTOR_ID;
    }

    private void connectSashPage() {
        ISelectionProvider selectionProvider = this._sashEditorPart.getSite().getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.getSelectionChangedListener(selectionProvider));
        } else {
            selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener(selectionProvider));
        }
    }

    private void disconnectSashPage() {
        ISelectionProvider selectionProvider = this._sashEditorPart.getSite().getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.getSelectionChangedListener(selectionProvider));
        } else {
            selectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener(selectionProvider));
        }
    }

    private ISelectionChangedListener getSelectionChangedListener(ISelectionProvider selectionProvider) {
        if (this._selChangedListener == null) {
            this._selChangedListener = selectionProvider instanceof IPostSelectionProvider ? new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((PostMultiPageSelectionProvider)HTMLEditor.this.getSite().getSelectionProvider()).firePostSelectionChanged(event);
                }
            } : new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((MultiPageSelectionProvider)HTMLEditor.this.getSite().getSelectionProvider()).firePostSelectionChanged(event);
                }
            };
        }
        return this._selChangedListener;
    }

    protected void sash_createAndAddDesignSourcePage() throws PartInitException {
        this._textEditor = this.createTextEditor();
        this._textEditor.setEditorPart((IEditorPart)this);
        this._textEditor.addPropertyListener((IPropertyListener)this);
        this._designViewer = new SimpleGraphicalEditor(this, this.getEditDomain());
        this._sashEditorPart = new SashEditorPart(){

            protected void createPages() throws PartInitException {
                this.addPage((IEditorPart)HTMLEditor.this._designViewer, this.getEditorInput());
                this.addPage((IEditorPart)HTMLEditor.this._textEditor, this.getEditorInput());
            }
        };
        int sashIndex = this.addPage((IEditorPart)this._sashEditorPart, this.getEditorInput());
        this.initDesignerMode();
        this.setPageText(sashIndex, PDPlugin.getResourceString("HTMLEditor.Design"));
        this._textEditor.update();
        this.firePropertyChange(1);
        this.connectSashPage();
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new PostMultiPageEditorSite((MultiPageEditorPart)this, editor);
    }

    private void tabbed_createAndAddDesignSourcePage() throws PartInitException {
        this._textEditor = this.createTextEditor();
        this._textEditor.setEditorPart((IEditorPart)this);
        this._textEditor.addPropertyListener((IPropertyListener)this);
        SimpleGraphicalEditor editor = new SimpleGraphicalEditor(this, this.getEditDomain());
        int designPageIndex = this.addPage((IEditorPart)editor, null);
        this._designViewer = editor;
        this.setPageText(designPageIndex, PDPlugin.getResourceString("HTMLEditor.Design"));
        int sourcePageIndex = this.addPage((IEditorPart)this._textEditor, this.getEditorInput());
        this.setPageText(sourcePageIndex, PDPlugin.getResourceString("HTMLEditor.Source"));
        this._textEditor.update();
        this.firePropertyChange(1);
    }

    private void createAndAddPreviewPage() {
        this._previewComposite = new Composite(this.getContainer(), 0);
        FillLayout filllayout = new FillLayout();
        this._previewComposite.setLayout((Layout)filllayout);
        this._previewPageIndex = this.addPage((Control)this._previewComposite);
        this.setPageText(this._previewPageIndex, PageDesignerResources.getInstance().getString("JSPSourceEditor.Page.Preview.PageText"));
    }

    private WindowsIEBrowser getPreviewBrowser() {
        if (this._browser == null) {
            this._browser = new WindowsIEBrowser();
            if (this._browser != null) {
                this._browser.create(this._previewComposite, 0);
                this._previewComposite.layout();
            }
        }
        return this._browser;
    }

    protected void connectDesignPage() {
        if (this._designViewer != null) {
            this._designViewer.setModel(this.getModel());
            ISelectionProvider designSelectionProvider = this._designViewer.getSite().getSelectionProvider();
            if (designSelectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)designSelectionProvider).addPostSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (HTMLEditor.this.getActiveEditor() != HTMLEditor.this._textEditor) {
                            HTMLEditor.this._designViewer.getSynchronizer().selectionChanged(event);
                        }
                    }
                });
            } else {
                designSelectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (HTMLEditor.this.getActiveEditor() != HTMLEditor.this._textEditor) {
                            HTMLEditor.this._designViewer.getSynchronizer().selectionChanged(event);
                        }
                    }
                });
            }
            ISelectionProvider textSelectionProvider = this._textEditor.getSite().getSelectionProvider();
            if (textSelectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)textSelectionProvider).addPostSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (event.getSelection() instanceof TextSelection) {
                            TextSelection textSelection = (TextSelection)event.getSelection();
                            HTMLEditor.this._designViewer.getSynchronizer().textSelectionChanged(textSelection.getOffset(), textSelection.getOffset() + textSelection.getLength());
                        }
                    }
                });
            } else {
                textSelectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        TextSelection textSelection = (TextSelection)event.getSelection();
                        HTMLEditor.this._designViewer.getSynchronizer().textSelectionChanged(textSelection.getOffset(), textSelection.getOffset() + textSelection.getLength());
                    }
                });
            }
        }
    }

    protected void createPages() {
        try {
            if (this._sash) {
                this.sash_createAndAddDesignSourcePage();
            } else {
                this.tabbed_createAndAddDesignSourcePage();
            }
            this.connectDesignPage();
            this.createAndAddPreviewPage();
            DesignerSourceMouseTrackAdapter adapter = new DesignerSourceMouseTrackAdapter(this._textEditor, (EditDomain)this.getEditDomain());
            this._textEditor.getTextViewer().getTextWidget().addMouseListener((MouseListener)adapter);
            this._textEditor.getTextViewer().getTextWidget().addMouseMoveListener((MouseMoveListener)adapter);
        }
        catch (PartInitException partInitException) {}
    }

    protected StructuredTextEditor createTextEditor() {
        return new DesignerStructuredTextEditorJSP();
    }

    private void disconnectDesignPage() {
        if (this._designViewer != null) {
            this._designViewer.setModel(null);
            this._designViewer.dispose();
        }
    }

    public void dispose() {
        this.deletePreviewFiles();
        this.disconnectDesignPage();
        this.disconnectSashPage();
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.getPartService().removePartListener((IPartListener)this._partListener);
        window.getShell().removeShellListener((ShellListener)this._partListener);
        this.getSite().getPage().removePartListener((IPartListener)this._partListener);
        if (this._textEditor != null) {
            this._textEditor.removePropertyListener((IPropertyListener)this);
            this._textEditor.setEditorPart(null);
            this._textEditor.dispose();
        }
        this._sashEditorPart = null;
        this._tabbedPropSheet = null;
        this._partListener = null;
        this._editDomain = null;
        this._designViewer = null;
        this._browser = null;
        this._previewComposite = null;
        this._paletteViewerPage = null;
        this._log = null;
        this._selChangedListener = null;
        this._textEditor = null;
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this._textEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this._textEditor.doSaveAs();
    }

    private void editorInputIsAcceptable(IEditorInput input) throws PartInitException {
        block14: {
            if (input instanceof IFileEditorInput) {
                Throwable[] coreExceptionArray = new CoreException[1];
                if (this.fileDoesNotExist((IFileEditorInput)input, coreExceptionArray)) {
                    Throwable coreException = coreExceptionArray[0];
                    if (coreException instanceof CoreException) {
                        block12: {
                            try {
                                ((IFileEditorInput)input).getFile().refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException ce) {
                                if (this._log == null) break block12;
                                this._log.error("Error.HTMLEditor.0", (Throwable)ce);
                            }
                        }
                        throw new PartInitException("Resource " + input.getName() + " does not exist.");
                    }
                    throw new PartInitException("Editor could not be open on " + input.getName());
                }
            } else if (input instanceof IStorageEditorInput) {
                InputStream contents = null;
                try {
                    try {
                        contents = ((IStorageEditorInput)input).getStorage().getContents();
                        if (contents == null) {
                            throw new PartInitException("Editor could not be open on " + input.getName());
                        }
                    }
                    catch (CoreException noStorageExc) {
                        this._log.error("Error.HTMLEditor.1", (Throwable)noStorageExc);
                        ResourceUtils.ensureClosed((InputStream)contents);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    ResourceUtils.ensureClosed(contents);
                    throw throwable;
                }
                ResourceUtils.ensureClosed((InputStream)contents);
            }
        }
    }

    protected boolean fileDoesNotExist(IFileEditorInput input, Throwable[] coreException) {
        boolean result;
        block7: {
            result = false;
            InputStream inStream = null;
            if (!input.exists() || !input.getFile().exists()) {
                result = true;
            } else {
                try {
                    try {
                        inStream = input.getFile().getContents(true);
                    }
                    catch (CoreException e) {
                        result = true;
                        coreException[0] = e;
                        this._log.error("Error.HTMLEditor.3", (Throwable)e);
                        ResourceUtils.ensureClosed((InputStream)inStream);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    ResourceUtils.ensureClosed(inStream);
                    throw throwable;
                }
                ResourceUtils.ensureClosed((InputStream)inStream);
            }
        }
        return result;
    }

    public Object getAdapter(Class key) {
        Object result = null;
        if (key == IDesignViewer.class) {
            result = this._designViewer;
        } else {
            if (key == PalettePage.class) {
                return this.getPaletteViewerPage();
            }
            if (key == IPropertySheetPage.class) {
                return this.getPropertySheetPage();
            }
            if (key == IContentOutlinePage.class) {
                if (this._textEditor != null) {
                    result = this._textEditor.getAdapter(key);
                }
            } else {
                if (key == IPageVariablesProvider.class) {
                    INodeAdapter obj = ((IDOMModel)this.getModel()).getDocument().getAdapterFor(IDocumentPageVariableAdapter.class);
                    if (obj instanceof IPageVariablesProvider) {
                        return obj;
                    }
                    return null;
                }
                if (this._textEditor != null) {
                    result = this._textEditor.getAdapter(key);
                }
            }
        }
        return result;
    }

    public IDocument getDocument() {
        if (this.getTextEditor() == null) {
            return null;
        }
        Object apapter = this._textEditor.getAdapter(ISourceEditingTextTools.class);
        if (apapter != null) {
            return ((ISourceEditingTextTools)apapter).getDocument();
        }
        return null;
    }

    public Document getDOMDocument() {
        if (this.getTextEditor() == null) {
            return null;
        }
        Object adapter = this._textEditor.getAdapter(ISourceEditingTextTools.class);
        if (adapter instanceof IDOMSourceEditingTextTools) {
            return ((IDOMSourceEditingTextTools)adapter).getDOMDocument();
        }
        return null;
    }

    public IEditorPart getEditorPart() {
        return this;
    }

    public IStructuredModel getModel() {
        IStructuredModel model = null;
        if (this._textEditor != null) {
            model = ((DesignerStructuredTextEditorJSP)this._textEditor).getModel();
        }
        return model;
    }

    public StructuredTextEditor getTextEditor() {
        return this._textEditor;
    }

    public String getTitle() {
        String title = null;
        if (this.getTextEditor() == null) {
            if (this.getEditorInput() != null) {
                title = this.getEditorInput().getName();
            }
        } else {
            title = this.getTextEditor().getTitle();
        }
        if (title == null) {
            title = this.getPartName();
        }
        return title;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.editorInputIsAcceptable(input);
        try {
            this.setInput(input);
            if (this._partListener == null) {
                this._partListener = new PartActivationHandler((IWorkbenchPart)this){

                    public void handleActivation() {
                        HTMLEditor.this.safelySanityCheckState();
                    }
                };
            }
            IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
            window.getPartService().addPartListener((IPartListener)this._partListener);
            window.getShell().addShellListener((ShellListener)this._partListener);
            IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
            contextService.activateContext("org.eclipse.jst.pagedesigner.editorContext");
        }
        catch (Exception e) {
            this._log.error("Error.HTMLEditor.5", (Throwable)e);
        }
        this.setPartName(input.getName());
    }

    public boolean isSaveAsAllowed() {
        return this._textEditor != null && this._textEditor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        if (this._textEditor != null) {
            return this._textEditor.isSaveOnCloseNeeded();
        }
        return this.isDirty();
    }

    private void postOnDisplayQue(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            Display display = windows[0].getShell().getDisplay();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public void propertyChanged(Object source, int propId) {
        switch (propId) {
            case 258: {
                if (source != this._textEditor || this._textEditor.getEditorInput() == this.getEditorInput()) break;
                this.setInput(this._textEditor.getEditorInput());
                Runnable runnable = new Runnable(){

                    public void run() {
                        HTMLEditor.this._firePropertyChange(1);
                    }
                };
                this.postOnDisplayQue(runnable);
                break;
            }
            default: {
                if (source != this._textEditor) break;
                this.firePropertyChange(propId);
            }
        }
    }

    private void safelySanityCheckState() {
        if (this.getTextEditor() == null) {
            return;
        }
        this.getTextEditor().safelySanityCheckState(this.getEditorInput());
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this._designViewer != null) {
            this._designViewer.setModel(this.getModel());
        }
        this.setPartName(input.getName());
    }

    public boolean isDirty() {
        if (this.getTextEditor() == null) {
            return false;
        }
        return this.getTextEditor().isDirty();
    }

    private IPropertySheetPage getPropertySheetPage() {
        if (this._tabbedPropSheet == null) {
            IPropertySheetPageFactory factory = this.getPageFactory();
            if (factory != null) {
                IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                this._tabbedPropSheet = factory.createPage(file);
            } else {
                this._tabbedPropSheet = new WPETabbedPropertySheetPage(this, this);
            }
        }
        return this._tabbedPropSheet;
    }

    private IPropertySheetPageFactory getPageFactory() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "pageDesignerExtension");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] elementEditElement = ext.getConfigurationElements();
            int j = 0;
            while (j < elementEditElement.length) {
                IConfigurationElement element = elementEditElement[j];
                if (element.getName().equals("propertyPageFactory")) {
                    elementEditElement[j].getAttribute("class");
                    try {
                        Object obj = elementEditElement[j].createExecutableExtension("class");
                        if (obj instanceof IPropertySheetPageFactory) {
                            return (IPropertySheetPageFactory)obj;
                        }
                    }
                    catch (CoreException e) {
                        PDPlugin.log("Problem loading element edit extension for " + element.toString(), e);
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private PaletteViewerPage getPaletteViewerPage() {
        if (this._paletteViewerPage == null) {
            this._paletteViewerPage = this._designViewer.createPaletteViewerPage();
        }
        return this._paletteViewerPage;
    }

    public DefaultEditDomain getEditDomain() {
        if (this._editDomain == null) {
            this._editDomain = new DefaultEditDomain((IEditorPart)this);
            this._editDomain.setDefaultTool((Tool)new RangeSelectionTool());
            this._editDomain.loadDefaultTool();
        }
        return this._editDomain;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.deletePreviewFiles();
        if (newPageIndex == this._previewPageIndex) {
            StringBuffer result = new StringBuffer();
            try {
                DocumentEditPart part = (DocumentEditPart)this._designViewer.getGraphicViewer().getContents();
                PreviewHandlerNew.generatePreview(part, result);
            }
            catch (Exception ex) {
                result = new StringBuffer();
                result.append(this.getModel().getStructuredDocument().getText());
                this._log.info("Error.HTMLEditor.6", (Throwable)ex);
                ex.printStackTrace();
            }
            File file = PreviewUtil.toFile(result, this.getEditorInput());
            if (file != null) {
                this.PREVIEW_FILES_LIST.add(file);
                this.getPreviewBrowser().loadFile(file);
            } else {
                this.getPreviewBrowser().getBrowser().setUrl("about:blank");
            }
        }
    }

    public IDesignViewer getDesignViewer() {
        return this._designViewer;
    }

    public void setDesignerMode(int mode) {
        if (this._sashEditorPart != null && this._mode != mode) {
            switch (mode) {
                case 1: {
                    this._sashEditorPart.setOrientation(256);
                    break;
                }
                case 2: {
                    this._sashEditorPart.setMaximizedEditor((IEditorPart)this._designViewer);
                    break;
                }
                case 3: {
                    this._sashEditorPart.setMaximizedEditor((IEditorPart)this._textEditor);
                    break;
                }
                default: {
                    this._sashEditorPart.setOrientation(512);
                }
            }
            if (this.getEditorInput() != null) {
                EditorUtil.setEditorInputDesignModeProperty(this.getEditorInput(), String.valueOf(mode));
            }
        }
        this._mode = mode;
    }

    private void initDesignerMode() {
        int preferredMode = 0;
        String prop = null;
        if (this.getEditorInput() != null) {
            prop = EditorUtil.getEditorInputDesignModeProperty(this.getEditorInput());
        }
        if (prop != null) {
            try {
                preferredMode = Integer.parseInt(prop);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            IPreferenceStore pStore = PDPlugin.getDefault().getPreferenceStore();
            preferredMode = pStore.getInt(PDPreferences.SASH_EDITOR_MODE_PREF);
        }
        this.setDesignerMode(preferredMode);
    }

    public int getDesignerMode() {
        return this._mode;
    }

    public IEditorPart getActiveEditor() {
        Object result = null;
        if (this._sash) {
            result = this._sashEditorPart.getActiveEditor();
        } else if (this._designViewer.getGraphicViewer().getControl().isFocusControl()) {
            result = this._designViewer;
        } else if (this._textEditor.getTextViewer().getControl().isFocusControl()) {
            result = this._textEditor;
        }
        return result;
    }

    public String getPartName() {
        if (this._textEditor != null) {
            return this._textEditor.getPartName();
        }
        return super.getPartName();
    }

    private void deletePreviewFiles() {
        for (File file : this.PREVIEW_FILES_LIST) {
            if (file == null || !file.exists()) continue;
            file.delete();
        }
        this.PREVIEW_FILES_LIST.clear();
    }
}

