/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.jst.pagedesigner.commands.CreateItemCommand;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.jst.pagedesigner.itemcreation.ItemCreationRequest;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.DropCustomizationController;
import org.eclipse.swt.graphics.Cursor;

public class ItemCreationTool
extends TargetingTool {
    TagToolPaletteEntry _tagPaletteItem;

    public ItemCreationTool(TagToolPaletteEntry tagToolPaletteEntryItem) {
        this.setDefaultCursor(SharedCursors.CURSOR_TREE_ADD);
        this.setDisabledCursor(SharedCursors.NO);
        this._tagPaletteItem = tagToolPaletteEntryItem;
    }

    protected Cursor calculateCursor() {
        return super.calculateCursor();
    }

    protected Request createTargetRequest() {
        ItemCreationRequest request = new ItemCreationRequest();
        request.setTagToolPaletteEntry(this._tagPaletteItem);
        return request;
    }

    public void deactivate() {
        super.deactivate();
    }

    protected String getCommandName() {
        return "Item Creation";
    }

    protected ItemCreationRequest getCreateRequest() {
        return (ItemCreationRequest)this.getTargetRequest();
    }

    protected String getDebugName() {
        return "Item Creation Tool";
    }

    protected boolean handleButtonDown(int button) {
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
            return true;
        }
        if (this.stateTransition(1, 2) && this.getTargetEditPart() != null) {
            this.getCreateRequest().setLocation(this.getLocation());
            this.lockTargetEditPart(this.getTargetEditPart());
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(6, 0x40000000)) {
            this.eraseTargetFeedback();
            this.unlockTargetEditPart();
            this.customizeDropAndMaybeExecute(button);
        }
        this.setState(0x40000000);
        this.handleFinished();
        return true;
    }

    protected void customizeDropAndMaybeExecute(int button) {
        Command command = this.getCurrentCommand();
        IStatus status = Status.OK_STATUS;
        if (command instanceof CreateItemCommand) {
            status = new DropCustomizationController((CreateItemCommand)command, this._tagPaletteItem.getURI(), this._tagPaletteItem.getTagName(), ((CreateItemCommand)command).getDocument(), ((CreateItemCommand)command).getPosition()).performCustomization();
        }
        if (status.getSeverity() == 0) {
            this.performCreation(button);
        }
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(4)) {
            this.updateTargetRequest();
            this.setCurrentCommand(this.getCommand());
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleDragStarted() {
        return this.stateTransition(2, 4);
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.eraseTargetFeedback();
            this.setState(8);
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleHover() {
        if (this.isInState(1)) {
            this.updateAutoexposeHelper();
        }
        return true;
    }

    protected boolean handleMove() {
        this.updateTargetRequest();
        this.updateTargetUnderMouse();
        this.setCurrentCommand(this.getCommand());
        this.showTargetFeedback();
        return true;
    }

    protected void performCreation(int button) {
        this.executeCurrentCommand();
    }

    protected void updateTargetRequest() {
        ItemCreationRequest req = this.getCreateRequest();
        req.setLocation(this.getLocation());
    }
}

