/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.resource.orm.OrmArtifactEdit;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.persistence.PersistenceArtifactEdit;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public abstract class ContextModelTestCase
extends AnnotationTestCase {
    protected static final String BASE_PROJECT_NAME = "ContextModelTestProject";
    protected PersistenceArtifactEdit persistenceArtifactEdit;
    protected OrmArtifactEdit ormArtifactEdit;

    protected ContextModelTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.persistenceArtifactEdit = PersistenceArtifactEdit.getArtifactEditForWrite((IProject)this.getJavaProject().getProject());
        this.ormArtifactEdit = OrmArtifactEdit.getArtifactEditForWrite((IProject)this.getJavaProject().getProject());
        this.waitForWorkspaceJobs();
    }

    protected void deleteAllProjects() throws Exception {
    }

    protected void tearDown() throws Exception {
        this.persistenceArtifactEdit.dispose();
        this.persistenceArtifactEdit = null;
        this.ormArtifactEdit.dispose();
        this.ormArtifactEdit = null;
        this.getJavaProject().getProject().delete(false, true, null);
        super.tearDown();
    }

    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return this.buildJpaProject(BASE_PROJECT_NAME, autoBuild, null);
    }

    protected TestJpaProject buildJpaProject(String projectName, boolean autoBuild, IDataModel jpaConfig) throws Exception {
        return TestJpaProject.buildJpaProject(projectName, autoBuild, jpaConfig);
    }

    protected JpaProject jpaProject() {
        return this.getJavaProject().getJpaProject();
    }

    protected void waitForWorkspaceJobs() {
        Job waitJob = new Job("Wait job"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        waitJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        waitJob.schedule();
        try {
            waitJob.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    protected PersistenceResource persistenceResource() {
        return this.persistenceArtifactEdit.getResource();
    }

    protected OrmResource ormResource() {
        return this.ormArtifactEdit.getResource(JptCorePlugin.getDefaultOrmXmlDeploymentURI((IProject)this.jpaProject().getProject()));
    }

    protected XmlPersistence xmlPersistence() {
        return this.persistenceResource().getPersistence();
    }

    protected EntityMappings entityMappings() {
        return ((MappingFileRef)this.persistenceUnit().mappingFileRefs().next()).getOrmXml().getEntityMappings();
    }

    protected XmlPersistenceUnit xmlPersistenceUnit() {
        return (XmlPersistenceUnit)this.persistenceResource().getPersistence().getPersistenceUnits().get(0);
    }

    protected PersistenceUnit persistenceUnit() {
        return (PersistenceUnit)this.rootContext().getPersistenceXml().getPersistence().persistenceUnits().next();
    }

    protected ClassRef classRef() {
        return (ClassRef)this.persistenceUnit().specifiedClassRefs().next();
    }

    protected JavaPersistentType javaPersistentType() {
        return this.classRef().getJavaPersistentType();
    }

    protected Entity javaEntity() {
        return (Entity)this.javaPersistentType().getMapping();
    }

    protected void addXmlClassRef(String className) {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass(className);
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
    }

    protected void removeXmlClassRef(String className) {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        XmlJavaClassRef xmlJavaClassRefToRemove = null;
        for (XmlJavaClassRef xmlJavaClassRef : xmlPersistenceUnit.getClasses()) {
            if (!xmlJavaClassRef.getJavaClass().equals(className)) continue;
            xmlJavaClassRefToRemove = xmlJavaClassRef;
        }
        if (xmlJavaClassRefToRemove == null) {
            throw new IllegalArgumentException();
        }
        xmlPersistenceUnit.getClasses().remove(xmlJavaClassRefToRemove);
    }

    protected JpaRootContextNode rootContext() {
        return this.getJavaProject().getJpaProject().getRootContext();
    }

    protected TestJpaProject getJavaProject() {
        return (TestJpaProject)super.getJavaProject();
    }

    protected void deleteResource(Resource resource) throws CoreException {
        System.gc();
        WorkbenchResourceHelper.deleteResource((Resource)resource);
        this.waitForWorkspaceJobs();
    }

    protected ICompilationUnit createAnnotationAndMembers(String annotationName, String annotationBody) throws Exception {
        return this.javaProject.createCompilationUnit("javax.persistence", String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    protected ICompilationUnit createEnumAndMembers(String enumName, String enumBody) throws Exception {
        return this.javaProject.createCompilationUnit("javax.persistence", String.valueOf(enumName) + ".java", "public enum " + enumName + " { " + enumBody + " }");
    }
}

