/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JpaFileTests
extends ContextModelTestCase {
    public JpaFileTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private ICompilationUnit createTestEntity() throws Exception {
        this.createEntityAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    public void testGetRootStructureNode() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        IFile file = this.ormResource().getResourceModel().getFile();
        JpaFile ormXmlJpaFile = JptCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertEquals((Object)this.entityMappings(), ormXmlJpaFile.rootStructureNodes().next());
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.rootStructureNodes().next());
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.rootStructureNodes().next());
        this.entityMappings().removeOrmPersistentType(ormPersistentType);
        JpaFileTests.assertEquals((Object)this.javaEntity().getPersistentType(), javaJpaFile.rootStructureNodes().next());
        ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.rootStructureNodes().next());
    }

    public void testEntityMappingsRootStructureNodeRemoved() throws Exception {
        IFile file = this.ormResource().getResourceModel().getFile();
        JpaFile ormXmlJpaFile = JptCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertEquals((Object)this.entityMappings(), ormXmlJpaFile.rootStructureNodes().next());
        ((OrmXml)this.entityMappings().getParent()).removeEntityMappings();
        JpaFileTests.assertFalse((boolean)ormXmlJpaFile.rootStructureNodes().hasNext());
    }

    public void testImpliedEntityMappingsRootStructureNodeRemoved() throws Exception {
        IFile file = this.ormResource().getResourceModel().getFile();
        JpaFile ormXmlJpaFile = JptCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertNull((Object)this.persistenceUnit().getImpliedMappingFileRef());
        this.xmlPersistenceUnit().getMappingFiles().remove(0);
        JpaFileTests.assertNotNull((Object)this.persistenceUnit().getImpliedMappingFileRef());
        JpaFileTests.assertEquals((Object)this.persistenceUnit().getImpliedMappingFileRef().getOrmXml().getEntityMappings(), ormXmlJpaFile.rootStructureNodes().next());
        this.persistenceUnit().getImpliedMappingFileRef().getOrmXml().removeEntityMappings();
        JpaFileTests.assertFalse((boolean)ormXmlJpaFile.rootStructureNodes().hasNext());
    }

    public void testEntityMappingsRootStructureNodeRemovedFromResourceModel() throws Exception {
        IFile file = this.ormResource().getResourceModel().getFile();
        JpaFile ormXmlJpaFile = JptCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertEquals((Object)this.entityMappings(), ormXmlJpaFile.rootStructureNodes().next());
        this.ormResource().getContents().remove((Object)this.ormResource().getEntityMappings());
        JpaFileTests.assertFalse((boolean)ormXmlJpaFile.rootStructureNodes().hasNext());
    }

    public void testUpdatePersistenceRootStructureNodePersistenceRemoved() throws Exception {
        IFile file = this.persistenceResource().getResourceModel().getFile();
        JpaFile persistenceXmlJpaFile = JptCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertEquals((Object)this.rootContext().getPersistenceXml().getPersistence(), persistenceXmlJpaFile.rootStructureNodes().next());
        this.rootContext().getPersistenceXml().removePersistence();
        JpaFileTests.assertFalse((boolean)persistenceXmlJpaFile.rootStructureNodes().hasNext());
    }

    public void testUpdateOrmJavaRootStructureNodePersistenceRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.rootStructureNodes().next());
        this.rootContext().getPersistenceXml().removePersistence();
        JpaFileTests.assertFalse((boolean)javaJpaFile.rootStructureNodes().hasNext());
    }

    public void testUpdateJavaRootStructureNodePersistenceRemoved() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)this.javaPersistentType(), javaJpaFile.rootStructureNodes().next());
        this.rootContext().getPersistenceXml().removePersistence();
        JpaFileTests.assertFalse((boolean)javaJpaFile.rootStructureNodes().hasNext());
    }

    public void testPersistenceRootStructureNodeRemovedFromResourceModel() throws Exception {
        IFile file = this.persistenceResource().getResourceModel().getFile();
        JpaFile persistenceXmlJpaFile = JptCorePlugin.getJpaFile((IFile)file);
        this.rootContext().getPersistenceXml().getPersistence();
        JpaFileTests.assertEquals((Object)this.rootContext().getPersistenceXml().getPersistence(), persistenceXmlJpaFile.rootStructureNodes().next());
        this.persistenceResource().getContents().remove((Object)this.persistenceResource().getPersistence());
        JpaFileTests.assertFalse((boolean)persistenceXmlJpaFile.rootStructureNodes().hasNext());
    }

    public void testUpdatePersistenceRootStructureNodePersistenceXmlRemoved() throws Exception {
        IFile file = this.persistenceResource().getResourceModel().getFile();
        JpaFile persistenceXmlJpaFile = JptCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertEquals((Object)this.rootContext().getPersistenceXml().getPersistence(), persistenceXmlJpaFile.rootStructureNodes().next());
        this.rootContext().removePersistenceXml();
        JpaFileTests.assertFalse((boolean)persistenceXmlJpaFile.rootStructureNodes().hasNext());
    }

    public void testUpdateOrmJavaRootStructureNodePersistenceXmlRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.rootStructureNodes().next());
        this.rootContext().removePersistenceXml();
        JpaFileTests.assertFalse((boolean)javaJpaFile.rootStructureNodes().hasNext());
    }

    public void testUpdateJavaRootStructureNodePersistenceXmlRemoved() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)this.javaPersistentType(), javaJpaFile.rootStructureNodes().next());
        this.rootContext().removePersistenceXml();
        JpaFileTests.assertFalse((boolean)javaJpaFile.rootStructureNodes().hasNext());
    }

    public void testOrmJavaPersistentTypeRootStructureNodeRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        JpaFileTests.assertTrue((boolean)(((JpaStructureNode)javaJpaFile.rootStructureNodes().next()).getParent() instanceof OrmEntity));
        this.entityMappings().removeOrmPersistentType(0);
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.rootStructureNodesSize());
        JpaFileTests.assertTrue((boolean)(((JpaStructureNode)javaJpaFile.rootStructureNodes().next()).getParent() instanceof ClassRef));
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
    }

    public void testOrmJavaPersistentTypeRootStructureNodeRemovedFromResourceModel() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        JpaFileTests.assertTrue((boolean)(((JpaStructureNode)javaJpaFile.rootStructureNodes().next()).getParent() instanceof OrmEntity));
        this.ormResource().getEntityMappings().getEntities().remove(0);
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.rootStructureNodesSize());
        JpaFileTests.assertTrue((boolean)(((JpaStructureNode)javaJpaFile.rootStructureNodes().next()).getParent() instanceof ClassRef));
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
    }

    public void testJavaPersistentTypeRootStructureNodeRemoved() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentType javaPersistentType = this.javaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        JpaFileTests.assertEquals(this.entityMappings().getPersistenceUnit().specifiedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.rootStructureNodes().next()).getParent());
        this.entityMappings().getPersistenceUnit().removeSpecifiedClassRef(0);
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        JpaFileTests.assertEquals(this.entityMappings().getPersistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.rootStructureNodes().next()).getParent());
    }

    public void testJavaPersistentTypeRootStructureNodeRemovedFromResourceModel() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentType javaPersistentType = this.javaPersistentType();
        Iterator rootStructureNodes = javaJpaFile.rootStructureNodes();
        JpaStructureNode rootStructureNode = (JpaStructureNode)rootStructureNodes.next();
        JpaFileTests.assertEquals((Object)javaPersistentType, (Object)rootStructureNode);
        JpaFileTests.assertEquals(this.entityMappings().getPersistenceUnit().specifiedClassRefs().next(), (Object)rootStructureNode.getParent());
        JpaFileTests.assertFalse((boolean)rootStructureNodes.hasNext());
        this.removeXmlClassRef("test.AnnotationTestType");
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        JpaFileTests.assertEquals(this.entityMappings().getPersistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.rootStructureNodes().next()).getParent());
    }

    public void testImpliedJavaPersistentTypeRootStructureNodeRemoved() throws Exception {
        this.jpaProject().setDiscoversAnnotatedClasses(true);
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ((ClassRef)this.persistenceUnit().impliedClassRefs().next()).getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        javaPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JpaFileTests.assertFalse((boolean)javaJpaFile.rootStructureNodes().hasNext());
    }

    public void testJavaRootStructureNodesEntityMappingsRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        this.ormResource().getContents().remove((Object)this.ormResource().getEntityMappings());
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.rootStructureNodesSize());
        JpaFileTests.assertEquals(this.persistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.rootStructureNodes().next()).getParent());
    }

    public void testJavaRootStructureNodesPersistenceUnitRemovedFromResourceModel() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        this.persistenceResource().getPersistence().getPersistenceUnits().remove(0);
        JpaFileTests.assertFalse((boolean)javaJpaFile.rootStructureNodes().hasNext());
        JpaFileTests.assertEquals((int)0, (int)javaJpaFile.rootStructureNodesSize());
    }

    public void testJavaRootStructureNodesPersistenceUnitRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        this.jpaProject().getRootContext().getPersistenceXml().getPersistence().removePersistenceUnit(0);
        JpaFileTests.assertFalse((boolean)javaJpaFile.rootStructureNodes().hasNext());
        JpaFileTests.assertEquals((int)0, (int)javaJpaFile.rootStructureNodesSize());
    }

    public void testJavaRootStructureNodesOrmPersistentTypeRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        this.entityMappings().removeOrmPersistentType(0);
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.rootStructureNodesSize());
        JpaFileTests.assertEquals(this.entityMappings().getPersistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.rootStructureNodes().next()).getParent());
    }

    public void testJavaRootStructureNodesOrmTypeMappingMorphed() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        ormPersistentType.setMappingKey("embeddable");
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.rootStructureNodesSize());
        javaPersistentType = ((OrmPersistentType)this.entityMappings().ormPersistentTypes().next()).getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        this.entityMappings().removeOrmPersistentType(0);
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.rootStructureNodesSize());
        JpaFileTests.assertEquals(this.entityMappings().getPersistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.rootStructureNodes().next()).getParent());
    }

    public void testUpdateOrmJavaRootStructureNodeMappingFileRefChanged() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.rootStructureNodes().next());
        MappingFileRef mappingFileRef = (MappingFileRef)this.persistenceUnit().mappingFileRefs().next();
        mappingFileRef.setFileName("foo");
        ormPersistentType = (OrmPersistentType)this.persistenceUnit().getImpliedMappingFileRef().getOrmXml().getEntityMappings().ormPersistentTypes().next();
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.rootStructureNodes().next());
        IFile file = this.persistenceResource().getResourceModel().getFile();
        JpaFile ormXmlJpaFile = JptCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertEquals((int)1, (int)ormXmlJpaFile.rootStructureNodesSize());
    }

    public void testUpdateJavaRootStructureNodeMappingFileRefChanged() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)this.javaPersistentType(), javaJpaFile.rootStructureNodes().next());
        MappingFileRef mappingFileRef = (MappingFileRef)this.persistenceUnit().mappingFileRefs().next();
        mappingFileRef.setFileName("foo");
        JpaFileTests.assertEquals((Object)this.javaPersistentType(), javaJpaFile.rootStructureNodes().next());
    }

    public void testUpdateJavaRootStrucutreNodeDeleteOrmResource() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        this.deleteResource((Resource)this.ormResource());
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.rootStructureNodes().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.rootStructureNodesSize());
        JpaFileTests.assertEquals(this.persistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.rootStructureNodes().next()).getParent());
    }
}

