/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.EnumType;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.EnumeratedAnnotation;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaBasicMappingTests
extends ContextModelTestCase {
    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createBasicAnnotation() throws Exception {
        this.createAnnotationAndMembers("Basic", "FetchType fetch() default EAGER; boolean optional() default true;");
    }

    private void createLobAnnotation() throws Exception {
        this.createAnnotationAndMembers("Lob", "");
    }

    private void createEnumeratedAnnotation() throws Exception {
        this.createAnnotationAndMembers("Enumerated", "EnumType value() default ORDINAL;");
    }

    private void createTemporalAnnotation() throws Exception {
        this.createAnnotationAndMembers("Temporal", "TemporalType value();");
    }

    private ICompilationUnit createTestEntity() throws Exception {
        this.createEntityAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        this.createEntityAnnotation();
        this.createBasicAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithBasicMappingFetchOptionalSpecified() throws Exception {
        this.createEntityAnnotation();
        this.createBasicAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.FetchType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic(fetch=FetchType.EAGER, optional=false)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithLob() throws Exception {
        this.createEntityAnnotation();
        this.createLobAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Lob"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Lob").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithEnumerated() throws Exception {
        this.createEntityAnnotation();
        this.createEnumeratedAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Enumerated", "javax.persistence.EnumType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Enumerated(EnumType.STRING)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithTemporal() throws Exception {
        this.createEntityAnnotation();
        this.createTemporalAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Temporal(TemporalType.TIMESTAMP)").append(CR);
            }
        });
    }

    public JavaBasicMappingTests(String name) {
        super(name);
    }

    public void testDefaultBasicGetDefaultFetch() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)basicMapping.getDefaultFetch());
    }

    public void testSpecifiedBasicGetDefaultFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)basicMapping.getDefaultFetch());
    }

    public void testGetFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)basicMapping.getFetch());
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)basicMapping.getFetch());
    }

    public void testGetSpecifiedFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedFetch());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        basic.setFetch(FetchType.LAZY);
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)basicMapping.getSpecifiedFetch());
    }

    public void testGetSpecifiedFetch2() throws Exception {
        this.createTestEntityWithBasicMappingFetchOptionalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)basicMapping.getSpecifiedFetch());
    }

    public void testSetSpecifiedFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedFetch());
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)basic.getFetch());
        basicMapping.setSpecifiedFetch(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
    }

    public void testSetSpecifiedFetch2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.createOrmXmlFile();
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedFetch());
        JavaBasicMappingTests.assertTrue((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.properties().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)basic.getFetch());
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)basicMapping.getSpecifiedFetch());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedFetch(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
    }

    protected void createOrmXmlFile() throws Exception {
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    public void testSetBasicRemovedFromResourceModel() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        basicMapping.setLob(true);
        basicMapping.setSpecifiedEnumerated(EnumType.ORDINAL);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.setMappingAnnotation(null);
        JavaBasicMappingTests.assertNotSame((Object)basicMapping, (Object)persistentAttribute.getMapping());
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertTrue((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)basicMapping.getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToDefaultBasic() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setLob(true);
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedEnumerated(EnumType.ORDINAL);
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((BasicMapping)persistentAttribute.getMapping()).getTemporal());
        JavaBasicMappingTests.assertTrue((boolean)((BasicMapping)persistentAttribute.getMapping()).isLob());
        JavaBasicMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)((BasicMapping)persistentAttribute.getMapping()).getEnumerated());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaBasicMappingTests.assertNull((Object)((BasicMapping)persistentAttribute.getMapping()).getSpecifiedFetch());
        JavaBasicMappingTests.assertNull((Object)((BasicMapping)persistentAttribute.getMapping()).getSpecifiedOptional());
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToId() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setLob(true);
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedEnumerated(EnumType.ORDINAL);
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)((IdMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((IdMapping)persistentAttribute.getMapping()).getTemporal());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToVersion() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        basicMapping.setLob(true);
        basicMapping.setSpecifiedEnumerated(EnumType.ORDINAL);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)((VersionMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((VersionMapping)persistentAttribute.getMapping()).getTemporal());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToEmbedded() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        basicMapping.setLob(true);
        basicMapping.setSpecifiedEnumerated(EnumType.ORDINAL);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToEmbeddedId() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        basicMapping.setLob(true);
        basicMapping.setSpecifiedEnumerated(EnumType.ORDINAL);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToTransient() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        basicMapping.setLob(true);
        basicMapping.setSpecifiedEnumerated(EnumType.ORDINAL);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToOneToOne() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        basicMapping.setLob(true);
        basicMapping.setSpecifiedEnumerated(EnumType.ORDINAL);
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToOne"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToOneToMany() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        basicMapping.setLob(true);
        basicMapping.setSpecifiedEnumerated(EnumType.ORDINAL);
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToManyToOne() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        basicMapping.setLob(true);
        basicMapping.setSpecifiedEnumerated(EnumType.ORDINAL);
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToManyToMany() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        basicMapping.setLob(true);
        basicMapping.setSpecifiedEnumerated(EnumType.ORDINAL);
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testDefaultBasicGetDefaultOptional() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basicMapping.getDefaultOptional());
    }

    public void testSpecifiedBasicGetDefaultOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basicMapping.getDefaultOptional());
    }

    public void testGetOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basicMapping.getOptional());
        basicMapping.setSpecifiedOptional(basicMapping.getOptional());
        JavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basicMapping.getOptional());
    }

    public void testGetSpecifiedOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        basic.setOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicMapping.getSpecifiedOptional());
    }

    public void testGetSpecifiedOptional2() throws Exception {
        this.createTestEntityWithBasicMappingFetchOptionalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicMapping.getSpecifiedOptional());
    }

    public void testSetSpecifiedOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getOptional());
        basicMapping.setSpecifiedOptional(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
    }

    public void testSetSpecifiedOptional2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaBasicMappingTests.assertTrue((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedOptional(Boolean.TRUE);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getOptional());
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basicMapping.getSpecifiedOptional());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedOptional(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
    }

    public void testGetSpecifiedOptionalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        basic.setOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicMapping.getSpecifiedOptional());
        basic.setOptional(null);
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getSpecifiedMapping());
        basic.setOptional(Boolean.FALSE);
        attributeResource.setMappingAnnotation(null);
        JavaBasicMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        JavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)((BasicMapping)persistentAttribute.getMapping()).getOptional());
    }

    public void testIsLob() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isLob());
    }

    public void testIsLob2() throws Exception {
        this.createTestEntityWithLob();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertTrue((boolean)basicMapping.isLob());
    }

    public void testSetLob() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        basicMapping.setLob(true);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        basicMapping.setLob(false);
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
    }

    public void testIsLobUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isLob());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation("javax.persistence.Lob");
        JavaBasicMappingTests.assertTrue((boolean)basicMapping.isLob());
        attributeResource.removeAnnotation("javax.persistence.Lob");
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isLob());
    }

    public void testDefaultBasicGetDefaultEnumerated() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)basicMapping.getDefaultEnumerated());
    }

    public void testSpecifiedBasicGetDefaultEnumerated() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)basicMapping.getDefaultEnumerated());
    }

    public void testGetEnumerated() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)basicMapping.getEnumerated());
        basicMapping.setSpecifiedEnumerated(EnumType.STRING);
        JavaBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)basicMapping.getEnumerated());
    }

    public void testGetSpecifiedEnumerated() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedEnumerated());
    }

    public void testGetSpecifiedEnumerated2() throws Exception {
        this.createTestEntityWithEnumerated();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)basicMapping.getSpecifiedEnumerated());
    }

    public void testSetSpecifiedEnumerated() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedEnumerated());
        basicMapping.setSpecifiedEnumerated(EnumType.STRING);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.getAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.java.EnumType.STRING, (Object)enumerated.getValue());
        basicMapping.setSpecifiedEnumerated(null);
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testGetSpecifieEnumeratedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedEnumerated());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.addAnnotation("javax.persistence.Enumerated");
        enumerated.setValue(org.eclipse.jpt.core.resource.java.EnumType.STRING);
        JavaBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)basicMapping.getSpecifiedEnumerated());
        enumerated.setValue(null);
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedEnumerated());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetTemporal() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getTemporal());
    }

    public void testGetTemporal2() throws Exception {
        this.createTestEntityWithTemporal();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIMESTAMP, (Object)basicMapping.getTemporal());
    }

    public void testSetTemporal() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getTemporal());
        basicMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getAnnotation("javax.persistence.Temporal");
        JavaBasicMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        basicMapping.setTemporal(null);
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getTemporal());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.addAnnotation("javax.persistence.Temporal");
        temporal.setValue(TemporalType.DATE);
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.DATE, (Object)basicMapping.getTemporal());
        attributeResource.removeAnnotation("javax.persistence.Temporal");
        JavaBasicMappingTests.assertNull((Object)basicMapping.getTemporal());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetColumn() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((String)"id", (String)basicMapping.getColumn().getName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setName("foo");
        JavaBasicMappingTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getName());
        JavaBasicMappingTests.assertEquals((String)"id", (String)basicMapping.getColumn().getDefaultName());
    }
}

