/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.internal.context.java.GenericJavaNullAttributeMapping;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaEmbeddedIdMappingTests
extends ContextModelTestCase {
    public static final String EMBEDDABLE_TYPE_NAME = "MyEmbeddable";
    public static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.MyEmbeddable";

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createEmbeddableAnnotation() throws Exception {
        this.createAnnotationAndMembers("Embeddable", "");
    }

    private void createEmbeddedIdAnnotation() throws Exception {
        this.createAnnotationAndMembers("EmbeddedId", "");
    }

    private ICompilationUnit createTestEntityWithEmbeddedIdMapping() throws Exception {
        this.createEntityAnnotation();
        this.createEmbeddedIdAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.EmbeddedId"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@EmbeddedId").append(CR);
                sb.append(CR);
                sb.append("    private MyEmbeddable myEmbeddedId;").append(CR);
                sb.append(CR);
            }
        });
    }

    private void createEmbeddableType() throws Exception {
        this.createEmbeddableAnnotation();
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(JavaEmbeddedIdMappingTests.EMBEDDABLE_TYPE_NAME).append(" {");
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "MyEmbeddable.java", sourceWriter);
    }

    public JavaEmbeddedIdMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaEmbeddedIdMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaEmbeddedIdMappingTests.assertTrue((boolean)((EmbeddedMapping)persistentAttribute.getMapping()).attributeOverrides().hasNext());
        JavaEmbeddedIdMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testDefaultEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof GenericJavaNullAttributeMapping));
        JavaEmbeddedIdMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        this.createEmbeddableType();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaEmbeddedIdMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToOne"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToMany"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)this.javaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        ListIterator specifiedAttributeOverrides = embeddedIdMapping.specifiedAttributeOverrides();
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        specifiedAttributeOverrides = embeddedIdMapping.specifiedAttributeOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        specifiedAttributeOverrides = embeddedIdMapping.specifiedAttributeOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAZ");
        specifiedAttributeOverrides = embeddedIdMapping.specifiedAttributeOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.move(1, 0, "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = embeddedIdMapping.specifiedAttributeOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = embeddedIdMapping.specifiedAttributeOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = embeddedIdMapping.specifiedAttributeOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        specifiedAttributeOverrides = embeddedIdMapping.specifiedAttributeOverrides();
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testDefaultAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)this.javaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaEmbeddedIdMappingTests.assertEquals((String)"myEmbeddedId", (String)attributeResource.getName());
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)embeddedIdMapping.virtualAttributeOverridesSize());
        AttributeOverride defaultAttributeOverride = (AttributeOverride)embeddedIdMapping.virtualAttributeOverrides().next();
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTable());
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        classRefs.next();
        Embeddable embeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)embeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)embeddedIdMapping.virtualAttributeOverridesSize());
        defaultAttributeOverride = (AttributeOverride)embeddedIdMapping.virtualAttributeOverrides().next();
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        defaultAttributeOverride = (AttributeOverride)embeddedIdMapping.virtualAttributeOverrides().next();
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTable());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("city");
        JavaEmbeddedIdMappingTests.assertEquals((int)1, (int)embeddedIdMapping.virtualAttributeOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)this.javaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        JavaEmbeddedIdMappingTests.assertEquals((int)0, (int)embeddedIdMapping.specifiedAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)embeddedIdMapping.specifiedAttributeOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)this.javaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)embeddedIdMapping.attributeOverridesSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        JavaEmbeddedIdMappingTests.assertEquals((int)4, (int)embeddedIdMapping.attributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        JavaEmbeddedIdMappingTests.assertEquals((int)4, (int)embeddedIdMapping.attributeOverridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)this.javaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)embeddedIdMapping.virtualAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)embeddedIdMapping.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        JavaEmbeddedIdMappingTests.assertEquals((int)1, (int)embeddedIdMapping.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("state");
        JavaEmbeddedIdMappingTests.assertEquals((int)0, (int)embeddedIdMapping.virtualAttributeOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)this.javaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        ((AttributeOverride)embeddedIdMapping.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)embeddedIdMapping.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)embeddedIdMapping.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)((AttributeOverride)embeddedIdMapping.virtualAttributeOverrides().next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((int)1, (int)embeddedIdMapping.virtualAttributeOverridesSize());
        ((AttributeOverride)embeddedIdMapping.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        Iterator virtualAttributeOverrides = embeddedIdMapping.virtualAttributeOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"state", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)embeddedIdMapping.virtualAttributeOverridesSize());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)this.javaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        ListIterator virtualAttributeOverrides = embeddedIdMapping.virtualAttributeOverrides();
        virtualAttributeOverrides.next();
        ((AttributeOverride)virtualAttributeOverrides.next()).setVirtual(false);
        ((AttributeOverride)embeddedIdMapping.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)this.javaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        ((AttributeOverride)embeddedIdMapping.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)embeddedIdMapping.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.move(1, 0, "javax.persistence.AttributeOverrides");
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }
}

