/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaSecondaryTableTests
extends ContextModelTestCase {
    private static final String TABLE_NAME = "MY_TABLE";

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createIdAnnotation() throws Exception {
        this.createAnnotationAndMembers("Id", "");
    }

    private void createSecondaryTableAnnotation() throws Exception {
        this.createAnnotationAndMembers("SecondaryTable", "String name() default \"\"; String catalog() default \"\"; String schema() default \"\";");
    }

    private void createSecondaryTablesAnnotation() throws Exception {
        this.createSecondaryTableAnnotation();
        this.createAnnotationAndMembers("SecondaryTables", "SecondaryTable[] value();");
    }

    private ICompilationUnit createTestEntityWithSecondaryTable() throws Exception {
        this.createEntityAnnotation();
        this.createIdAnnotation();
        this.createSecondaryTableAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@SecondaryTable(name=\"MY_TABLE\")");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTables() throws Exception {
        this.createEntityAnnotation();
        this.createSecondaryTablesAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@SecondaryTables({@SecondaryTable(name=\"foo\"), @SecondaryTable(name=\"bar\")})");
            }
        });
    }

    public JavaSecondaryTableTests(String name) {
        super(name);
    }

    public void testGetSpecifiedName() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().secondaryTables().next();
        JavaSecondaryTableTests.assertEquals((String)TABLE_NAME, (String)secondaryTable.getSpecifiedName());
    }

    public void testGetDefaultNameNull() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().secondaryTables().next();
        JavaSecondaryTableTests.assertNull((Object)secondaryTable.getDefaultName());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().secondaryTables().next();
        JavaSecondaryTableTests.assertEquals((String)TABLE_NAME, (String)secondaryTable.getName());
    }

    public void testSetSpecifiedName() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().secondaryTables().next();
        secondaryTable.setSpecifiedName("foo");
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)((SecondaryTable)this.javaEntity().secondaryTables().next()).getSpecifiedName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)typeResource.getAnnotation("javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)table.getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().secondaryTables().next();
        secondaryTable.setSpecifiedName(null);
        JavaSecondaryTableTests.assertEquals((int)0, (int)this.javaEntity().secondaryTablesSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaSecondaryTableTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SecondaryTable"));
    }

    public void testUpdateFromSpecifiedNameChangeInResourceModel() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)typeResource.getAnnotation("javax.persistence.SecondaryTable");
        table.setName("foo");
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)((SecondaryTable)this.javaEntity().secondaryTables().next()).getSpecifiedName());
    }

    public void testUpdateFromSpecifiedCatalogChangeInResourceModel() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        ListIterator secondaryTableResources = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        ((SecondaryTableAnnotation)secondaryTableResources.next()).setCatalog("foo");
        ((SecondaryTableAnnotation)secondaryTableResources.next()).setCatalog("bar");
        ListIterator secondaryTsbles = this.javaEntity().secondaryTables();
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)((SecondaryTable)secondaryTsbles.next()).getSpecifiedCatalog());
        JavaSecondaryTableTests.assertEquals((String)"bar", (String)((SecondaryTable)secondaryTsbles.next()).getSpecifiedCatalog());
    }

    public void testUpdateFromSpecifiedSchemaChangeInResourceModel() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        ListIterator secondaryTableResources = typeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        ((SecondaryTableAnnotation)secondaryTableResources.next()).setSchema("foo");
        ((SecondaryTableAnnotation)secondaryTableResources.next()).setSchema("bar");
        ListIterator secondaryTsbles = this.javaEntity().secondaryTables();
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)((SecondaryTable)secondaryTsbles.next()).getSpecifiedSchema());
        JavaSecondaryTableTests.assertEquals((String)"bar", (String)((SecondaryTable)secondaryTsbles.next()).getSpecifiedSchema());
    }

    public void testGetCatalog() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)typeResource.getAnnotation("javax.persistence.SecondaryTable");
        table.setCatalog("myCatalog");
        JavaSecondaryTableTests.assertEquals((String)"myCatalog", (String)((SecondaryTable)this.javaEntity().secondaryTables().next()).getSpecifiedCatalog());
        JavaSecondaryTableTests.assertEquals((String)"myCatalog", (String)((SecondaryTable)this.javaEntity().secondaryTables().next()).getCatalog());
    }

    public void testGetDefaultCatalog() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSecondaryTableTests.assertNull((Object)((SecondaryTable)this.javaEntity().secondaryTables().next()).getDefaultCatalog());
        ((SecondaryTable)this.javaEntity().secondaryTables().next()).setSpecifiedCatalog("myCatalog");
        JavaSecondaryTableTests.assertNull((Object)((SecondaryTable)this.javaEntity().secondaryTables().next()).getDefaultCatalog());
    }

    public void testSetSpecifiedCatalog() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable table = (SecondaryTable)this.javaEntity().secondaryTables().next();
        table.setSpecifiedCatalog("myCatalog");
        table.setSpecifiedName(null);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)typeResource.getAnnotation("javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((String)"myCatalog", (String)tableResource.getCatalog());
        table.setSpecifiedCatalog(null);
        JavaSecondaryTableTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SecondaryTable"));
    }

    public void testGetSchema() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)typeResource.getAnnotation("javax.persistence.SecondaryTable");
        tableResource.setSchema("mySchema");
        JavaSecondaryTableTests.assertEquals((String)"mySchema", (String)((SecondaryTable)this.javaEntity().secondaryTables().next()).getSpecifiedSchema());
        JavaSecondaryTableTests.assertEquals((String)"mySchema", (String)((SecondaryTable)this.javaEntity().secondaryTables().next()).getSchema());
    }

    public void testGetDefaultSchema() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSecondaryTableTests.assertNull((Object)((SecondaryTable)this.javaEntity().secondaryTables().next()).getDefaultSchema());
        ((SecondaryTable)this.javaEntity().secondaryTables().next()).setSpecifiedSchema("mySchema");
        JavaSecondaryTableTests.assertNull((Object)((SecondaryTable)this.javaEntity().secondaryTables().next()).getDefaultSchema());
    }

    public void testSetSpecifiedSchema() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable table = (SecondaryTable)this.javaEntity().secondaryTables().next();
        table.setSpecifiedSchema("mySchema");
        table.setSpecifiedName(null);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)typeResource.getAnnotation("javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((String)"mySchema", (String)tableResource.getSchema());
        table.setSpecifiedSchema(null);
        JavaSecondaryTableTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.SecondaryTable"));
    }

    public void testSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        ListIterator specifiedPkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)typeResource.getAnnotation("javax.persistence.SecondaryTable");
        PrimaryKeyJoinColumnAnnotation pkJoinColumn = tableResource.addPkJoinColumn(0);
        pkJoinColumn.setName("FOO");
        specifiedPkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        pkJoinColumn = tableResource.addPkJoinColumn(0);
        pkJoinColumn.setName("BAR");
        specifiedPkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        tableResource.movePkJoinColumn(1, 0);
        specifiedPkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        tableResource.removePkJoinColumn(0);
        specifiedPkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        tableResource.removePkJoinColumn(0);
        specifiedPkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
    }

    public void testSpecifiedPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        JavaSecondaryTableTests.assertEquals((int)0, (int)secondaryTable.specifiedPrimaryKeyJoinColumnsSize());
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaSecondaryTableTests.assertEquals((int)3, (int)secondaryTable.specifiedPrimaryKeyJoinColumnsSize());
    }

    public void testPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        JavaSecondaryTableTests.assertEquals((int)1, (int)secondaryTable.primaryKeyJoinColumnsSize());
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaSecondaryTableTests.assertEquals((int)3, (int)secondaryTable.primaryKeyJoinColumnsSize());
    }

    public void testGetDefaultPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        JavaSecondaryTableTests.assertNotNull((Object)secondaryTable.getDefaultPrimaryKeyJoinColumn());
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaSecondaryTableTests.assertNull((Object)secondaryTable.getDefaultPrimaryKeyJoinColumn());
    }

    public void testPrimaryKeyJoinColumnDefaults() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        PrimaryKeyJoinColumn defaultPkJoinColumn = secondaryTable.getDefaultPrimaryKeyJoinColumn();
        JavaSecondaryTableTests.assertNotNull((Object)defaultPkJoinColumn);
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultName());
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultReferencedColumnName());
        IdMapping idMapping = (IdMapping)this.javaEntity().getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)defaultPkJoinColumn.getDefaultName());
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)defaultPkJoinColumn.getDefaultReferencedColumnName());
        idMapping.getColumn().setSpecifiedName(null);
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultName());
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultReferencedColumnName());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        Iterator specifiedPkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)typeResource.getAnnotation("javax.persistence.SecondaryTable");
        ListIterator pkJoinColumns = tableResource.pkJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumns.hasNext());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn2() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        Iterator specifiedPkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)typeResource.getAnnotation("javax.persistence.SecondaryTable");
        ListIterator pkJoinColumns = tableResource.pkJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumns.hasNext());
    }

    public void testRemoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)typeResource.getAnnotation("javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((int)3, (int)tableResource.pkJoinColumnsSize());
        secondaryTable.removeSpecifiedPrimaryKeyJoinColumn(1);
        ListIterator pkJoinColumnResources = tableResource.pkJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        Iterator pkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumns.hasNext());
        secondaryTable.removeSpecifiedPrimaryKeyJoinColumn(1);
        pkJoinColumnResources = tableResource.pkJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        pkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumns.hasNext());
        secondaryTable.removeSpecifiedPrimaryKeyJoinColumn(0);
        pkJoinColumnResources = tableResource.pkJoinColumns();
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        pkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumns.hasNext());
        JavaSecondaryTableTests.assertEquals((int)0, (int)tableResource.pkJoinColumnsSize());
    }

    public void testMoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        Iterator specifiedPkJoinColumns = secondaryTable.specifiedPrimaryKeyJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)typeResource.getAnnotation("javax.persistence.SecondaryTable");
        ListIterator pkJoinColumns = tableResource.pkJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        secondaryTable.moveSpecifiedPrimaryKeyJoinColumn(2, 0);
        pkJoinColumns = tableResource.pkJoinColumns();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
    }

    public void testPrimaryKeyJoinColumnGetDefaultName() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        PrimaryKeyJoinColumn defaultPkJoinColumn = secondaryTable.getDefaultPrimaryKeyJoinColumn();
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultName());
        JavaPersistentAttribute idAttribute = this.javaPersistentType().getAttributeNamed("id");
        idAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaSecondaryTableTests.assertNull((Object)defaultPkJoinColumn.getDefaultName());
    }

    public void testPrimaryKeyJoinColumnGetDefaultReferencedColumnName() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        PrimaryKeyJoinColumn defaultPkJoinColumn = secondaryTable.getDefaultPrimaryKeyJoinColumn();
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultReferencedColumnName());
        JavaPersistentAttribute idAttribute = this.javaPersistentType().getAttributeNamed("id");
        idAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaSecondaryTableTests.assertNull((Object)defaultPkJoinColumn.getDefaultReferencedColumnName());
    }

    public void testPrimaryKeyJoinColumnIsVirtual() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        JavaSecondaryTableTests.assertTrue((boolean)secondaryTable.getDefaultPrimaryKeyJoinColumn().isVirtual());
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0);
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)secondaryTable.specifiedPrimaryKeyJoinColumns().next();
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumn.isVirtual());
        JavaSecondaryTableTests.assertNull((Object)secondaryTable.getDefaultPrimaryKeyJoinColumn());
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        ListIterator uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaResourcePersistentType resourcePersistentType = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourcePersistentType.getAnnotation("javax.persistence.SecondaryTable");
        secondaryTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        secondaryTableAnnotation.addUniqueConstraint(0).addColumnName(0, "bar");
        uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        JavaSecondaryTableTests.assertEquals((String)"bar", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        JavaSecondaryTableTests.assertEquals((int)0, (int)secondaryTable.uniqueConstraintsSize());
        JavaResourcePersistentType resourcePersistentType = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourcePersistentType.getAnnotation("javax.persistence.SecondaryTable");
        secondaryTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        secondaryTableAnnotation.addUniqueConstraint(1).addColumnName(0, "bar");
        JavaSecondaryTableTests.assertEquals((int)2, (int)secondaryTable.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "BAR");
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType resourcePersistentType = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourcePersistentType.getAnnotation("javax.persistence.SecondaryTable");
        ListIterator uniqueConstraints = secondaryTableAnnotation.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        secondaryTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType resourcePersistentType = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourcePersistentType.getAnnotation("javax.persistence.SecondaryTable");
        ListIterator uniqueConstraints = secondaryTableAnnotation.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        secondaryTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        secondaryTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType resourcePersistentType = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourcePersistentType.getAnnotation("javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((int)3, (int)secondaryTableAnnotation.uniqueConstraintsSize());
        secondaryTable.removeUniqueConstraint(1);
        ListIterator uniqueConstraintAnnotations = secondaryTableAnnotation.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        Iterator uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTable.removeUniqueConstraint(1);
        uniqueConstraintAnnotations = secondaryTableAnnotation.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTable.removeUniqueConstraint(0);
        uniqueConstraintAnnotations = secondaryTableAnnotation.uniqueConstraints();
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        secondaryTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        secondaryTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType resourcePersistentType = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourcePersistentType.getAnnotation("javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((int)3, (int)secondaryTableAnnotation.uniqueConstraintsSize());
        secondaryTable.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        ListIterator uniqueConstraintAnnotations = secondaryTableAnnotation.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        secondaryTable.moveUniqueConstraint(0, 1);
        uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        uniqueConstraintAnnotations = secondaryTableAnnotation.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SecondaryTable secondaryTable = (SecondaryTable)this.javaEntity().specifiedSecondaryTables().next();
        JavaResourcePersistentType resourcePersistentType = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourcePersistentType.getAnnotation("javax.persistence.SecondaryTable");
        secondaryTableAnnotation.addUniqueConstraint(0).addColumnName("FOO");
        secondaryTableAnnotation.addUniqueConstraint(1).addColumnName("BAR");
        secondaryTableAnnotation.addUniqueConstraint(2).addColumnName("BAZ");
        ListIterator uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableAnnotation.moveUniqueConstraint(2, 0);
        uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableAnnotation.moveUniqueConstraint(0, 1);
        uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableAnnotation.removeUniqueConstraint(1);
        uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableAnnotation.removeUniqueConstraint(1);
        uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableAnnotation.removeUniqueConstraint(0);
        uniqueConstraints = secondaryTable.uniqueConstraints();
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }
}

