/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlBasic;
import org.eclipse.jpt.core.resource.orm.XmlBasicImpl;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.core.resource.orm.XmlEmbedded;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddedIdImpl;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddedImpl;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlId;
import org.eclipse.jpt.core.resource.orm.XmlIdImpl;
import org.eclipse.jpt.core.resource.orm.XmlManyToManyImpl;
import org.eclipse.jpt.core.resource.orm.XmlManyToOneImpl;
import org.eclipse.jpt.core.resource.orm.XmlOneToManyImpl;
import org.eclipse.jpt.core.resource.orm.XmlOneToOneImpl;
import org.eclipse.jpt.core.resource.orm.XmlTransient;
import org.eclipse.jpt.core.resource.orm.XmlTransientImpl;
import org.eclipse.jpt.core.resource.orm.XmlVersion;
import org.eclipse.jpt.core.resource.orm.XmlVersionImpl;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmPersistentTypeTests
extends ContextModelTestCase {
    public OrmPersistentTypeTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    public void testMorphXmlTypeMapping() throws Exception {
        OrmPersistentTypeTests.assertFalse((boolean)this.entityMappings().ormPersistentTypes().hasNext());
        OrmPersistentTypeTests.assertTrue((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        OrmPersistentTypeTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        OrmPersistentTypeTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        OrmPersistentType embeddablePersistentType = this.entityMappings().addOrmPersistentType("embeddable", "model.Foo");
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo2");
        OrmPersistentType mappedSuperclassPersistentType = this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo3");
        OrmPersistentType ormPersistentType = (OrmPersistentType)this.entityMappings().ormPersistentTypes().next();
        OrmPersistentTypeTests.assertEquals((Object)mappedSuperclassPersistentType, (Object)ormPersistentType);
        OrmPersistentTypeTests.assertEquals((String)"mappedSuperclass", (String)ormPersistentType.getMapping().getKey());
        ormPersistentType.setMappingKey("embeddable");
        OrmPersistentTypeTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getMappedSuperclasses().size());
        OrmPersistentTypeTests.assertEquals((int)1, (int)this.ormResource().getEntityMappings().getEntities().size());
        OrmPersistentTypeTests.assertEquals((int)2, (int)this.ormResource().getEntityMappings().getEmbeddables().size());
        ListIterator ormPersistentTypes = this.entityMappings().ormPersistentTypes();
        OrmPersistentTypeTests.assertEquals(ormPersistentTypes.next(), (Object)entityPersistentType);
        OrmPersistentTypeTests.assertEquals(ormPersistentTypes.next(), (Object)embeddablePersistentType);
        OrmPersistentTypeTests.assertEquals(ormPersistentTypes.next(), (Object)mappedSuperclassPersistentType);
        OrmPersistentTypeTests.assertEquals((String)"model.Foo", (String)((XmlEmbeddable)this.ormResource().getEntityMappings().getEmbeddables().get(0)).getClassName());
        OrmPersistentTypeTests.assertEquals((String)"model.Foo3", (String)((XmlEmbeddable)this.ormResource().getEntityMappings().getEmbeddables().get(1)).getClassName());
    }

    public void testAddSpecifiedPersistentAttribute() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo2");
        entityPersistentType.addSpecifiedPersistentAttribute("basic", "basicAttribute");
        XmlEntity entity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entity.getAttributes().getBasics().get(0);
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)basic.getName());
        entityPersistentType.addSpecifiedPersistentAttribute("embedded", "embeddedAttribute");
        XmlEmbedded embedded = (XmlEmbedded)entity.getAttributes().getEmbeddeds().get(0);
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)embedded.getName());
        entityPersistentType.addSpecifiedPersistentAttribute("transient", "transientAttribute");
        XmlTransient transientResource = (XmlTransient)entity.getAttributes().getTransients().get(0);
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)transientResource.getName());
        entityPersistentType.addSpecifiedPersistentAttribute("version", "versionAttribute");
        XmlVersion version = (XmlVersion)entity.getAttributes().getVersions().get(0);
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)version.getName());
        entityPersistentType.addSpecifiedPersistentAttribute("id", "idAttribute");
        XmlId id = (XmlId)entity.getAttributes().getIds().get(0);
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)id.getName());
        ListIterator persistentAttributes = entityPersistentType.specifiedAttributes();
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((OrmPersistentAttribute)persistentAttributes.next()).getName());
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)((OrmPersistentAttribute)persistentAttributes.next()).getName());
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)((OrmPersistentAttribute)persistentAttributes.next()).getName());
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)((OrmPersistentAttribute)persistentAttributes.next()).getName());
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((OrmPersistentAttribute)persistentAttributes.next()).getName());
        OrmPersistentTypeTests.assertFalse((boolean)persistentAttributes.hasNext());
    }

    public void testRemoveSpecifiedPersistentAttribute() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo2");
        entityPersistentType.addSpecifiedPersistentAttribute("basic", "basicAttribute");
        entityPersistentType.addSpecifiedPersistentAttribute("embedded", "embeddedAttribute");
        entityPersistentType.addSpecifiedPersistentAttribute("version", "versionAttribute");
        entityPersistentType.addSpecifiedPersistentAttribute("id", "idAttribute");
        entityPersistentType.addSpecifiedPersistentAttribute("transient", "transientAttribute");
        XmlEntity entity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)((XmlBasic)entity.getAttributes().getBasics().get(0)).getName());
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)((XmlEmbedded)entity.getAttributes().getEmbeddeds().get(0)).getName());
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)((XmlVersion)entity.getAttributes().getVersions().get(0)).getName());
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((XmlId)entity.getAttributes().getIds().get(0)).getName());
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        entityPersistentType.removeSpecifiedPersistentAttribute(entityPersistentType.getAttributeNamed("basicAttribute"));
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)((XmlEmbedded)entity.getAttributes().getEmbeddeds().get(0)).getName());
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)((XmlVersion)entity.getAttributes().getVersions().get(0)).getName());
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((XmlId)entity.getAttributes().getIds().get(0)).getName());
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        entityPersistentType.removeSpecifiedPersistentAttribute(entityPersistentType.getAttributeNamed("embeddedAttribute"));
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)((XmlVersion)entity.getAttributes().getVersions().get(0)).getName());
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((XmlId)entity.getAttributes().getIds().get(0)).getName());
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        entityPersistentType.removeSpecifiedPersistentAttribute(entityPersistentType.getAttributeNamed("versionAttribute"));
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((XmlId)entity.getAttributes().getIds().get(0)).getName());
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        entityPersistentType.removeSpecifiedPersistentAttribute(entityPersistentType.getAttributeNamed("idAttribute"));
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        entityPersistentType.removeSpecifiedPersistentAttribute(entityPersistentType.getAttributeNamed("transientAttribute"));
        OrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testRemoveId() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        entityPersistentType.addSpecifiedPersistentAttribute("id", "idAttribute");
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((XmlId)entity.getAttributes().getIds().get(0)).getName());
        entityPersistentType.removeSpecifiedPersistentAttribute(entityPersistentType.getAttributeNamed("idAttribute"));
        OrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testRemoveBasic() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        entityPersistentType.addSpecifiedPersistentAttribute("basic", "basicAttribute");
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)((XmlBasic)entity.getAttributes().getBasics().get(0)).getName());
        entityPersistentType.removeSpecifiedPersistentAttribute(entityPersistentType.getAttributeNamed("basicAttribute"));
        OrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testRemoveVersion() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        entityPersistentType.addSpecifiedPersistentAttribute("version", "versionAttribute");
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)((XmlVersion)entity.getAttributes().getVersions().get(0)).getName());
        entityPersistentType.removeSpecifiedPersistentAttribute(entityPersistentType.getAttributeNamed("versionAttribute"));
        OrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testRemoveEmbedded() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        entityPersistentType.addSpecifiedPersistentAttribute("embedded", "embeddedAttribute");
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)((XmlEmbedded)entity.getAttributes().getEmbeddeds().get(0)).getName());
        entityPersistentType.removeSpecifiedPersistentAttribute(entityPersistentType.getAttributeNamed("embeddedAttribute"));
        OrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testRemoveTransient() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        entityPersistentType.addSpecifiedPersistentAttribute("transient", "transientAttribute");
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        entityPersistentType.removeSpecifiedPersistentAttribute(entityPersistentType.getAttributeNamed("transientAttribute"));
        OrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testUpdateSpecifiedPersistentAttributes() throws Exception {
        OrmPersistentType entityPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        entity.setAttributes(OrmFactory.eINSTANCE.createAttributes());
        XmlBasicImpl basic = OrmFactory.eINSTANCE.createXmlBasicImpl();
        entity.getAttributes().getBasics().add((Object)basic);
        basic.setName("basicAttribute");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)entityPersistentType.attributes().next();
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        XmlEmbeddedImpl embedded = OrmFactory.eINSTANCE.createXmlEmbeddedImpl();
        entity.getAttributes().getEmbeddeds().add((Object)embedded);
        embedded.setName("embeddedAttribute");
        ListIterator attributes = entityPersistentType.attributes();
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        OrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlVersionImpl version = OrmFactory.eINSTANCE.createXmlVersionImpl();
        entity.getAttributes().getVersions().add((Object)version);
        version.setName("versionAttribute");
        attributes = entityPersistentType.attributes();
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        OrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlIdImpl id = OrmFactory.eINSTANCE.createXmlIdImpl();
        entity.getAttributes().getIds().add((Object)id);
        id.setName("idAttribute");
        attributes = entityPersistentType.attributes();
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        OrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlTransientImpl transientResource = OrmFactory.eINSTANCE.createXmlTransientImpl();
        entity.getAttributes().getTransients().add((Object)transientResource);
        transientResource.setName("transientAttribute");
        attributes = entityPersistentType.attributes();
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        OrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlManyToOneImpl manyToOneResource = OrmFactory.eINSTANCE.createXmlManyToOneImpl();
        entity.getAttributes().getManyToOnes().add((Object)manyToOneResource);
        manyToOneResource.setName("manyToOneAttribute");
        attributes = entityPersistentType.attributes();
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"manyToOneAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"manyToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        OrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlManyToManyImpl manyToManyResource = OrmFactory.eINSTANCE.createXmlManyToManyImpl();
        entity.getAttributes().getManyToManys().add((Object)manyToManyResource);
        manyToManyResource.setName("manyToManyAttribute");
        attributes = entityPersistentType.attributes();
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"manyToOneAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"manyToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"manyToManyAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        OrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlOneToManyImpl oneToManyResource = OrmFactory.eINSTANCE.createXmlOneToManyImpl();
        entity.getAttributes().getOneToManys().add((Object)oneToManyResource);
        oneToManyResource.setName("oneToManyAttribute");
        attributes = entityPersistentType.attributes();
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"manyToOneAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"manyToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"oneToManyAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"manyToManyAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        OrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlOneToOneImpl oneToOneResource = OrmFactory.eINSTANCE.createXmlOneToOneImpl();
        entity.getAttributes().getOneToOnes().add((Object)oneToOneResource);
        oneToOneResource.setName("oneToOneAttribute");
        attributes = entityPersistentType.attributes();
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"manyToOneAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"manyToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"oneToManyAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"oneToOneAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"manyToManyAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        OrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlEmbeddedIdImpl embeddedIdResource = OrmFactory.eINSTANCE.createXmlEmbeddedIdImpl();
        entity.getAttributes().getEmbeddedIds().add((Object)embeddedIdResource);
        embeddedIdResource.setName("embeddedIdAttribute");
        attributes = entityPersistentType.attributes();
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"embeddedIdAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"manyToOneAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"manyToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"oneToManyAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"oneToOneAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"manyToManyAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        OrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        OrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        entity.getAttributes().getBasics().remove(0);
        entity.getAttributes().getEmbeddeds().remove(0);
        entity.getAttributes().getTransients().remove(0);
        entity.getAttributes().getIds().remove(0);
        entity.getAttributes().getVersions().remove(0);
        entity.getAttributes().getManyToOnes().remove(0);
        entity.getAttributes().getManyToManys().remove(0);
        entity.getAttributes().getOneToManys().remove(0);
        entity.getAttributes().getOneToOnes().remove(0);
        entity.getAttributes().getEmbeddedIds().remove(0);
        OrmPersistentTypeTests.assertFalse((boolean)entityPersistentType.attributes().hasNext());
        OrmPersistentTypeTests.assertNotNull((Object)entity.getAttributes());
    }
}

