/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.persistence;

import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class ClassRefTests
extends ContextModelTestCase {
    public ClassRefTests(String name) {
        super(name);
    }

    public void testUpdateClassName() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Bar");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        ClassRef classRef = (ClassRef)persistenceUnit.specifiedClassRefs().next();
        ClassRefTests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        xmlClassRef.setJavaClass("com.bar.Foo");
        classRef = (ClassRef)persistenceUnit.specifiedClassRefs().next();
        ClassRefTests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        xmlClassRef.setJavaClass("");
        classRef = (ClassRef)persistenceUnit.specifiedClassRefs().next();
        ClassRefTests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        xmlClassRef.setJavaClass("com.foo.Bar");
        classRef = (ClassRef)persistenceUnit.specifiedClassRefs().next();
        ClassRefTests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
    }

    public void testModifyClassName() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Bar");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        ClassRef classRef = (ClassRef)persistenceUnit.specifiedClassRefs().next();
        ClassRefTests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        classRef.setClassName("com.bar.Foo");
        ClassRefTests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        classRef.setClassName("");
        ClassRefTests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        classRef.setClassName(null);
        ClassRefTests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        classRef.setClassName("com.foo.Bar");
        ClassRefTests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
    }

    public void testGetPersistentType() throws Exception {
        this.createTestType();
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("test.AnnotationTestType");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        ClassRef classRef = this.classRef();
        ClassRefTests.assertEquals((String)"test.AnnotationTestType", (String)classRef.getJavaPersistentType().getName());
        xmlClassRef.setJavaClass("com.foo.Bar");
        classRef = this.classRef();
        ClassRefTests.assertNull((Object)classRef.getJavaPersistentType());
    }
}

