/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class DiscriminatorValueTests
extends JavaResourceModelTestCase {
    public DiscriminatorValueTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestDiscriminatorValue() throws Exception {
        this.createAnnotationAndMembers("DiscriminatorValue", "String value() default \"\";");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.DiscriminatorValue"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@DiscriminatorValue");
            }
        });
    }

    private ICompilationUnit createTestDiscriminatorValueWithValue() throws Exception {
        this.createAnnotationAndMembers("DiscriminatorValue", "String value() default \"\";");
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.DiscriminatorValue"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@DiscriminatorValue(value=\"discriminator\")");
            }
        });
    }

    public void testDiscriminatorValue() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorValue");
        DiscriminatorValueTests.assertNotNull((Object)discriminatorValue);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorValueWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorValue");
        DiscriminatorValueTests.assertEquals((String)"discriminator", (String)discriminatorValue.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorValue");
        discriminatorValue.setValue("foo");
        this.assertSourceContains("@DiscriminatorValue(\"foo\")", cu);
        discriminatorValue.setValue(null);
        this.assertSourceDoesNotContain("@DiscriminatorValue", cu);
    }
}

