/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jpt.core.internal.utility.jdt.JDTMethodAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.core.utility.jdt.FieldAttribute;
import org.eclipse.jpt.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.core.utility.jdt.Type;

public class JPTToolsTests
extends JavaResourceModelTestCase {
    public JPTToolsTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTypeFieldWithModifier(final String modifier) throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    " + modifier + " String foo;").append(CR);
                sb.append(CR);
            }
        });
    }

    protected FieldAttribute fooField(ICompilationUnit cu) {
        return this.buildField("foo", cu);
    }

    private ICompilationUnit createTestTypeGetMethodWithModifier(final String modifier) throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    " + modifier + " int getFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(int id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeInvalidMethodName() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public int foo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(int id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeConstructor() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public AnnotationTestType() {").append(CR);
                sb.append("        super();").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeVoidMethodReturnType() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public void getFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(int id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeIsMethod() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public boolean isFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(boolean id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeIsMethodReturnInt() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public int isFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(int id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeIsAndGetMethodWithModifier(final String modifier) throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    " + modifier + " boolean isFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    " + modifier + " boolean getFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(boolean id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeSetMethodWithModifier(final String modifier) throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public int getFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    " + modifier + " void setFoo(int id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeWithMemberTypes() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendMemberTypeTo(StringBuilder sb) {
                sb.append("     public static class FooStatic {}").append(CR);
                sb.append(CR);
                sb.append("     public class FooNotStatic {}").append(CR);
                sb.append(CR);
                sb.append("     public @interface MyAnnotation {}").append(CR);
                sb.append(CR);
                sb.append("     public enum MyEnum {}").append(CR);
            }
        });
    }

    protected MethodAttribute fooMethod(ICompilationUnit cu) {
        return this.buildMethod("getFoo", cu);
    }

    public void testFieldIsPersistable1() throws Exception {
        ICompilationUnit cu = this.createTestTypeFieldWithModifier("private");
        FieldAttribute fieldAttribute = this.fooField(cu);
        IVariableBinding variableBinding = fieldAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertTrue((boolean)JPTTools.fieldIsPersistable((IVariableBinding)variableBinding));
    }

    public void testFieldIsPersistable2() throws Exception {
        ICompilationUnit cu = this.createTestTypeFieldWithModifier("private static");
        FieldAttribute fieldAttribute = this.fooField(cu);
        IVariableBinding variableBinding = fieldAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertFalse((boolean)JPTTools.fieldIsPersistable((IVariableBinding)variableBinding));
    }

    public void testFieldIsPersistable3() throws Exception {
        ICompilationUnit cu = this.createTestTypeFieldWithModifier("private transient");
        FieldAttribute fieldAttribute = this.fooField(cu);
        IVariableBinding variableBinding = fieldAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertFalse((boolean)JPTTools.fieldIsPersistable((IVariableBinding)variableBinding));
    }

    public void testFieldIsPersistable4() throws Exception {
        ICompilationUnit cu = this.createTestTypeFieldWithModifier("private final");
        FieldAttribute fieldAttribute = this.fooField(cu);
        IVariableBinding variableBinding = fieldAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertTrue((boolean)JPTTools.fieldIsPersistable((IVariableBinding)variableBinding));
    }

    public void testFieldIsPersistable5() throws Exception {
        ICompilationUnit cu = this.createTestTypeFieldWithModifier("public");
        FieldAttribute fieldAttribute = this.fooField(cu);
        IVariableBinding variableBinding = fieldAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertTrue((boolean)JPTTools.fieldIsPersistable((IVariableBinding)variableBinding));
    }

    public void testMethodIsPersistablePropertyGetter1() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("public");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertTrue((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter2() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("protected");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertTrue((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter3() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter4() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("private");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter5() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("public static");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter6() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("public final");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter7() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("public");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertTrue((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter8() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("protected");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertTrue((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter9() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter10() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("private");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter11() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("public static");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter12() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("public final");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter13() throws Exception {
        ICompilationUnit cu = this.createTestTypeIsMethod();
        JDTMethodAttribute methodAttribute = this.buildMethod("isFoo", cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertTrue((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter14() throws Exception {
        ICompilationUnit cu = this.createTestTypeIsMethodReturnInt();
        JDTMethodAttribute methodAttribute = this.buildMethod("isFoo", cu);
        IMethodBinding methodBinding = methodAttribute.getBinding(JDTTools.buildASTRoot((ICompilationUnit)cu));
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)methodBinding));
    }

    public void testMethodIsPersistablePropertyGetter15() throws Exception {
        ICompilationUnit cu = this.createTestTypeIsAndGetMethodWithModifier("public");
        JDTMethodAttribute isFooMethod = this.buildMethod("isFoo", cu);
        JDTMethodAttribute getFooMethod = this.buildMethod("getFoo", cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertTrue((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)isFooMethod.getBinding(astRoot)));
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)getFooMethod.getBinding(astRoot)));
    }

    public void testMethodIsPersistablePropertyGetter16() throws Exception {
        ICompilationUnit cu = this.createTestTypeInvalidMethodName();
        JDTMethodAttribute fooMethod = this.buildMethod("foo", cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)fooMethod.getBinding(astRoot)));
    }

    public void testMethodIsPersistablePropertyGetter17() throws Exception {
        ICompilationUnit cu = this.createTestTypeVoidMethodReturnType();
        JDTMethodAttribute fooMethod = this.buildMethod("getFoo", cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)fooMethod.getBinding(astRoot)));
    }

    public void testMethodIsPersistablePropertyGetter19() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JDTMethodAttribute setIdMethod = this.idSetMethod(cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)setIdMethod.getBinding(astRoot)));
    }

    public void testMethodIsPersistablePropertyGetter20() throws Exception {
        ICompilationUnit cu = this.createTestTypeConstructor();
        JDTMethodAttribute constructor = this.buildMethod("AnnotationTestType", cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)constructor.getBinding(astRoot)));
    }

    public void testMethodIsPersistablePropertyGetter21() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JDTMethodAttribute getNameMethod = this.nameGetMethod(cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertFalse((boolean)JPTTools.methodIsPersistablePropertyGetter((IMethodBinding)getNameMethod.getBinding(astRoot)));
    }

    public void cuIsPersistable() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JDTType type = this.testType(cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertTrue((boolean)JPTTools.typeIsPersistable((ITypeBinding)type.getBinding(astRoot)));
    }

    public void cuIsPersistable2() throws Exception {
        ICompilationUnit cu = this.javaProject.createCompilationUnit("finals", "MyFinal.java", "public final class MyFinal { }");
        JDTType type = this.buildType("MyFinal", cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertFalse((boolean)JPTTools.typeIsPersistable((ITypeBinding)type.getBinding(astRoot)));
    }

    public void cuIsPersistable3() throws Exception {
        ICompilationUnit cu = this.javaProject.createCompilationUnit("interfaces", "MyInterface.java", "public interface MyInterface { }");
        JDTType type = this.buildType("MyInterface", cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertFalse((boolean)JPTTools.typeIsPersistable((ITypeBinding)type.getBinding(astRoot)));
    }

    public void cuIsPersistable4() throws Exception {
        ICompilationUnit cu = this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        JDTType type = this.buildType("TestEnum", cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertFalse((boolean)JPTTools.typeIsPersistable((ITypeBinding)type.getBinding(astRoot)));
    }

    public void cuIsPersistable5() throws Exception {
        ICompilationUnit cu = this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        JDTType type = this.buildType("TestAnnotation", cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertFalse((boolean)JPTTools.typeIsPersistable((ITypeBinding)type.getBinding(astRoot)));
    }

    public void cuIsPersistable6() throws Exception {
        ICompilationUnit cu = this.createTestTypeWithMemberTypes();
        JDTType testType = this.testType(cu);
        JDTType memberType = this.buildType((Type)testType, "FooStatic", 1, cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertTrue((boolean)JPTTools.typeIsPersistable((ITypeBinding)memberType.getBinding(astRoot)));
    }

    public void cuIsPersistable7() throws Exception {
        ICompilationUnit cu = this.createTestTypeWithMemberTypes();
        JDTType testType = this.testType(cu);
        JDTType memberType = this.buildType((Type)testType, "FooNotStatic", 1, cu);
        CompilationUnit astRoot = JDTTools.buildASTRoot((ICompilationUnit)cu);
        JPTToolsTests.assertFalse((boolean)JPTTools.typeIsPersistable((ITypeBinding)memberType.getBinding(astRoot)));
    }
}

