/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NamedNativeQueriesAnnotation;
import org.eclipse.jpt.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class NamedNativeQueriesTests
extends JavaResourceModelTestCase {
    private static final String QUERY_NAME = "myQuery";
    private static final String QUERY_QUERY = "SELECT name FROM Employee";
    private static final String QUERY_RESULT_CLASS = "Result";
    private static final String QUERY_RESULT_SET_MAPPING = "resultSetMapping";

    public NamedNativeQueriesTests(String name) {
        super(name);
    }

    private void createNamedNativeQueryAnnotation() throws Exception {
        this.createQueryHintAnnotation();
        this.createAnnotationAndMembers("NamedNativeQuery", "String name(); String query();QueryHint[] hints() default{};");
    }

    private void createNamedNativeQueriesAnnotation() throws Exception {
        this.createNamedNativeQueryAnnotation();
        this.createAnnotationAndMembers("NamedNativeQueries", "NamedNativeQuery[] value();");
    }

    private void createQueryHintAnnotation() throws Exception {
        this.createAnnotationAndMembers("QueryHint", "String name(); String value();");
    }

    private ICompilationUnit createTestNamedNativeQueries() throws Exception {
        this.createNamedNativeQueriesAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedNativeQueries", "javax.persistence.NamedNativeQuery"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedNativeQueries(@NamedNativeQuery)");
            }
        });
    }

    private ICompilationUnit createTestNamedNativeQueryWithName() throws Exception {
        return this.createTestNamedNativeQueryWithStringElement("name", QUERY_NAME);
    }

    private ICompilationUnit createTestNamedNativeQueryWithQuery() throws Exception {
        return this.createTestNamedNativeQueryWithStringElement("query", QUERY_QUERY);
    }

    private ICompilationUnit createTestNamedNativeQueryWithResultSetMapping() throws Exception {
        return this.createTestNamedNativeQueryWithStringElement(QUERY_RESULT_SET_MAPPING, QUERY_RESULT_SET_MAPPING);
    }

    private ICompilationUnit createTestNamedNativeQueryWithStringElement(final String elementName, final String value) throws Exception {
        this.createNamedNativeQueriesAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedNativeQueries", "javax.persistence.NamedNativeQuery"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedNativeQueries(@NamedNativeQuery(" + elementName + "=\"" + value + "\"))");
            }
        });
    }

    private ICompilationUnit createTestNamedNativeQueryWithResultClass() throws Exception {
        this.createNamedNativeQueriesAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedNativeQueries", "javax.persistence.NamedNativeQuery"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedNativeQueries(@NamedNativeQuery(resultClass=Result.class))");
            }
        });
    }

    private ICompilationUnit createTestNamedNativeQueryWithQueryHints() throws Exception {
        this.createNamedNativeQueriesAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedNativeQueries", "javax.persistence.NamedNativeQuery", "javax.persistence.QueryHint"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedNativeQueries(@NamedNativeQuery(hints={@QueryHint(name=\"BAR\", value=\"FOO\"), @QueryHint}))");
            }
        });
    }

    private ICompilationUnit createTestNamedNativeQuery() throws Exception {
        this.createNamedNativeQueriesAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedNativeQuery", "javax.persistence.QueryHint"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedNativeQuery(name=\"foo\", query=\"bar\", hints=@QueryHint(name=\"BAR\", value=\"FOO\"), resultClass=Foo.class, resultSetMapping=\"mapping\")");
            }
        });
    }

    public void testNamedNativeQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueries();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertNotNull((Object)namedQuery);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
        namedQuery.setName("foo");
        NamedNativeQueriesTests.assertEquals((String)"foo", (String)namedQuery.getName());
        this.assertSourceContains("@NamedNativeQuery(name=\"foo\")", cu);
        namedQuery.setName(null);
        NamedNativeQueriesTests.assertNull((Object)namedQuery.getName());
        this.assertSourceDoesNotContain("@NamedNativeQuery", cu);
    }

    public void testGetQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
    }

    public void testSetQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
        namedQuery.setQuery("foo");
        NamedNativeQueriesTests.assertEquals((String)"foo", (String)namedQuery.getQuery());
        this.assertSourceContains("@NamedNativeQuery(query=\"foo\")", cu);
        namedQuery.setQuery(null);
        NamedNativeQueriesTests.assertNull((Object)namedQuery.getQuery());
        this.assertSourceDoesNotContain("@NamedNativeQuery", cu);
    }

    public void testGetResultClass() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithResultClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertEquals((String)QUERY_RESULT_CLASS, (String)namedQuery.getResultClass());
    }

    public void testSetResultClass() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithResultClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertEquals((String)QUERY_RESULT_CLASS, (String)namedQuery.getResultClass());
        namedQuery.setResultClass("foo");
        NamedNativeQueriesTests.assertEquals((String)"foo", (String)namedQuery.getResultClass());
        this.assertSourceContains("@NamedNativeQuery(resultClass=foo.class)", cu);
        namedQuery.setResultClass(null);
        NamedNativeQueriesTests.assertNull((Object)namedQuery.getResultClass());
        this.assertSourceDoesNotContain("@NamedNativeQuery", cu);
    }

    public void testGetFullyQualifiedClass() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithResultClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertNotNull((Object)namedQuery.getResultClass());
        NamedNativeQueriesTests.assertEquals((String)QUERY_RESULT_CLASS, (String)namedQuery.getFullyQualifiedResultClass());
        namedQuery.setResultClass("AnnotationTestType");
        NamedNativeQueriesTests.assertEquals((String)"test.AnnotationTestType", (String)namedQuery.getFullyQualifiedResultClass());
        this.assertSourceContains("@NamedNativeQuery(resultClass=AnnotationTestType.class)", cu);
    }

    public void testGetResultSetMapping() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithResultSetMapping();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertEquals((String)QUERY_RESULT_SET_MAPPING, (String)namedQuery.getResultSetMapping());
    }

    public void testSetResultSetMapping() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithResultSetMapping();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertEquals((String)QUERY_RESULT_SET_MAPPING, (String)namedQuery.getResultSetMapping());
        namedQuery.setResultSetMapping("foo");
        NamedNativeQueriesTests.assertEquals((String)"foo", (String)namedQuery.getResultSetMapping());
        this.assertSourceContains("@NamedNativeQuery(resultSetMapping=\"foo\")", cu);
        namedQuery.setResultSetMapping(null);
        NamedNativeQueriesTests.assertNull((Object)namedQuery.getResultSetMapping());
        this.assertSourceDoesNotContain("@NamedNativeQuery", cu);
    }

    public void testHints() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueries();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertEquals((int)0, (int)namedQuery.hintsSize());
    }

    public void testHints2() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueries();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        namedQuery.addHint(0);
        namedQuery.addHint(1);
        NamedNativeQueriesTests.assertEquals((int)2, (int)namedQuery.hintsSize());
    }

    public void testHints3() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedNativeQueriesTests.assertEquals((int)2, (int)namedQuery.hintsSize());
    }

    public void testAddHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueries();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        namedQuery.addHint(0).setName("FOO");
        namedQuery.addHint(1);
        namedQuery.addHint(0).setName("BAR");
        NamedNativeQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueriesTests.assertEquals((String)"FOO", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        this.assertSourceContains("@NamedNativeQuery(hints={@QueryHint(name=\"BAR\"),@QueryHint(name=\"FOO\"), @QueryHint})", cu);
    }

    public void testRemoveHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        namedQuery.addHint(0).setName("BAZ");
        NamedNativeQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedNativeQueriesTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.removeHint(2);
        NamedNativeQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueriesTests.assertEquals((int)2, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedNativeQueries(@NamedNativeQuery(hints={@QueryHint(name=\"BAZ\"), @QueryHint(name=\"BAR\", value=\"FOO\")}))", cu);
        namedQuery.removeHint(0);
        NamedNativeQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueriesTests.assertEquals((int)1, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedNativeQueries(@NamedNativeQuery(hints=@QueryHint(name=\"BAR\", value=\"FOO\")))", cu);
        namedQuery.removeHint(0);
        NamedNativeQueriesTests.assertEquals((int)0, (int)namedQuery.hintsSize());
        this.assertSourceDoesNotContain("@NamedNativeQuery", cu);
    }

    public void testMoveHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        namedQuery.addHint(0).setName("BAZ");
        NamedNativeQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedNativeQueriesTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.moveHint(2, 0);
        NamedNativeQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueriesTests.assertNull((Object)namedQuery.hintAt(1).getName());
        NamedNativeQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(2).getName());
        NamedNativeQueriesTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedNativeQueries(@NamedNativeQuery(hints={@QueryHint(name=\"BAR\", value=\"FOO\"), @QueryHint, @QueryHint(name=\"BAZ\")}))", cu);
    }

    public void testMoveHint2() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueriesAnnotation namedQueries = (NamedNativeQueriesAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQueries");
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)namedQueries.nestedAnnotations().next();
        namedQuery.addHint(0).setName("BAZ");
        NamedNativeQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedNativeQueriesTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.moveHint(0, 2);
        NamedNativeQueriesTests.assertNull((Object)namedQuery.hintAt(0).getName());
        NamedNativeQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(2).getName());
        NamedNativeQueriesTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedNativeQueries(@NamedNativeQuery(hints={@QueryHint, @QueryHint(name=\"BAZ\"), @QueryHint(name=\"BAR\", value=\"FOO\")}))", cu);
    }

    public void testAddNamedNativeQueryCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.addAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        namedQuery.setName("BAR");
        this.assertSourceContains("@NamedNativeQueries({@NamedNativeQuery(name=\"foo\", query = \"bar\", hints = @QueryHint(name=\"BAR\", value = \"FOO\"), resultClass = Foo.class, resultSetMapping = \"mapping\"),@NamedNativeQuery(name=\"BAR\")})", cu);
        NamedNativeQueriesTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedNativeQuery"));
        NamedNativeQueriesTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.NamedNativeQueries"));
        NamedNativeQueriesTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")));
    }

    public void testAddNamedNativeQueryToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.addAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        namedQuery.setName("BAR");
        this.assertSourceContains("@NamedNativeQueries({@NamedNativeQuery(name=\"foo\", query = \"bar\", hints = @QueryHint(name=\"BAR\", value = \"FOO\"), resultClass = Foo.class, resultSetMapping = \"mapping\"),@NamedNativeQuery(name=\"BAR\")})", cu);
        namedQuery = (NamedNativeQueryAnnotation)typeResource.addAnnotation(0, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        namedQuery.setName("BAZ");
        this.assertSourceContains("@NamedNativeQueries({@NamedNativeQuery(name=\"BAZ\"),@NamedNativeQuery(name=\"foo\", query = \"bar\", hints = @QueryHint(name=\"BAR\", value = \"FOO\"), resultClass = Foo.class, resultSetMapping = \"mapping\"), @NamedNativeQuery(name=\"BAR\")})", cu);
        Iterator namedQueries = typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        NamedNativeQueriesTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)namedQueries.next()).getName());
        NamedNativeQueriesTests.assertEquals((String)"foo", (String)((NamedNativeQueryAnnotation)namedQueries.next()).getName());
        NamedNativeQueriesTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)namedQueries.next()).getName());
        NamedNativeQueriesTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.NamedNativeQuery"));
        NamedNativeQueriesTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.NamedNativeQueries"));
        NamedNativeQueriesTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries")));
    }

    public void testRemoveNamedNativeQueryCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.addAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        namedQuery.setName("BAR");
        this.assertSourceContains("@NamedNativeQueries({@NamedNativeQuery(name=\"foo\", query = \"bar\", hints = @QueryHint(name=\"BAR\", value = \"FOO\"), resultClass = Foo.class, resultSetMapping = \"mapping\"),@NamedNativeQuery(name=\"BAR\")})", cu);
        typeResource.removeAnnotation(1, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        this.assertSourceContains("@NamedNativeQuery(name=\"foo\", query = \"bar\", hints = @QueryHint(name=\"BAR\", value = \"FOO\"), resultClass = Foo.class, resultSetMapping = \"mapping\")", cu);
    }
}

