/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class NamedNativeQueryTests
extends JavaResourceModelTestCase {
    private static final String QUERY_NAME = "myQuery";
    private static final String QUERY_QUERY = "SELECT name FROM Employee";
    private static final String QUERY_RESULT_CLASS = "Result";
    private static final String QUERY_RESULT_SET_MAPPING = "resultSetMapping";

    public NamedNativeQueryTests(String name) {
        super(name);
    }

    private void createNamedNativeQueryAnnotation() throws Exception {
        this.createQueryHintAnnotation();
        this.createAnnotationAndMembers("NamedNativeQuery", "String name(); String query();QueryHint[] hints() default{};");
    }

    private void createQueryHintAnnotation() throws Exception {
        this.createAnnotationAndMembers("QueryHint", "String name(); String value();");
    }

    private ICompilationUnit createTestNamedNativeQuery() throws Exception {
        this.createNamedNativeQueryAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedNativeQuery"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedNativeQuery");
            }
        });
    }

    private ICompilationUnit createTestNamedNativeQueryWithName() throws Exception {
        return this.createTestNamedNativeQueryWithStringElement("name", QUERY_NAME);
    }

    private ICompilationUnit createTestNamedNativeQueryWithQuery() throws Exception {
        return this.createTestNamedNativeQueryWithStringElement("query", QUERY_QUERY);
    }

    private ICompilationUnit createTestNamedNativeQueryWithResultSetMapping() throws Exception {
        return this.createTestNamedNativeQueryWithStringElement(QUERY_RESULT_SET_MAPPING, QUERY_RESULT_SET_MAPPING);
    }

    private ICompilationUnit createTestNamedNativeQueryWithStringElement(final String elementName, final String value) throws Exception {
        this.createNamedNativeQueryAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedNativeQuery"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedNativeQuery(" + elementName + "=\"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestNamedNativeQueryWithResultClass() throws Exception {
        this.createNamedNativeQueryAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedNativeQuery"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedNativeQuery(resultClass=Result.class)");
            }
        });
    }

    private ICompilationUnit createTestNamedNativeQueryWithQueryHints() throws Exception {
        this.createNamedNativeQueryAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedNativeQuery", "javax.persistence.QueryHint"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedNativeQuery(hints={@QueryHint(name=\"BAR\", value=\"FOO\"), @QueryHint})");
            }
        });
    }

    public void testNamedNativeQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertNotNull((Object)namedQuery);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
        namedQuery.setName("foo");
        NamedNativeQueryTests.assertEquals((String)"foo", (String)namedQuery.getName());
        this.assertSourceContains("@NamedNativeQuery(name=\"foo\")", cu);
        namedQuery.setName(null);
        NamedNativeQueryTests.assertNull((Object)namedQuery.getName());
        this.assertSourceDoesNotContain("@NamedNativeQuery", cu);
    }

    public void testGetQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
    }

    public void testSetQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
        namedQuery.setQuery("foo");
        NamedNativeQueryTests.assertEquals((String)"foo", (String)namedQuery.getQuery());
        this.assertSourceContains("@NamedNativeQuery(query=\"foo\")", cu);
        namedQuery.setQuery(null);
        NamedNativeQueryTests.assertNull((Object)namedQuery.getQuery());
        this.assertSourceDoesNotContain("@NamedNativeQuery", cu);
    }

    public void testGetResultClass() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithResultClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertEquals((String)QUERY_RESULT_CLASS, (String)namedQuery.getResultClass());
    }

    public void testSetResultClass() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithResultClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertEquals((String)QUERY_RESULT_CLASS, (String)namedQuery.getResultClass());
        namedQuery.setResultClass("foo");
        NamedNativeQueryTests.assertEquals((String)"foo", (String)namedQuery.getResultClass());
        this.assertSourceContains("@NamedNativeQuery(resultClass=foo.class)", cu);
        namedQuery.setResultClass(null);
        NamedNativeQueryTests.assertNull((Object)namedQuery.getResultClass());
        this.assertSourceDoesNotContain("@NamedNativeQuery", cu);
    }

    public void testGetFullyQualifiedClass() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithResultClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertNotNull((Object)namedQuery.getResultClass());
        NamedNativeQueryTests.assertEquals((String)QUERY_RESULT_CLASS, (String)namedQuery.getFullyQualifiedResultClass());
        namedQuery.setResultClass("AnnotationTestType");
        NamedNativeQueryTests.assertEquals((String)"test.AnnotationTestType", (String)namedQuery.getFullyQualifiedResultClass());
        this.assertSourceContains("@NamedNativeQuery(resultClass=AnnotationTestType.class)", cu);
    }

    public void testGetResultSetMapping() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithResultSetMapping();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertEquals((String)QUERY_RESULT_SET_MAPPING, (String)namedQuery.getResultSetMapping());
    }

    public void testSetResultSetMapping() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithResultSetMapping();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertEquals((String)QUERY_RESULT_SET_MAPPING, (String)namedQuery.getResultSetMapping());
        namedQuery.setResultSetMapping("foo");
        NamedNativeQueryTests.assertEquals((String)"foo", (String)namedQuery.getResultSetMapping());
        this.assertSourceContains("@NamedNativeQuery(resultSetMapping=\"foo\")", cu);
        namedQuery.setResultSetMapping(null);
        NamedNativeQueryTests.assertNull((Object)namedQuery.getResultSetMapping());
        this.assertSourceDoesNotContain("@NamedNativeQuery", cu);
    }

    public void testHints() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertEquals((int)0, (int)namedQuery.hintsSize());
    }

    public void testHints2() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        namedQuery.addHint(0);
        namedQuery.addHint(1);
        NamedNativeQueryTests.assertEquals((int)2, (int)namedQuery.hintsSize());
    }

    public void testHints3() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        NamedNativeQueryTests.assertEquals((int)2, (int)namedQuery.hintsSize());
    }

    public void testAddHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        namedQuery.addHint(0).setName("FOO");
        namedQuery.addHint(1);
        namedQuery.addHint(0).setName("BAR");
        NamedNativeQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueryTests.assertEquals((String)"FOO", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueryTests.assertNull((Object)namedQuery.hintAt(2).getName());
        this.assertSourceContains("@NamedNativeQuery(hints={@QueryHint(name=\"BAR\"),@QueryHint(name=\"FOO\"), @QueryHint})", cu);
    }

    public void testRemoveHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedNativeQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueryTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedNativeQueryTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.removeHint(2);
        NamedNativeQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueryTests.assertEquals((int)2, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedNativeQuery(hints={@QueryHint(name=\"BAZ\"), @QueryHint(name=\"BAR\", value=\"FOO\")})", cu);
        namedQuery.removeHint(0);
        NamedNativeQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueryTests.assertEquals((int)1, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedNativeQuery(hints=@QueryHint(name=\"BAR\", value=\"FOO\"))", cu);
        namedQuery.removeHint(0);
        NamedNativeQueryTests.assertEquals((int)0, (int)namedQuery.hintsSize());
        this.assertSourceDoesNotContain("@NamedNativeQuery", cu);
    }

    public void testMoveHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedNativeQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueryTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedNativeQueryTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.moveHint(2, 0);
        NamedNativeQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueryTests.assertNull((Object)namedQuery.hintAt(1).getName());
        NamedNativeQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(2).getName());
        NamedNativeQueryTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedNativeQuery(hints={@QueryHint(name=\"BAR\", value=\"FOO\"), @QueryHint, @QueryHint(name=\"BAZ\")})", cu);
    }

    public void testMoveHint2() throws Exception {
        ICompilationUnit cu = this.createTestNamedNativeQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedNativeQueryAnnotation namedQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedNativeQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedNativeQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueryTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedNativeQueryTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.moveHint(0, 2);
        NamedNativeQueryTests.assertNull((Object)namedQuery.hintAt(0).getName());
        NamedNativeQueryTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(1).getName());
        NamedNativeQueryTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(2).getName());
        NamedNativeQueryTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedNativeQuery(hints={@QueryHint, @QueryHint(name=\"BAZ\"), @QueryHint(name=\"BAR\", value=\"FOO\")})", cu);
    }
}

