/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.java.JavaGenerator;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.resource.orm.XmlGenerator;
import org.eclipse.jpt.core.utility.TextRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmGenerator<T extends XmlGenerator>
extends AbstractOrmJpaContextNode
implements OrmGenerator {
    protected String name;
    protected Integer specifiedInitialValue;
    protected Integer defaultInitialValue;
    protected Integer specifiedAllocationSize;
    protected Integer defaultAllocationSize;
    protected T generatorResource;

    protected AbstractOrmGenerator(OrmJpaContextNode parent) {
        super(parent);
    }

    @Override
    public boolean isVirtual() {
        return this.getGeneratorResource().isVirtual();
    }

    @Override
    public OrmJpaContextNode getParent() {
        return (OrmJpaContextNode)super.getParent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.getGeneratorResource().setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public Integer getInitialValue() {
        return this.getSpecifiedInitialValue() == null ? this.getDefaultInitialValue() : this.getSpecifiedInitialValue();
    }

    @Override
    public Integer getSpecifiedInitialValue() {
        return this.specifiedInitialValue;
    }

    @Override
    public void setSpecifiedInitialValue(Integer newSpecifiedInitialValue) {
        Integer oldSpecifiedInitialValue = this.specifiedInitialValue;
        this.specifiedInitialValue = newSpecifiedInitialValue;
        this.getGeneratorResource().setInitialValue(newSpecifiedInitialValue);
        this.firePropertyChanged("specifiedInitialValueProperty", oldSpecifiedInitialValue, newSpecifiedInitialValue);
    }

    protected void setSpecifiedInitialValue_(Integer newSpecifiedInitialValue) {
        Integer oldSpecifiedInitialValue = this.specifiedInitialValue;
        this.specifiedInitialValue = newSpecifiedInitialValue;
        this.firePropertyChanged("specifiedInitialValueProperty", oldSpecifiedInitialValue, newSpecifiedInitialValue);
    }

    @Override
    public Integer getDefaultInitialValue() {
        return this.defaultInitialValue;
    }

    protected void setDefaultInitialValue(Integer newDefaultInitialValue) {
        Integer oldSpecifiedInitialValue = this.defaultInitialValue;
        this.defaultInitialValue = newDefaultInitialValue;
        this.firePropertyChanged("defaultInitialValueProperty", oldSpecifiedInitialValue, newDefaultInitialValue);
    }

    @Override
    public Integer getAllocationSize() {
        return this.getSpecifiedAllocationSize() == null ? this.getDefaultAllocationSize() : this.getSpecifiedAllocationSize();
    }

    @Override
    public Integer getSpecifiedAllocationSize() {
        return this.specifiedAllocationSize;
    }

    @Override
    public void setSpecifiedAllocationSize(Integer newSpecifiedAllocationSize) {
        Integer oldSpecifiedAllocationSize = this.specifiedAllocationSize;
        this.specifiedAllocationSize = newSpecifiedAllocationSize;
        this.getGeneratorResource().setAllocationSize(newSpecifiedAllocationSize);
        this.firePropertyChanged("specifiedAllocationSizeProperty", oldSpecifiedAllocationSize, newSpecifiedAllocationSize);
    }

    protected void setSpecifiedAllocationSize_(Integer newSpecifiedAllocationSize) {
        Integer oldSpecifiedAllocationSize = this.specifiedAllocationSize;
        this.specifiedAllocationSize = newSpecifiedAllocationSize;
        this.firePropertyChanged("specifiedAllocationSizeProperty", oldSpecifiedAllocationSize, newSpecifiedAllocationSize);
    }

    @Override
    public Integer getDefaultAllocationSize() {
        return this.defaultAllocationSize;
    }

    protected void setDefaultAllocationSize(Integer newDefaultAllocationSize) {
        Integer oldSpecifiedAllocationSize = this.defaultAllocationSize;
        this.defaultAllocationSize = newDefaultAllocationSize;
        this.firePropertyChanged("defaultAllocationSizeProperty", oldSpecifiedAllocationSize, newDefaultAllocationSize);
    }

    public void initialize(T generatorResource) {
        this.generatorResource = generatorResource;
        this.name = this.name((XmlGenerator)generatorResource);
        this.specifiedInitialValue = this.specifiedInitialValue((XmlGenerator)generatorResource);
        this.specifiedAllocationSize = this.specifiedAllocationSize((XmlGenerator)generatorResource);
    }

    public void update(T generatorResource) {
        this.generatorResource = generatorResource;
        this.setName_(this.name((XmlGenerator)generatorResource));
        this.setSpecifiedInitialValue_(this.specifiedInitialValue((XmlGenerator)generatorResource));
        this.setSpecifiedAllocationSize_(this.specifiedAllocationSize((XmlGenerator)generatorResource));
    }

    @Override
    public boolean overrides(Generator generator) {
        if (this.getName() == null) {
            return false;
        }
        return this.getName().equals(generator.getName()) && generator instanceof JavaGenerator;
    }

    protected T getGeneratorResource() {
        return this.generatorResource;
    }

    protected String name(XmlGenerator generatorResource) {
        return generatorResource.getName();
    }

    protected Integer specifiedInitialValue(XmlGenerator generatorResource) {
        return generatorResource.getInitialValue();
    }

    protected Integer specifiedAllocationSize(XmlGenerator generatorResource) {
        return generatorResource.getAllocationSize();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange validationTextRange = this.getGeneratorResource().getValidationTextRange();
        return validationTextRange != null ? validationTextRange : this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        TextRange nameTextRange = this.getGeneratorResource().getNameTextRange();
        return nameTextRange != null ? nameTextRange : this.getValidationTextRange();
    }
}

