/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractRelationshipMappingAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToOneImpl
extends AbstractRelationshipMappingAnnotation
implements OneToOneAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.OneToOne");
    static final DeclarationAnnotationElementAdapter<String> TARGET_ENTITY_ADAPTER = OneToOneImpl.buildTargetEntityAdapter();
    private static final DeclarationAnnotationElementAdapter<String[]> CASCADE_ADAPTER = OneToOneImpl.buildCascadeAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = OneToOneImpl.buildFetchAdapter();
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = OneToOneImpl.buildOptionalAdapter();
    private static final DeclarationAnnotationElementAdapter<String> MAPPED_BY_ADAPTER = OneToOneImpl.buildMappedByAdapter();
    private final AnnotationElementAdapter<Boolean> optionalAdapter;
    private final AnnotationElementAdapter<String> mappedByAdapter = this.buildAnnotationElementAdapter(MAPPED_BY_ADAPTER);
    private Boolean optional;
    private String mappedBy;

    public OneToOneImpl(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.optionalAdapter = this.buildBooleanAnnotationElementAdapter(OPTIONAL_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.mappedBy = this.mappedBy(astRoot);
        this.optional = this.optional(astRoot);
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> targetEntityAdapter() {
        return TARGET_ENTITY_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String[]> cascadeAdapter() {
        return CASCADE_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> fetchAdapter() {
        return FETCH_ADAPTER;
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.OneToOne";
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean newOptional) {
        if (this.attributeValueHasNotChanged(this.optional, newOptional)) {
            return;
        }
        Boolean oldOptional = this.optional;
        this.optional = newOptional;
        this.optionalAdapter.setValue(newOptional);
        this.firePropertyChanged("optionalProperty", oldOptional, newOptional);
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String newMappedBy) {
        if (this.attributeValueHasNotChanged(this.mappedBy, newMappedBy)) {
            return;
        }
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        this.mappedByAdapter.setValue(newMappedBy);
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    @Override
    public TextRange getMappedByTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(MAPPED_BY_ADAPTER, astRoot);
    }

    @Override
    public TextRange getOptionalTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(OPTIONAL_ADAPTER, astRoot);
    }

    @Override
    public boolean mappedByTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(MAPPED_BY_ADAPTER, pos, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setOptional(this.optional(astRoot));
        this.setMappedBy(this.mappedByAdapter.getValue(astRoot));
    }

    protected String mappedBy(CompilationUnit astRoot) {
        return this.mappedByAdapter.getValue(astRoot);
    }

    protected Boolean optional(CompilationUnit astRoot) {
        return this.optionalAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter() {
        return OneToOneImpl.buildTargetEntityAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetEntity");
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildCascadeAdapter() {
        return OneToOneImpl.buildEnumArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "cascade");
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return OneToOneImpl.buildFetchAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return OneToOneImpl.buildOptionalAdapter(DECLARATION_ANNOTATION_ADAPTER, "optional");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Boolean>(annotationAdapter, elementName, false, BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildMappedByAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "mappedBy", false);
    }

    public static class OneToOneAnnotationDefinition
    implements AnnotationDefinition {
        private static final OneToOneAnnotationDefinition INSTANCE = new OneToOneAnnotationDefinition();

        public static OneToOneAnnotationDefinition instance() {
            return INSTANCE;
        }

        private OneToOneAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new OneToOneImpl((JavaResourcePersistentAttribute)parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.OneToOne";
        }
    }
}

