/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.customization;

import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.internal.context.persistence.GenericProperty;
import org.eclipse.jpt.eclipselink.core.internal.context.EclipseLinkJpaProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.PersistenceUnitPropertyListListener;
import org.eclipse.jpt.eclipselink.core.internal.context.customization.Customization;
import org.eclipse.jpt.eclipselink.core.internal.context.customization.CustomizerProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.customization.EclipseLinkCustomization;
import org.eclipse.jpt.eclipselink.core.internal.context.customization.Weaving;
import org.eclipse.jpt.eclipselink.core.tests.internal.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

public class CustomizationAdapterTests
extends PersistenceUnitTestCase {
    private Customization customization;
    private ListChangeEvent entitiesEvent;
    public static final String ENTITY_TEST = "Employee";
    public static final String ENTITY_TEST_2 = "Address";
    public static final String THROW_EXCEPTIONS_KEY = "eclipselink.orm.throw.exceptions";
    public static final Boolean THROW_EXCEPTIONS_TEST_VALUE = false;
    public static final Boolean THROW_EXCEPTIONS_TEST_VALUE_2 = THROW_EXCEPTIONS_TEST_VALUE == false;
    public static final String WEAVING_LAZY_KEY = "eclipselink.weaving.lazy";
    public static final Boolean WEAVING_LAZY_TEST_VALUE = false;
    public static final Boolean WEAVING_LAZY_TEST_VALUE_2 = WEAVING_LAZY_TEST_VALUE == false;
    public static final String WEAVING_CHANGE_TRACKING_KEY = "eclipselink.weaving.changetracking";
    public static final Boolean WEAVING_CHANGE_TRACKING_TEST_VALUE = false;
    public static final Boolean WEAVING_CHANGE_TRACKING_TEST_VALUE_2 = WEAVING_CHANGE_TRACKING_TEST_VALUE == false;
    public static final String WEAVING_FETCH_GROUPS_KEY = "eclipselink.weaving.fetchgroups";
    public static final Boolean WEAVING_FETCH_GROUPS_TEST_VALUE = false;
    public static final Boolean WEAVING_FETCH_GROUPS_TEST_VALUE_2 = WEAVING_FETCH_GROUPS_TEST_VALUE == false;
    private static final String SESSION_CUSTOMIZER_KEY = "eclipselink.session.customizer";
    private static final String SESSION_CUSTOMIZER_TEST_VALUE = "session.customizer.test";
    private static final String SESSION_CUSTOMIZER_TEST_VALUE_2 = "session.customizer-2.test";
    public static final String WEAVING_KEY = "eclipselink.weaving";
    public static final Weaving WEAVING_TEST_VALUE = Weaving.false_;
    public static final Weaving WEAVING_TEST_VALUE_2 = Weaving.static_;
    public static final String CUSTOMIZER_KEY = "eclipselink.descriptor.customizer.Employee";
    public static final String CUSTOMIZER_TEST_VALUE = "acme.sessions.DescriptorCustomizer";
    public static final String CUSTOMIZER_TEST_VALUE_2 = "acme.sessions.Customizer";

    public CustomizationAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.customization = this.persistenceUnitProperties.getCustomization();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.customization.addPropertyChangeListener("throwExceptionsProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingLazyProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingChangeTrackingProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingFetchGroupsProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("sessionCustomizerProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("weavingProperty", propertyChangeListener);
        this.customization.addPropertyChangeListener("descriptorCustomizerProperty", propertyChangeListener);
        ListChangeListener entitiesChangeListener = this.buildEntitiesChangeListener();
        this.customization.addListChangeListener("entitiesListProperty", entitiesChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 7;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 4;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitPut("misc.property.1", "value.1");
        this.persistenceUnitPut(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE.toString());
        this.persistenceUnitPut(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE.toString());
        this.persistenceUnitPut(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE.toString());
        this.persistenceUnitPut(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE.toString());
        this.persistenceUnitPut("misc.property.2", "value.2");
        this.persistenceUnitPut(SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE.toString());
        this.persistenceUnitPut(WEAVING_KEY, WEAVING_TEST_VALUE);
        this.persistenceUnitPut("misc.property.3", "value.3");
        this.persistenceUnitPut("misc.property.4", "value.4");
        this.persistenceUnitPut(CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE);
    }

    private ListChangeListener buildEntitiesChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void listCleared(ListChangeEvent e) {
                CustomizationAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void listChanged(ListChangeEvent e) {
                CustomizationAdapterTests.this.entityChanged(e);
            }
        };
    }

    protected void clearEvent() {
        super.clearEvent();
        this.entitiesEvent = null;
    }

    void entityChanged(ListChangeEvent e) {
        this.entitiesEvent = e;
    }

    public void testEntitiesList() throws Exception {
        this.clearEvent();
        this.customization.addEntity(ENTITY_TEST_2);
        CustomizationAdapterTests.assertNotNull((String)"No Event Fired.", (Object)this.entitiesEvent);
        CustomizationAdapterTests.assertEquals((String)"Wrong Event.", (String)this.entitiesEvent.getAspectName(), (String)"entitiesListProperty");
        this.clearEvent();
        this.customization.removeEntity(ENTITY_TEST_2);
        CustomizationAdapterTests.assertNotNull((String)"No Event Fired.", (Object)this.entitiesEvent);
        CustomizationAdapterTests.assertEquals((String)"Wrong Event.", (String)this.entitiesEvent.getAspectName(), (String)"entitiesListProperty");
    }

    public void testHasListeners() throws Exception {
        ListAspectAdapter propertiesAdapter = (ListAspectAdapter)((EclipseLinkJpaProperties)this.persistenceUnitProperties).propertiesAdapter();
        GenericProperty ctdProperty = (GenericProperty)this.persistenceUnit().getProperty(THROW_EXCEPTIONS_KEY);
        ListValueModel propertyListAdapter = ((EclipseLinkJpaProperties)this.persistenceUnitProperties).propertyListAdapter();
        CustomizationAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        CustomizationAdapterTests.assertTrue((boolean)ctdProperty.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "throwExceptionsProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingLazyProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingChangeTrackingProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingFetchGroupsProperty");
        this.verifyHasListeners(propertyListAdapter);
        EclipseLinkCustomization elCustomization = (EclipseLinkCustomization)this.customization;
        PersistenceUnitPropertyListListener propertyListListener = elCustomization.propertyListListener();
        propertyListAdapter.removeListChangeListener("list values", (ListChangeListener)propertyListListener);
        CustomizationAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "throwExceptionsProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingLazyProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingChangeTrackingProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.customization, "weavingFetchGroupsProperty");
    }

    public void testSetThrowExceptions() throws Exception {
        this.verifyModelInitialized(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE);
        this.verifySetProperty(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE, THROW_EXCEPTIONS_TEST_VALUE_2);
    }

    public void testAddRemoveThrowExceptions() throws Exception {
        this.verifyAddRemoveProperty(THROW_EXCEPTIONS_KEY, THROW_EXCEPTIONS_TEST_VALUE, THROW_EXCEPTIONS_TEST_VALUE_2);
    }

    public void testSetWeavingLazy() throws Exception {
        this.verifyModelInitialized(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE);
        this.verifySetProperty(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE, WEAVING_LAZY_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingLazy() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_LAZY_KEY, WEAVING_LAZY_TEST_VALUE, WEAVING_LAZY_TEST_VALUE_2);
    }

    public void testSetWeavingChangeTracking() throws Exception {
        this.verifyModelInitialized(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE);
        this.verifySetProperty(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE, WEAVING_CHANGE_TRACKING_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingChangeTracking() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_CHANGE_TRACKING_KEY, WEAVING_CHANGE_TRACKING_TEST_VALUE, WEAVING_CHANGE_TRACKING_TEST_VALUE_2);
    }

    public void testSetWeavingFetchGroups() throws Exception {
        this.verifyModelInitialized(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE);
        this.verifySetProperty(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE, WEAVING_FETCH_GROUPS_TEST_VALUE_2);
    }

    public void testAddRemoveWeavingFetchGroups() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_FETCH_GROUPS_KEY, WEAVING_FETCH_GROUPS_TEST_VALUE, WEAVING_FETCH_GROUPS_TEST_VALUE_2);
    }

    public void testSetSessionCustomizer() throws Exception {
        this.verifyModelInitialized(SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE);
        this.verifySetProperty(SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE, SESSION_CUSTOMIZER_TEST_VALUE_2);
    }

    public void testAddRemoveSessionCustomizer() throws Exception {
        this.verifyAddRemoveProperty(SESSION_CUSTOMIZER_KEY, SESSION_CUSTOMIZER_TEST_VALUE, SESSION_CUSTOMIZER_TEST_VALUE_2);
    }

    public void testSetWeaving() throws Exception {
        this.verifyModelInitialized(WEAVING_KEY, WEAVING_TEST_VALUE);
        this.verifySetProperty(WEAVING_KEY, WEAVING_TEST_VALUE, WEAVING_TEST_VALUE_2);
    }

    public void testAddRemoveWeaving() throws Exception {
        this.verifyAddRemoveProperty(WEAVING_KEY, WEAVING_TEST_VALUE, WEAVING_TEST_VALUE_2);
    }

    public void testSetCustomization() throws Exception {
        this.verifyModelInitialized(CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE);
        this.verifySetCustomizationProperty("descriptorCustomizerProperty", CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE, CUSTOMIZER_TEST_VALUE_2);
    }

    public void testAddRemoveCustomization() throws Exception {
        this.verifyAddRemoveCustomizationProperty("descriptorCustomizerProperty", CUSTOMIZER_KEY, CUSTOMIZER_TEST_VALUE, CUSTOMIZER_TEST_VALUE_2);
    }

    protected void verifySetCustomizationProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        ListValueModel propertyListAdapter = ((EclipseLinkJpaProperties)this.persistenceUnitProperties).propertyListAdapter();
        this.verifyInitialState(propertyName, key, (ListValueModel<Property>)propertyListAdapter);
        this.persistenceUnitPut(key, testValue2);
        CustomizationAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue2);
        this.clearEvent();
        this.setCustomizationProperty(propertyName, ENTITY_TEST, testValue1);
        CustomizationAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue1);
    }

    protected void verifyAddRemoveCustomizationProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        ListValueModel propertyListAdapter = ((EclipseLinkJpaProperties)this.persistenceUnitProperties).propertyListAdapter();
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.persistenceUnit().removeProperty(key);
        CustomizationAdapterTests.assertFalse((boolean)this.persistenceUnit().containsProperty(key));
        CustomizationAdapterTests.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, null);
        CustomizationAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitPut(key, testValue1);
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue1);
        CustomizationAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        this.persistenceUnitPut(key, testValue2);
        this.verifyPutCustomizationProperty(propertyName, ENTITY_TEST, testValue2);
    }

    protected void verifyPutCustomizationProperty(String propertyName, String entityName, Object expectedValue) throws Exception {
        this.verifyEvent(propertyName);
        this.verifyCustomizationEvent(propertyName, entityName, expectedValue);
    }

    protected void verifyCustomizationEvent(String propertyName, String entityName, Object expectedValue) throws Exception {
        CustomizerProperties customizer = (CustomizerProperties)this.propertyChangedEvent.getNewValue();
        if (propertyName.equals("descriptorCustomizerProperty")) {
            CustomizationAdapterTests.assertEquals((Object)expectedValue, (Object)customizer.getClassName());
            CustomizationAdapterTests.assertEquals((Object)expectedValue, (Object)this.customization.getDescriptorCustomizer(entityName));
        } else {
            this.throwMissingDefinition("verifyCustomizationEvent", propertyName);
        }
    }

    protected void setCustomizationProperty(String propertyName, String entityName, Object newValue) throws NoSuchFieldException {
        if (propertyName.equals("descriptorCustomizerProperty")) {
            this.customization.setDescriptorCustomizer((String)newValue, entityName);
        } else {
            this.throwMissingDefinition("setCustomizationProperty", propertyName);
        }
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("throwExceptionsProperty")) {
            this.customization.setThrowExceptions((Boolean)newValue);
        } else if (propertyName.equals("weavingLazyProperty")) {
            this.customization.setWeavingLazy((Boolean)newValue);
        } else if (propertyName.equals("weavingChangeTrackingProperty")) {
            this.customization.setWeavingChangeTracking((Boolean)newValue);
        } else if (propertyName.equals("weavingFetchGroupsProperty")) {
            this.customization.setWeavingFetchGroups((Boolean)newValue);
        } else if (propertyName.equals("sessionCustomizerProperty")) {
            this.customization.setSessionCustomizer((String)newValue);
        } else if (propertyName.equals("weavingProperty")) {
            this.customization.setWeaving((Weaving)newValue);
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("throwExceptionsProperty")) {
            modelValue = this.customization.getThrowExceptions();
        } else if (propertyName.equals("weavingProperty")) {
            modelValue = this.customization.getWeaving();
        } else if (propertyName.equals("weavingLazyProperty")) {
            modelValue = this.customization.getWeavingLazy();
        } else if (propertyName.equals("weavingChangeTrackingProperty")) {
            modelValue = this.customization.getWeavingChangeTracking();
        } else if (propertyName.equals("weavingFetchGroupsProperty")) {
            modelValue = this.customization.getWeavingFetchGroups();
        } else if (propertyName.equals("sessionCustomizerProperty")) {
            modelValue = this.customization.getSessionCustomizer();
        } else if (propertyName.equals("descriptorCustomizerProperty")) {
            modelValue = this.customization.getDescriptorCustomizer(ENTITY_TEST);
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected PersistenceUnitProperties model() {
        return this.customization;
    }
}

