/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.schema.generation;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.internal.context.persistence.GenericProperty;
import org.eclipse.jpt.eclipselink.core.internal.context.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.PersistenceUnitPropertyListListener;
import org.eclipse.jpt.eclipselink.core.internal.context.schema.generation.DdlGenerationType;
import org.eclipse.jpt.eclipselink.core.internal.context.schema.generation.EclipseLinkSchemaGeneration;
import org.eclipse.jpt.eclipselink.core.internal.context.schema.generation.OutputMode;
import org.eclipse.jpt.eclipselink.core.internal.context.schema.generation.SchemaGeneration;
import org.eclipse.jpt.eclipselink.core.tests.internal.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerationBasicAdapterTests
extends PersistenceUnitTestCase {
    private SchemaGeneration schemaGeneration;
    public static final String outputModeKey = "eclipselink.ddl-generation.output-mode";
    public static final String ddlGenTypeKey = "eclipselink.ddl-generation";
    public static final OutputMode OUTPUT_MODE_TEST_VALUE = OutputMode.sql_script;
    public static final OutputMode OUTPUT_MODE_TEST_VALUE_2 = OutputMode.database;
    public static final DdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE = DdlGenerationType.drop_and_create_tables;
    public static final DdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE_2 = DdlGenerationType.none;

    public SchemaGenerationBasicAdapterTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.schemaGeneration = this.persistenceUnitProperties.getSchemaGeneration();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.schemaGeneration.addPropertyChangeListener("outputModeProperty", propertyChangeListener);
        this.schemaGeneration.addPropertyChangeListener("ddlGenerationTypeProperty", propertyChangeListener);
        this.clearEvent();
    }

    @Override
    protected void populatePu() {
        this.propertiesTotal = 6;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal = 2;
        this.persistenceUnitPut("property.0", "value.0");
        this.persistenceUnitPut(outputModeKey, this.getEclipseLinkStringValueOf(OUTPUT_MODE_TEST_VALUE));
        this.persistenceUnitPut("property.2", "value.2");
        this.persistenceUnitPut("property.3", "value.3");
        this.persistenceUnitPut("property.4", "value.4");
        this.persistenceUnitPut(ddlGenTypeKey, this.getEclipseLinkStringValueOf(DDL_GENERATION_TYPE_TEST_VALUE));
    }

    public void testHasListeners() throws Exception {
        ListAspectAdapter propertiesAdapter = (ListAspectAdapter)this.buildPropertiesAdapter((PropertyValueModel<PersistenceUnit>)this.subjectHolder);
        SchemaGenerationBasicAdapterTests.assertFalse((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        GenericProperty outputModeProperty = (GenericProperty)this.persistenceUnit().getProperty(outputModeKey);
        GenericProperty ddlGenTypeProperty = (GenericProperty)this.persistenceUnit().getProperty(ddlGenTypeKey);
        SchemaGenerationBasicAdapterTests.assertTrue((boolean)outputModeProperty.hasAnyPropertyChangeListeners("value"));
        ItemPropertyListValueModelAdapter propertyListAdapter = new ItemPropertyListValueModelAdapter((ListValueModel)propertiesAdapter, new String[]{"value", "name"});
        SchemaGenerationBasicAdapterTests.assertFalse((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        SchemaGenerationBasicAdapterTests.assertTrue((boolean)outputModeProperty.hasAnyPropertyChangeListeners("value"));
        SchemaGenerationBasicAdapterTests.assertTrue((boolean)ddlGenTypeProperty.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners((PersistenceUnitProperties)this.schemaGeneration, "outputModeProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.schemaGeneration, "ddlGenerationTypeProperty");
        this.verifyHasNoListeners((ListValueModel)propertyListAdapter);
        PersistenceUnitPropertyListListener propertyListListener = new PersistenceUnitPropertyListListener((PersistenceUnitProperties)this.schemaGeneration);
        propertyListAdapter.addListChangeListener("list values", (ListChangeListener)propertyListListener);
        SchemaGenerationBasicAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        SchemaGenerationBasicAdapterTests.assertTrue((boolean)outputModeProperty.hasAnyPropertyChangeListeners("value"));
        SchemaGenerationBasicAdapterTests.assertTrue((boolean)ddlGenTypeProperty.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners((ListValueModel)propertyListAdapter);
        propertyListAdapter.removeListChangeListener("list values", (ListChangeListener)propertyListListener);
        SchemaGenerationBasicAdapterTests.assertFalse((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        SchemaGenerationBasicAdapterTests.assertTrue((boolean)outputModeProperty.hasAnyPropertyChangeListeners("value"));
        SchemaGenerationBasicAdapterTests.assertTrue((boolean)ddlGenTypeProperty.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners((ListValueModel)propertyListAdapter);
    }

    public void testOutputModeUpdate() throws Exception {
        ListValueModel<Property> propertiesAdapter = this.buildPropertiesAdapter((PropertyValueModel<PersistenceUnit>)this.subjectHolder);
        ItemPropertyListValueModelAdapter propertyListAdapter = new ItemPropertyListValueModelAdapter(propertiesAdapter, new String[]{"value"});
        PersistenceUnitPropertyListListener propertyListListener = ((EclipseLinkSchemaGeneration)this.schemaGeneration).propertyListListener();
        propertyListAdapter.addListChangeListener("list values", (ListChangeListener)propertyListListener);
        this.verifyHasListeners((ListValueModel)propertyListAdapter);
        this.verifyHasListeners((PersistenceUnitProperties)this.schemaGeneration, "outputModeProperty");
        SchemaGenerationBasicAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        SchemaGenerationBasicAdapterTests.assertTrue((boolean)this.schemaGeneration.itemIsProperty(this.persistenceUnit().getProperty(outputModeKey)));
        SchemaGenerationBasicAdapterTests.assertEquals((Object)OUTPUT_MODE_TEST_VALUE, (Object)this.schemaGeneration.getOutputMode());
        this.persistenceUnitPut(outputModeKey, OUTPUT_MODE_TEST_VALUE_2);
        this.verifyPutEvent("outputModeProperty", OUTPUT_MODE_TEST_VALUE_2, this.schemaGeneration.getOutputMode());
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.persistenceUnit().removeProperty(outputModeKey);
        SchemaGenerationBasicAdapterTests.assertFalse((boolean)this.persistenceUnit().containsProperty(outputModeKey));
        SchemaGenerationBasicAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        SchemaGenerationBasicAdapterTests.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        SchemaGenerationBasicAdapterTests.assertNotNull((Object)this.propertyChangedEvent);
        SchemaGenerationBasicAdapterTests.assertNull((Object)this.propertyChangedEvent.getNewValue());
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitPut(outputModeKey, OUTPUT_MODE_TEST_VALUE);
        this.verifyPutEvent("outputModeProperty", OUTPUT_MODE_TEST_VALUE, this.schemaGeneration.getOutputMode());
        this.persistenceUnitPut(outputModeKey, OUTPUT_MODE_TEST_VALUE_2);
        this.verifyPutEvent("outputModeProperty", OUTPUT_MODE_TEST_VALUE_2, this.schemaGeneration.getOutputMode());
        this.clearEvent();
        this.schemaGeneration.setOutputMode(OUTPUT_MODE_TEST_VALUE);
        this.verifyPutEvent("outputModeProperty", OUTPUT_MODE_TEST_VALUE, this.schemaGeneration.getOutputMode());
    }

    @Override
    protected PersistenceUnitProperties model() {
        return this.schemaGeneration;
    }

    private ListValueModel<Property> buildPropertiesAdapter(PropertyValueModel<PersistenceUnit> subjectHolder) {
        return new ListAspectAdapter<PersistenceUnit, Property>(subjectHolder, new String[]{"properties"}){

            protected ListIterator<Property> listIterator_() {
                return ((PersistenceUnit)this.subject).properties();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).propertiesSize();
            }
        };
    }

    @Override
    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

