/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ListModelAdapter;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;
import org.eclipse.jpt.utility.tests.internal.model.value.CoordinatedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyListValueModelAdapterTests
extends TestCase {
    private ListValueModel<String> adapter;
    private WritablePropertyValueModel<String> wrappedValueHolder;

    public PropertyListValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.wrappedValueHolder = new SimplePropertyValueModel();
        this.adapter = new PropertyListValueModelAdapter(this.wrappedValueHolder);
    }

    private Collection<String> wrappedList() {
        return CollectionTools.list((Iterator)new SingleElementIterator((Object)((String)this.wrappedValueHolder.getValue())));
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListener(){

            public void itemsAdded(ListChangeEvent event) {
            }
        });
        PropertyListValueModelAdapterTests.assertFalse((boolean)this.adapter.iterator().hasNext());
        this.wrappedValueHolder.setValue((Object)"foo");
        List adapterList = CollectionTools.list((Iterator)this.adapter.iterator());
        PropertyListValueModelAdapterTests.assertEquals((int)1, (int)adapterList.size());
        PropertyListValueModelAdapterTests.assertEquals(this.wrappedList(), (Object)adapterList);
        PropertyListValueModelAdapterTests.assertEquals((String)"foo", (String)((String)adapterList.iterator().next()));
    }

    public void testGetInt() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListener(){

            public void itemsAdded(ListChangeEvent event) {
            }
        });
        this.wrappedValueHolder.setValue((Object)"foo");
        PropertyListValueModelAdapterTests.assertEquals((String)"foo", (String)((String)this.adapter.get(0)));
    }

    public void testToArray1() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListener(){

            public void itemsAdded(ListChangeEvent event) {
            }
        });
        this.wrappedValueHolder.setValue((Object)"foo");
        Object[] array = this.adapter.toArray();
        PropertyListValueModelAdapterTests.assertEquals((Object)"foo", (Object)array[0]);
        PropertyListValueModelAdapterTests.assertEquals((int)1, (int)array.length);
    }

    public void testToArray2() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListener());
        Object[] array = this.adapter.toArray();
        PropertyListValueModelAdapterTests.assertEquals((int)0, (int)array.length);
    }

    public void testStaleValue() {
        TestListener listener = new TestListener(){

            public void itemsAdded(ListChangeEvent event) {
            }
        };
        this.adapter.addListChangeListener("list values", (ListChangeListener)listener);
        this.wrappedValueHolder.setValue((Object)"foo");
        List adapterList = CollectionTools.list((Iterator)this.adapter.iterator());
        PropertyListValueModelAdapterTests.assertEquals((int)1, (int)adapterList.size());
        PropertyListValueModelAdapterTests.assertEquals(this.wrappedList(), (Object)adapterList);
        PropertyListValueModelAdapterTests.assertEquals((String)"foo", (String)((String)adapterList.iterator().next()));
        this.adapter.removeListChangeListener("list values", (ListChangeListener)listener);
        adapterList = CollectionTools.list((Iterator)this.adapter.iterator());
        PropertyListValueModelAdapterTests.assertEquals((int)0, (int)adapterList.size());
        PropertyListValueModelAdapterTests.assertEquals(new ArrayList(), (Object)adapterList);
        this.adapter.addListChangeListener("list values", (ListChangeListener)listener);
        adapterList = CollectionTools.list((Iterator)this.adapter.iterator());
        PropertyListValueModelAdapterTests.assertEquals((int)1, (int)adapterList.size());
        PropertyListValueModelAdapterTests.assertEquals(this.wrappedList(), (Object)adapterList);
        PropertyListValueModelAdapterTests.assertEquals((String)"foo", (String)((String)adapterList.iterator().next()));
    }

    public void testHasListeners() {
        PropertyListValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyListChangeListeners("list values"));
        CoordinatedList<String> synchList = new CoordinatedList<String>(this.adapter);
        PropertyListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)this.adapter).hasAnyListChangeListeners("list values"));
        this.adapter.removeListChangeListener("list values", synchList);
        PropertyListValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyListChangeListeners("list values"));
        this.adapter.addListChangeListener(synchList);
        PropertyListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)this.adapter).hasAnyListChangeListeners("list values"));
        this.adapter.removeListChangeListener(synchList);
        PropertyListValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyListChangeListeners("list values"));
    }

    public void testListChangedToEmpty() {
        this.wrappedValueHolder.setValue((Object)"foo");
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListener(){

            public void itemsRemoved(ListChangeEvent event) {
            }
        });
        JList jList = new JList(new ListModelAdapter(this.adapter));
        this.wrappedValueHolder.setValue(null);
        PropertyListValueModelAdapterTests.assertEquals((int)0, (int)jList.getModel().getSize());
    }

    public void testListChangedFromEmpty() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListener(){

            public void itemsAdded(ListChangeEvent event) {
            }
        });
        JList jList = new JList(new ListModelAdapter(this.adapter));
        this.wrappedValueHolder.setValue((Object)"foo");
        PropertyListValueModelAdapterTests.assertEquals((int)1, (int)jList.getModel().getSize());
    }

    public void testListItemChanged() {
        this.wrappedValueHolder.setValue((Object)"foo");
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListener(){

            public void itemsReplaced(ListChangeEvent event) {
            }
        });
        JList jList = new JList(new ListModelAdapter(this.adapter));
        PropertyListValueModelAdapterTests.assertEquals((int)1, (int)jList.getModel().getSize());
        PropertyListValueModelAdapterTests.assertEquals((Object)"foo", jList.getModel().getElementAt(0));
        this.wrappedValueHolder.setValue((Object)"bar");
        PropertyListValueModelAdapterTests.assertEquals((int)1, (int)jList.getModel().getSize());
        PropertyListValueModelAdapterTests.assertEquals((Object)"bar", jList.getModel().getElementAt(0));
    }

    public void testListChangedFromEmptyToEmpty() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListener());
        JList jList = new JList(new ListModelAdapter(this.adapter));
        this.wrappedValueHolder.setValue(null);
        PropertyListValueModelAdapterTests.assertEquals((int)0, (int)jList.getModel().getSize());
    }

    static class TestListener
    implements ListChangeListener {
        TestListener() {
        }

        public void listChanged(ListChangeEvent event) {
            PropertyListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void listCleared(ListChangeEvent event) {
            PropertyListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsAdded(ListChangeEvent event) {
            PropertyListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsRemoved(ListChangeEvent event) {
            PropertyListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsMoved(ListChangeEvent event) {
            PropertyListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsReplaced(ListChangeEvent event) {
            PropertyListValueModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

