/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests.testcase;

import java.lang.reflect.InvocationTargetException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.tests.T1Group;
import org.eclipse.wst.validation.tests.testcase.TestEnvironment;
import org.osgi.framework.Bundle;

public class TestSuite2
extends TestCase {
    private TestEnvironment _env;
    private IProject _testProject;
    private IFile _firstTest1;
    private IFile _secondTest1;
    private IFile _firstT1B;
    private IFile _firstTest2x;
    private IFile _firstT1C;

    public static Test suite() {
        return new TestSuite(TestSuite2.class);
    }

    public TestSuite2(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._env = new TestEnvironment();
        this._testProject = this._env.findProject("TestProject");
        if (this._testProject != null) {
            return;
        }
        this._env.turnoffAutoBuild();
        TestSuite2.adjustEnabledValidators();
        this._testProject = this._env.createProject("TestProject");
        IPath folder = this._env.addFolder(this._testProject.getFullPath(), "source");
        this._firstTest1 = this._env.addFile(folder, "first.test1", "include map.test1\ninfo - information\nwarning - warning\nerror - error\n\nt1error - extra error\nt1warning - extra warning");
        this._secondTest1 = this._env.addFile(folder, "second.test1", "info - information\nwarning - warning\nerror - error\n\nt1error - extra error\nt1warning - extra warning");
        this._firstT1B = this._env.addFile(folder, "first.t1b", "include map.test1\ninfo - information\nwarning - warning\nerror - error\n\nt1error - extra error\nt1warning - extra warning");
        this._env.addFile(folder, "map.test1", "# will hold future mappings");
        this._env.addFile(folder, "first.test2", "# sample file");
        this._firstTest2x = this._env.addFile(folder, "first.test2x", "# a file that will be validated as a side effect of running the T1A validator");
        this._env.addFile(folder, "third.test4", "# Doesn't really matter\nWe just want to make the build a bit slower.");
        this._env.addFile(folder, "fourth.test4", "# Doesn't really matter");
        this._env.addFile(folder, "fifth.test5", "# Doesn't really matter");
        IPath ignore = this._env.addFolder(this._testProject.getFullPath(), "ignore");
        IPath nested = this._env.addFolder(ignore, "nested");
        this._firstT1C = this._env.addFile(nested, "first.t1c", "error - error");
    }

    private static void adjustEnabledValidators() throws InvocationTargetException {
        Validator[] vals;
        Validator[] validatorArray = vals = ValManager.getDefault().getValidatorsCopy();
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            boolean validateIt = v.getValidatorClassname().startsWith("org.eclipse.wst.validation.tests.T1");
            v.setBuildValidation(validateIt);
            v.setManualValidation(validateIt);
            ++n2;
        }
        ValPrefManagerGlobal gp = ValPrefManagerGlobal.getDefault();
        gp.saveAsPrefs(vals);
        TestEnvironment.saveV1Preferences(vals);
    }

    protected void tearDown() throws Exception {
        this._env.dispose();
        super.tearDown();
    }

    public void testFullBuild() throws CoreException, InterruptedException {
        ValidationFramework vf = ValidationFramework.getDefault();
        NullProgressMonitor monitor = new NullProgressMonitor();
        this._env.fullBuild2((IProgressMonitor)monitor);
        vf.join((IProgressMonitor)monitor);
        Thread.sleep(1000L);
        T1Group.getGroup().reset();
        this._env.turnOnAutoBuild();
        this._firstTest1.touch((IProgressMonitor)monitor);
        Thread.sleep(50L);
        this._secondTest1.touch((IProgressMonitor)monitor);
        vf.join((IProgressMonitor)monitor);
        Thread.sleep(1000L);
        this.checkClear();
        this.checkT1B();
        this.checkGuardValidators();
        this.checkT1C();
        this.checkGroup();
    }

    private void checkGroup() {
        T1Group group = T1Group.getGroup();
        TestSuite2.assertNotNull((String)"The validation group listener T1Group was never created", (Object)group);
        TestSuite2.assertEquals((String)"The starting count must equal the finishing count", (int)group.getStarting(), (int)group.getFinishing());
        TestSuite2.assertEquals((String)"Number of times the group should be signalled", (int)2, (int)group.getStarting());
    }

    private void checkT1B() throws CoreException {
        IMarker[] markers = this._firstT1B.findMarkers("org.eclipse.wst.common.tests.validation.t1bmarker", false, 0);
        TestSuite2.assertEquals((String)"Number of T1B markers", (int)3, (int)markers.length);
    }

    private void checkT1C() throws CoreException {
        IMarker[] markers = this._firstT1C.findMarkers(null, false, 0);
        TestSuite2.assertEquals((String)"Number of T1C markers", (int)0, (int)markers.length);
    }

    private void checkClear() throws CoreException {
        IMarker[] markers = this._firstTest2x.findMarkers("org.eclipse.wst.validation.problemmarker2", false, 0);
        TestSuite2.assertEquals((int)1, (int)markers.length);
    }

    private void checkGuardValidators() {
        int state;
        Bundle b = Platform.getBundle((String)"org.eclipse.wst.common.tests.validation.guard");
        if (b != null && (state = b.getState()) == 32) {
            TestSuite2.fail((String)"The guard plug-in should never be activated.");
        }
    }

    public static class Listener
    implements IResourceChangeListener {
        private IResource _interested;

        public Listener(IResource resource) {
            this._interested = resource;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IMarkerDelta[] markers;
            IMarkerDelta[] iMarkerDeltaArray = markers = event.findMarkerDeltas("org.eclipse.wst.validation.problemmarker2", false);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta marker = iMarkerDeltaArray[n2];
                IResource resource = marker.getResource();
                this._interested.equals((Object)resource);
                ++n2;
            }
        }
    }
}

