/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.tests.dom.ConverterTestSetup;

public class ASTPositionsTest
extends ConverterTestSetup {
    IJavaScriptUnit workingCopy;
    static /* synthetic */ Class class$0;

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.ast = AST.newAST((int)3);
    }

    public ASTPositionsTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTPositionsTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTPositionsTest.buildModelTestSuite(clazz);
    }

    private void sanityCheck(String contents, JavaScriptUnit compilationUnit) {
        int i = 0;
        int max = contents.length();
        while (i < max) {
            int lineNumber = compilationUnit.getLineNumber(i);
            ASTPositionsTest.assertTrue((String)("Wrong value for char at " + i), (lineNumber >= 1 ? 1 : 0) != 0);
            int columnNumber = compilationUnit.getColumnNumber(i);
            ASTPositionsTest.assertTrue((String)("Wrong value for char at " + i), (columnNumber >= 0 ? 1 : 0) != 0);
            int position = compilationUnit.getPosition(lineNumber, columnNumber);
            ASTPositionsTest.assertTrue((String)"Wrong value for char at i", (position >= 0 ? 1 : 0) != 0);
            if (position == 0) {
                ASTPositionsTest.assertEquals((String)"Only true for first character", (int)0, (int)i);
            }
            ASTPositionsTest.assertEquals((String)"Wrong char", (char)contents.charAt(i), (char)contents.charAt(position));
            ++i;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.workingCopy != null) {
            this.workingCopy.discardWorkingCopy();
            this.workingCopy = null;
        }
    }

    public void test001() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("import java.util.Map;\r\npublic class X {\r\n\tMap<String, Number> map= null;\r\n}", this.workingCopy, false);
        ASTPositionsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        ASTPositionsTest.assertEquals((String)"Wrong char", (char)'X', (char)"import java.util.Map;\r\npublic class X {\r\n\tMap<String, Number> map= null;\r\n}".charAt(compilationUnit.getPosition(2, 13)));
        ASTPositionsTest.assertEquals((String)"Wrong char", (char)'i', (char)"import java.util.Map;\r\npublic class X {\r\n\tMap<String, Number> map= null;\r\n}".charAt(compilationUnit.getPosition(1, 0)));
        ASTPositionsTest.assertEquals((String)"Wrong position", (int)-1, (int)compilationUnit.getPosition(1, -1));
        ASTPositionsTest.assertEquals((String)"Wrong position", (int)-1, (int)compilationUnit.getPosition(-1, 0));
        ASTPositionsTest.assertEquals((String)"Wrong position", (int)-1, (int)compilationUnit.getPosition(5, 0));
        ASTPositionsTest.assertEquals((String)"Wrong position", (int)-1, (int)compilationUnit.getPosition(4, 1));
        ASTPositionsTest.assertEquals((String)"Wrong char", (char)'}', (char)"import java.util.Map;\r\npublic class X {\r\n\tMap<String, Number> map= null;\r\n}".charAt(compilationUnit.getPosition(4, 0)));
        ASTPositionsTest.assertEquals((String)"Wrong char", (char)'\r', (char)"import java.util.Map;\r\npublic class X {\r\n\tMap<String, Number> map= null;\r\n}".charAt(compilationUnit.getPosition(1, 21)));
        this.sanityCheck("import java.util.Map;\r\npublic class X {\r\n\tMap<String, Number> map= null;\r\n}", compilationUnit);
    }

    public void test002() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("import java.util.Map;\npublic class X {\n\tMap<String, Number> map= null;\n}\n", this.workingCopy, false);
        ASTPositionsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.sanityCheck("import java.util.Map;\npublic class X {\n\tMap<String, Number> map= null;\n}\n", compilationUnit);
    }

    public void test003() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        ASTNode node = this.buildAST("import java.util.Map;\rpublic class X {\r\tMap<String, Number> map= null;\r}\r", this.workingCopy, false);
        ASTPositionsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.sanityCheck("import java.util.Map;\rpublic class X {\r\tMap<String, Number> map= null;\r}\r", compilationUnit);
    }

    public void test004() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "package pack1;\npublic class X {}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTPositionsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.sanityCheck(contents, compilationUnit);
        ASTPositionsTest.assertEquals((int)1, (int)compilationUnit.getLineNumber(0));
    }

    public void test005() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter15/src/X.js", true);
        String contents = "package pack1;public class X {}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTPositionsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        ASTPositionsTest.assertEquals((int)1, (int)compilationUnit.getLineNumber(0));
        this.sanityCheck(contents, compilationUnit);
    }
}

