/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class WorkingCopyNotInClasspathTests
extends ModifyingResourceTests {
    private IJavaScriptUnit workingCopy;
    static /* synthetic */ Class class$0;

    public WorkingCopyNotInClasspathTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.WorkingCopyNotInClasspathTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return WorkingCopyNotInClasspathTests.buildModelTestSuite(clazz);
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            this.createFolder("P/txt");
            IFile file = this.createFile("P/txt/X.js", "public class X {\n}");
            IJavaScriptUnit cu = (IJavaScriptUnit)JavaScriptCore.create((IFile)file);
            this.workingCopy = cu.getWorkingCopy(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void tearDown() throws Exception {
        try {
            if (this.workingCopy != null) {
                this.workingCopy.discardWorkingCopy();
                this.workingCopy = null;
            }
            this.deleteProject("P");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        super.tearDown();
    }

    public void testCommitWorkingCopy1() throws CoreException {
        IJavaScriptUnit primary = this.workingCopy.getPrimary();
        WorkingCopyNotInClasspathTests.assertTrue((String)"Primary element should not be null", (primary != null ? 1 : 0) != 0);
        IBuffer workingCopyBuffer = this.workingCopy.getBuffer();
        WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
        String newContents = "public class X {\n  public void foo() {\n  }\n}";
        workingCopyBuffer.setContents(newContents);
        this.workingCopy.commitWorkingCopy(false, null);
        IFile originalFile = (IFile)primary.getResource();
        this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCommitWorkingCopy2() throws CoreException {
        block4: {
            IJavaScriptUnit copy = null;
            try {
                this.createJavaProject("P2", new String[]{"src"}, null, null, null, "bin", null, null, new String[][]{{"p1/"}}, "1.4");
                this.createFolder("/P2/src/p1/p2");
                this.createFile("/P2/src/p1/p2/X.js", "");
                copy = this.getCompilationUnit("P2", "src", "p1.p2", "X.js").getWorkingCopy(null);
                copy.getBuffer().setContents("public class X {}");
                copy.makeConsistent(null);
                copy.commitWorkingCopy(false, null);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (copy != null) {
                    copy.discardWorkingCopy();
                }
                this.deleteProject("P2");
                throw throwable;
            }
            {
                Object var2_4 = null;
                if (copy == null) break block4;
            }
            copy.discardWorkingCopy();
        }
        this.deleteProject("P2");
    }

    public void testExistence() {
        WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy should exist", (boolean)this.workingCopy.exists());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetSource() throws CoreException {
        block4: {
            IJavaScriptUnit copy = null;
            try {
                this.createJavaProject("P1", new String[0], "bin");
                this.createFolder("/P1/src/junit/test");
                String source = "package junit.test;\npublic class X {\n}";
                IFile file = this.createFile("/P1/src/junit/test/X.js", source);
                IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                copy = cu.getWorkingCopy(null);
                WorkingCopyNotInClasspathTests.assertEquals((String)"Unexpected source", (String)source, (String)copy.getSource());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (copy != null) {
                    copy.discardWorkingCopy();
                }
                this.deleteProject("P1");
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (copy == null) break block4;
            }
            copy.discardWorkingCopy();
        }
        this.deleteProject("P1");
    }

    public void testParentExistence() {
        WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy's parent should not exist", (!this.workingCopy.getParent().exists() ? 1 : 0) != 0);
    }

    /*
     * Exception decompiling
     */
    public void testReconcileNonExistingProject() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 75->79)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReconcileSimpleProject() throws CoreException {
        block4: {
            IJavaScriptUnit wc = null;
            try {
                IProject project = this.createProject("SimpleProject");
                IFile file = project.getFile("A.js");
                wc = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                AbstractJavaModelTests.ProblemRequestor pbRequestor = new AbstractJavaModelTests.ProblemRequestor();
                wc.becomeWorkingCopy((IProblemRequestor)pbRequestor, null);
                wc.getBuffer().setContents("public class A {}");
                wc.reconcile(0, true, null, null);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (wc != null) {
                    wc.discardWorkingCopy();
                }
                this.deleteProject("SimpleProject");
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (wc == null) break block4;
            }
            wc.discardWorkingCopy();
        }
        this.deleteProject("SimpleProject");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReconcileSimpleProject2() throws CoreException {
        block4: {
            IJavaScriptUnit wc = null;
            try {
                IProject project = this.createProject("SimpleProject");
                IFile file = project.getFile("A.js");
                wc = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                AbstractJavaModelTests.ProblemRequestor pbRequestor = new AbstractJavaModelTests.ProblemRequestor();
                wc.becomeWorkingCopy((IProblemRequestor)pbRequestor, null);
                wc.reconcile(0, true, null, null);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (wc != null) {
                    wc.discardWorkingCopy();
                }
                this.deleteProject("SimpleProject");
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (wc == null) break block4;
            }
            wc.discardWorkingCopy();
        }
        this.deleteProject("SimpleProject");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSimpleProject() throws CoreException {
        block6: {
            IJavaScriptUnit copy = null;
            try {
                this.createProject("SimpleProject");
                IFile file = this.createFile("/SimpleProject/X.js", "public class X {\n}");
                IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                copy = cu.getWorkingCopy(null);
                try {
                    copy.getChildren();
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    WorkingCopyNotInClasspathTests.assertTrue((String)"Should not get JavaScriptModelException", (boolean)false);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (copy != null) {
                    ((IJavaScriptUnit)copy).discardWorkingCopy();
                }
                this.deleteProject("SimpleProject");
                throw throwable;
            }
            {
                Object var4_6 = null;
                if (copy == null) break block6;
            }
            copy.discardWorkingCopy();
        }
        this.deleteProject("SimpleProject");
    }

    public void testPrimaryExistence() {
        IJavaScriptUnit primary = this.workingCopy.getPrimary();
        WorkingCopyNotInClasspathTests.assertTrue((String)"Primary compilation unit should not exist", (!primary.exists() ? 1 : 0) != 0);
    }

    public void testPrimaryParentExistence() {
        WorkingCopyNotInClasspathTests.assertTrue((String)"Primary compilation unit's parent should not exist", (!this.workingCopy.getPrimary().getParent().exists() ? 1 : 0) != 0);
    }

    public void testIsOpen() {
        WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy should be open", (boolean)this.workingCopy.isOpen());
    }

    public void testPrimaryIsOpen() {
        IJavaScriptUnit original = this.workingCopy.getPrimary();
        WorkingCopyNotInClasspathTests.assertTrue((String)"Primary compilation should not be opened", (!original.isOpen() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testIsOnClasspath() throws CoreException {
        block4: {
            IJavaScriptUnit copy = null;
            try {
                this.createProject("SimpleProject");
                this.createFolder("/SimpleProject/src/junit/test");
                String source = "package junit.test;\npublic class X {\n}";
                IFile file = this.createFile("/SimpleProject/src/junit/test/X.js", source);
                IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                copy = cu.getWorkingCopy(null);
                boolean isOnClasspath = copy.getJavaScriptProject().isOnIncludepath((IJavaScriptElement)copy);
                WorkingCopyNotInClasspathTests.assertTrue((String)"working copy shouldn't answer to isOnClasspath", (!isOnClasspath ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (copy != null) {
                    copy.discardWorkingCopy();
                }
                this.deleteProject("SimpleProject");
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (copy == null) break block4;
            }
            copy.discardWorkingCopy();
        }
        this.deleteProject("SimpleProject");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReconcileAndCommit1() throws CoreException {
        block6: {
            IJavaScriptUnit copy = null;
            try {
                try {
                    this.createJavaProject("JavaProject", new String[]{"src"}, "bin");
                    this.createFolder("/JavaProject/src/native.1");
                    String source = "class X {}";
                    IFile file = this.createFile("/JavaProject/src/native.1/X.js", source);
                    IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                    copy = cu.getWorkingCopy(null);
                    IBuffer workingCopyBuffer = copy.getBuffer();
                    WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
                    String newContents = "public class X {\n  public void foo() {\n  }\n}";
                    workingCopyBuffer.setContents(newContents);
                    copy.reconcile(0, true, null, null);
                    copy.commitWorkingCopy(true, null);
                    IFile originalFile = (IFile)cu.getResource();
                    this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
                }
                catch (JavaScriptModelException e) {
                    e.printStackTrace();
                    WorkingCopyNotInClasspathTests.assertTrue((String)("No exception should have occurred: " + e.getMessage()), (boolean)false);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (copy != null) {
                    copy.discardWorkingCopy();
                }
                this.deleteProject("JavaProject");
                throw throwable;
            }
            {
                Object var8_11 = null;
                if (copy == null) break block6;
            }
            copy.discardWorkingCopy();
        }
        this.deleteProject("JavaProject");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReconcileAndCommit2() throws CoreException {
        block6: {
            IJavaScriptUnit copy = null;
            try {
                try {
                    this.createProject("SimpleProject");
                    this.createFolder("/SimpleProject/src/native.1");
                    String source = "class X {}";
                    IFile file = this.createFile("/SimpleProject/src/native.1/X.js", source);
                    IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                    copy = cu.getWorkingCopy(null);
                    IBuffer workingCopyBuffer = copy.getBuffer();
                    WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
                    String newContents = "public class X {\n  public void foo() {\n  }\n}";
                    workingCopyBuffer.setContents(newContents);
                    copy.reconcile(0, true, null, null);
                    copy.commitWorkingCopy(true, null);
                    IFile originalFile = (IFile)cu.getResource();
                    this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
                    WorkingCopyNotInClasspathTests.assertTrue((String)"buffer should not have been saved successfully", (boolean)workingCopyBuffer.hasUnsavedChanges());
                }
                catch (JavaScriptModelException e) {
                    e.printStackTrace();
                    WorkingCopyNotInClasspathTests.assertTrue((String)("No exception should have occurred: " + e.getMessage()), (boolean)false);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (copy != null) {
                    copy.discardWorkingCopy();
                }
                this.deleteProject("SimpleProject");
                throw throwable;
            }
            {
                Object var8_11 = null;
                if (copy == null) break block6;
            }
            copy.discardWorkingCopy();
        }
        this.deleteProject("SimpleProject");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReconcileAndCommit3() throws CoreException {
        block6: {
            IJavaScriptUnit primary = null;
            try {
                try {
                    this.createProject("SimpleProject");
                    this.createFolder("/SimpleProject/src/native.1");
                    String source = "class X {}";
                    IFile file = this.createFile("/SimpleProject/src/native.1/X.js", source);
                    primary = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                    primary.becomeWorkingCopy(null, null);
                    IBuffer workingCopyBuffer = primary.getBuffer();
                    WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
                    String newContents = "public class X {\n  public void foo() {\n  }\n}";
                    workingCopyBuffer.setContents(newContents);
                    primary.reconcile(0, true, null, null);
                    primary.commitWorkingCopy(true, null);
                    IFile originalFile = (IFile)primary.getResource();
                    this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
                    WorkingCopyNotInClasspathTests.assertTrue((String)"buffer should have been saved successfully", (!workingCopyBuffer.hasUnsavedChanges() ? 1 : 0) != 0);
                }
                catch (JavaScriptModelException e) {
                    e.printStackTrace();
                    WorkingCopyNotInClasspathTests.assertTrue((String)("No exception should have occurred: " + e.getMessage()), (boolean)false);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (primary != null) {
                    primary.discardWorkingCopy();
                }
                this.deleteProject("SimpleProject");
                throw throwable;
            }
            {
                Object var7_10 = null;
                if (primary == null) break block6;
            }
            primary.discardWorkingCopy();
        }
        this.deleteProject("SimpleProject");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReconcileAndCommit4() throws CoreException {
        block6: {
            IJavaScriptUnit primary = null;
            try {
                try {
                    this.createProject("SimpleProject");
                    this.createFolder("/SimpleProject/src/native.1");
                    String source = "class X {}";
                    IFile file = this.createFile("/SimpleProject/src/native.1/some invalid name.js", source);
                    primary = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                    primary.becomeWorkingCopy(null, null);
                    IBuffer workingCopyBuffer = primary.getBuffer();
                    WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
                    String newContents = "public class X {\n  public void foo() {\n  }\n}";
                    workingCopyBuffer.setContents(newContents);
                    primary.reconcile(0, true, null, null);
                    primary.commitWorkingCopy(true, null);
                    IFile originalFile = (IFile)primary.getResource();
                    this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
                    WorkingCopyNotInClasspathTests.assertTrue((String)"buffer should have been saved successfully", (!workingCopyBuffer.hasUnsavedChanges() ? 1 : 0) != 0);
                }
                catch (JavaScriptModelException e) {
                    e.printStackTrace();
                    WorkingCopyNotInClasspathTests.assertTrue((String)("No exception should have occurred: " + e.getMessage()), (boolean)false);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (primary != null) {
                    primary.discardWorkingCopy();
                }
                this.deleteProject("SimpleProject");
                throw throwable;
            }
            {
                Object var7_10 = null;
                if (primary == null) break block6;
            }
            primary.discardWorkingCopy();
        }
        this.deleteProject("SimpleProject");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReconcileAndCommit5() throws CoreException {
        block6: {
            IJavaScriptUnit copy = null;
            try {
                try {
                    this.createJavaProject("JavaProject", new String[]{"src"}, "bin");
                    this.createFolder("/JavaProject/src/p");
                    String source = "package p; \npublic class X {}";
                    IFile file = this.createFile("/JavaProject/src/invalid unit name.js", source);
                    IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                    copy = cu.getWorkingCopy(null);
                    IBuffer workingCopyBuffer = copy.getBuffer();
                    WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
                    String newContents = "public class X {\n  public void foo() {\n  }\n}";
                    workingCopyBuffer.setContents(newContents);
                    copy.reconcile(0, true, null, null);
                    copy.commitWorkingCopy(true, null);
                    IFile originalFile = (IFile)cu.getResource();
                    this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
                }
                catch (JavaScriptModelException e) {
                    e.printStackTrace();
                    WorkingCopyNotInClasspathTests.assertTrue((String)("No exception should have occurred: " + e.getMessage()), (boolean)false);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (copy != null) {
                    copy.discardWorkingCopy();
                }
                this.deleteProject("JavaProject");
                throw throwable;
            }
            {
                Object var8_11 = null;
                if (copy == null) break block6;
            }
            copy.discardWorkingCopy();
        }
        this.deleteProject("JavaProject");
    }
}

