/*******************************************************************************
 * Copyright (c) 2007 Chase Technology Ltd - http://www.chasetechnology.co.uk
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Doug Satchwell (Chase Technology Ltd) - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.xsl.core.internal.model;

import java.util.ArrayList;
import java.util.List;

/**
 * The <code>xsl:call-template</code> model element.
 * 
 * @author Doug Satchwell
 */
public class CallTemplate extends XSLElement
{
	final List<Parameter> parameters = new ArrayList<Parameter>();
	
	/**
	 * Create a new instance of this.
	 * 
	 * @param stylesheet the stylesheet that this belongs to
	 */
	public CallTemplate(Stylesheet stylesheet)
	{
		super(stylesheet);
	}
	
	/**
	 * Add a parameter to this.
	 * 
	 * @param parameter the parameter to add
	 */
	public void addParameter(Parameter parameter)
	{
		parameters.add(parameter);
	}

	/**
	 * Get the value of the <code>name</code> attribute if one exists.
	 * 
	 * @return the template name, or null
	 */
	public String getName()
	{
		return getAttributeValue("name"); //$NON-NLS-1$
	}
	
	/**
	 * Get the list of parameters associated with this.
	 * 
	 * @return a list of parameters
	 */
	public List<Parameter> getParameters()
	{
		return parameters;
	}
}
