/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.validation.eclipse;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.internal.XSLCorePlugin;
import org.eclipse.wst.xsl.core.internal.model.StylesheetModel;
import org.eclipse.wst.xsl.core.internal.validation.XSLValidationMessage;
import org.eclipse.wst.xsl.core.internal.validation.XSLValidator;

public class Validator2
extends AbstractValidator
implements IValidatorJob {
    public void clean(IProject project, ValidationState state, IProgressMonitor monitor) {
        XSLCore.getInstance().clean(project, monitor);
        super.clean(project, state, monitor);
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult result = new ValidationResult();
        if (resource.getType() == 1) {
            IFile file = (IFile)resource;
            ValidationReport report = this.doValidation(file, kind, state, monitor);
            StylesheetModel stylesheet = XSLCore.getInstance().getStylesheet(file);
            IFile[] dependencies = stylesheet.getFileDependencies().toArray(new IFile[0]);
            result.setDependsOn((IResource[])dependencies);
            ValidationMessage[] validationMessageArray = report.getValidationMessages();
            int n = validationMessageArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValidationMessage message = validationMessageArray[n2];
                XSLValidationMessage xslMsg = (XSLValidationMessage)message;
                ValidatorMessage msg = ValidatorMessage.create((String)message.getMessage(), (IResource)resource);
                msg.setAttribute("lineNumber", xslMsg.getLineNumber());
                msg.setAttribute("severity", xslMsg.getSeverity());
                result.add(msg);
                ++n2;
            }
        }
        return result;
    }

    private ValidationReport doValidation(IFile file, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationReport valreport = null;
        try {
            valreport = XSLValidator.getInstance().validate(file, true);
        }
        catch (CoreException e) {
            XSLCorePlugin.log(e);
        }
        return valreport;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        return null;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }
}

