/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class XSLConsoleLineTracker
implements IConsoleLineTracker {
    private IConsole console;
    private boolean enabled;

    public void dispose() {
        this.console = null;
    }

    public void init(IConsole console) {
        this.console = console;
        this.enabled = false;
        try {
            String launchTypeId = console.getProcess().getLaunch().getLaunchConfiguration().getType().getIdentifier();
            this.enabled = "org.eclipse.wst.xsl.launching.launchConfigurationType".equals(launchTypeId);
        }
        catch (CoreException coreException) {}
    }

    public void lineAppended(IRegion line) {
        if (!this.enabled) {
            return;
        }
        int lineOffset = line.getOffset();
        int lineLength = line.getLength();
        try {
            String text = this.console.getDocument().get(lineOffset, lineLength);
            int i = text.indexOf("file:/");
            if (i != -1 || (i = text.indexOf("http://")) != -1 || (i = text.indexOf("https://")) != -1 || (i = text.indexOf("ftp://")) != -1) {
                int v = i + 9;
                StringBuffer sb = new StringBuffer(text.substring(i, v));
                while (v < text.length()) {
                    char c = text.charAt(v);
                    if (c == ' ' || c == ':' || c == ';' || c == '{' || c == '}' || c == '[' || c == ']' || c == '(' || c == ')') break;
                    sb.append(c);
                    ++v;
                }
                ExternalFileConsoleHyperLink link = new ExternalFileConsoleHyperLink(sb.toString(), -1);
                this.console.addLink((IHyperlink)link, lineOffset + i, v - i);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private static class ExternalFileConsoleHyperLink
    implements IHyperlink {
        private final int fLineNumber;
        private final String uri;

        public ExternalFileConsoleHyperLink(String uri, int lineNumber) {
            this.fLineNumber = lineNumber;
            this.uri = uri;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            URL url = null;
            try {
                url = new URL(this.uri);
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
            if ("file".equals(url.getProtocol())) {
                String path = URLDecoder.decode(url.getPath());
                Path fExternalPath = new Path(path);
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)fExternalPath);
                if (files.length > 0) {
                    int i = 0;
                    while (i < files.length) {
                        block11: {
                            IFile curr = files[0];
                            try {
                                IEditorPart part = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)curr);
                                if (part == null || this.fLineNumber == -1) break block11;
                                if (part instanceof ITextEditor) {
                                    try {
                                        this.revealLine((ITextEditor)part, this.fLineNumber);
                                    }
                                    catch (BadLocationException badLocationException) {}
                                }
                                return;
                            }
                            catch (PartInitException partInitException) {}
                        }
                        ++i;
                    }
                }
            } else {
                Program.launch((String)url.toExternalForm());
            }
        }

        private void revealLine(ITextEditor editor, int lineNumber) throws BadLocationException {
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            IRegion region = document.getLineInformation(lineNumber - 1);
            editor.selectAndReveal(region.getOffset(), 0);
        }
    }
}

