/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.output;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsl.internal.debug.ui.AbstractTableBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.OutputPreferencePage;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.XSLMainTab;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.output.Messages;
import org.eclipse.wst.xsl.launching.IOutputProperty;
import org.eclipse.wst.xsl.launching.IProcessorInstall;
import org.eclipse.wst.xsl.launching.IProcessorType;
import org.eclipse.wst.xsl.launching.XSLTRuntime;
import org.eclipse.wst.xsl.launching.config.LaunchProperties;

public class OutputPropertiesBlock
extends AbstractTableBlock {
    private Table table;
    private TableViewer tViewer;
    private Text descriptionText;
    private IProcessorType processorType;
    private final Map<IProcessorType, LaunchProperties> typeProperties = new HashMap<IProcessorType, LaunchProperties>();
    private Button usePropertiesFromPreferencesRadio;
    private Button changePreferences;
    private Button useSpecificPropertiesRadio;
    private LaunchProperties launchProperties;

    public OutputPropertiesBlock(XSLMainTab main) {
    }

    protected IDialogSettings getDialogSettings() {
        return XSLDebugUIPlugin.getDefault().getDialogSettings();
    }

    protected String getQualifier() {
        return "org.eclipse.wst.xsl.debug.ui.OUTPUT_BLOCK";
    }

    protected Table getTable() {
        return this.table;
    }

    public void createControl(Composite parent) {
        this.usePropertiesFromPreferencesRadio = new Button(parent, 16);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        this.usePropertiesFromPreferencesRadio.setLayoutData((Object)gd);
        this.usePropertiesFromPreferencesRadio.setText(Messages.OutputPropertiesBlock_0);
        this.usePropertiesFromPreferencesRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OutputPropertiesBlock.this.handleUsePropertiesFromPreferences(true);
                OutputPropertiesBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.changePreferences = new Button(parent, 8);
        this.changePreferences.setText(Messages.OutputPropertiesBlock_1);
        gd = new GridData(131072, 0x1000000, false, false);
        this.changePreferences.setLayoutData((Object)gd);
        this.changePreferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPreferencePage page = new OutputPreferencePage();
                XSLDebugUIPlugin.showPreferencePage("org.eclipse.wst.xsl.debug.ui.output", (IPreferencePage)page);
                OutputPropertiesBlock.this.handleUsePropertiesFromPreferences(true);
            }
        });
        this.useSpecificPropertiesRadio = new Button(parent, 16);
        gd = new GridData(16384, 0x1000000, false, false);
        this.useSpecificPropertiesRadio.setLayoutData((Object)gd);
        this.useSpecificPropertiesRadio.setText(Messages.OutputPropertiesBlock_3);
        this.useSpecificPropertiesRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OutputPropertiesBlock.this.handleUsePropertiesFromPreferences(false);
                OutputPropertiesBlock.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(parent, 0);
        this.table = new Table(parent, 68096);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.table.setLayoutData((Object)gd);
        this.setControl((Control)this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn c1 = new TableColumn(this.table, 0);
        c1.setWidth(150);
        c1.setResizable(true);
        c1.setText(Messages.OutputPropertiesBlock_4);
        TableColumn c2 = new TableColumn(this.table, 0);
        c2.setWidth(250);
        c2.setResizable(true);
        c2.setText(Messages.OutputPropertiesBlock_5);
        this.tViewer = new TableViewer(this.table);
        this.tViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return OutputPropertiesBlock.this.launchProperties.getProperties().keySet().toArray(new String[0]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String prop = (String)element;
                switch (columnIndex) {
                    case 0: {
                        return prop;
                    }
                    case 1: {
                        return OutputPropertiesBlock.this.launchProperties.getProperty(prop);
                    }
                }
                return "!!";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tViewer.setColumnProperties(new String[]{Messages.OutputPropertiesBlock_7, Messages.OutputPropertiesBlock_8});
        this.tViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return Messages.OutputPropertiesBlock_9.equals(property);
            }

            public Object getValue(Object element, String property) {
                String prop = (String)element;
                String value = OutputPropertiesBlock.this.launchProperties.getProperty(prop);
                return value == null ? "" : value;
            }

            public void modify(Object element, String property, Object value) {
                Item item = (Item)element;
                String prop = (String)item.getData();
                if (value == null || "".equals(value)) {
                    OutputPropertiesBlock.this.launchProperties.removeProperty(prop);
                } else {
                    OutputPropertiesBlock.this.launchProperties.setProperty(prop, (String)value);
                }
                OutputPropertiesBlock.this.tViewer.update((Object)prop, null);
                OutputPropertiesBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.tViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String prop1 = (String)e1;
                String prop2 = (String)e2;
                return prop1.compareTo(prop2);
            }
        });
        this.tViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                String prop = (String)selection.getFirstElement();
                String text = null;
                if (prop != null) {
                    IProcessorType[] types = XSLTRuntime.getProcessorTypes();
                    int i = 0;
                    block0: while (i < types.length) {
                        IProcessorType processorType = types[i];
                        IOutputProperty[] property = processorType.getOutputProperties();
                        int j = 0;
                        while (j < property.length) {
                            IOutputProperty outputProperty = property[j];
                            if (outputProperty.getURI().equals(prop)) {
                                text = outputProperty.getDescription();
                                break block0;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                OutputPropertiesBlock.this.descriptionText.setText(text == null ? "" : text);
            }
        });
        TextCellEditor editor = new TextCellEditor((Composite)this.table);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = editor;
        CellEditor[] editors = cellEditorArray;
        this.tViewer.setCellEditors(editors);
        this.descriptionText = new Text(parent, 2632);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 3;
        gd.heightHint = 50;
        this.descriptionText.setLayoutData((Object)gd);
        this.restoreColumnSettings();
    }

    private void handleUsePropertiesFromPreferences(boolean selected) {
        this.changePreferences.setEnabled(selected);
        this.table.setEnabled(!selected);
        if (selected) {
            this.launchProperties = this.initializeFeaturesFromPreferences();
        } else {
            this.launchProperties = this.typeProperties.get(this.processorType);
            if (this.launchProperties == null) {
                this.launchProperties = new LaunchProperties();
                this.typeProperties.put(this.processorType, this.launchProperties);
                int i = 0;
                while (i < this.processorType.getOutputProperties().length) {
                    IOutputProperty property = this.processorType.getOutputProperties()[i];
                    this.launchProperties.setProperty(property.getURI(), null);
                    ++i;
                }
            }
        }
        this.tViewer.setInput((Object)this.launchProperties);
    }

    public String getName() {
        return Messages.OutputPropertiesBlock_13;
    }

    private LaunchProperties initializeFeaturesFromPreferences() {
        String key;
        IOutputProperty feature;
        LaunchProperties preferences = new LaunchProperties();
        IProcessorType jreDefaultType = XSLTRuntime.getProcessorType((String)"org.eclipse.wst.xsl.launching.processorType.jreDefault");
        IOutputProperty[] features = jreDefaultType.getOutputProperties();
        Properties values = jreDefaultType.getOutputPropertyValues();
        IOutputProperty[] iOutputPropertyArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            feature = iOutputPropertyArray[n2];
            key = feature.getURI();
            preferences.setProperty(key, (String)values.get(key));
            ++n2;
        }
        features = this.processorType.getOutputProperties();
        values = this.processorType.getOutputPropertyValues();
        iOutputPropertyArray = features;
        n = features.length;
        n2 = 0;
        while (n2 < n) {
            feature = iOutputPropertyArray[n2];
            key = feature.getURI();
            preferences.setProperty(key, (String)values.get(key));
            ++n2;
        }
        return preferences;
    }

    private void initializeFeaturesFromStorage(ILaunchConfiguration configuration) throws CoreException {
        IOutputProperty[] specificProps;
        Object key;
        IOutputProperty[] defaultProps;
        LaunchProperties launchFeatures = new LaunchProperties();
        IProcessorType jreDefaultType = XSLTRuntime.getProcessorType((String)"org.eclipse.wst.xsl.launching.processorType.jreDefault");
        IOutputProperty[] iOutputPropertyArray = defaultProps = jreDefaultType.getOutputProperties();
        int n = defaultProps.length;
        int n2 = 0;
        while (n2 < n) {
            IOutputProperty feature = iOutputPropertyArray[n2];
            key = feature.getURI();
            launchFeatures.setProperty((String)key, null);
            ++n2;
        }
        key = specificProps = this.processorType.getOutputProperties();
        int n3 = specificProps.length;
        n = 0;
        while (n < n3) {
            IOutputProperty feature = key[n];
            String key2 = feature.getURI();
            launchFeatures.setProperty(key2, null);
            ++n;
        }
        String s = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_PROPERTIES", null);
        if (s != null && s.length() > 0) {
            LaunchProperties overrideFeatures = LaunchProperties.fromXML((InputStream)new ByteArrayInputStream(s.getBytes()));
            IOutputProperty[] props = new IOutputProperty[specificProps.length + defaultProps.length];
            System.arraycopy(specificProps, 0, props, 0, specificProps.length);
            System.arraycopy(defaultProps, 0, props, specificProps.length, defaultProps.length);
            block2: for (String key2 : overrideFeatures.getProperties().keySet()) {
                launchFeatures.removeProperty(key2);
                IOutputProperty[] iOutputPropertyArray2 = props;
                int n4 = props.length;
                int n5 = 0;
                while (n5 < n4) {
                    IOutputProperty prop = iOutputPropertyArray2[n5];
                    if (prop.getURI().equals(key2)) {
                        launchFeatures.setProperty(key2, overrideFeatures.getProperty(key2));
                        continue block2;
                    }
                    ++n5;
                }
            }
        }
        this.typeProperties.put(this.processorType, launchFeatures);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String processorId = null;
            boolean useDefaultProcessor = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_PROCESSOR", true);
            processorId = useDefaultProcessor ? XSLTRuntime.getDefaultProcessor().getId() : configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_PROCESSOR", "org.eclipse.wst.xsl.launching.jre.default");
            IProcessorInstall processor = XSLTRuntime.getProcessor((String)processorId);
            this.processorType = processor != null ? processor.getProcessorType() : XSLTRuntime.getDefaultProcessor().getProcessorType();
            this.initializeFeaturesFromStorage(configuration);
            boolean useFeaturesFromPreferences = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_PROPERTIES_FROM_PREFERENCES", true);
            this.useSpecificPropertiesRadio.setSelection(!useFeaturesFromPreferences);
            this.usePropertiesFromPreferencesRadio.setSelection(useFeaturesFromPreferences);
            this.handleUsePropertiesFromPreferences(useFeaturesFromPreferences);
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_PROPERTIES_FROM_PREFERENCES", this.usePropertiesFromPreferencesRadio.getSelection());
        try {
            String xml = this.launchProperties.toXML();
            configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_PROPERTIES", xml);
        }
        catch (Exception e) {
            XSLDebugUIPlugin.log(e);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_PROPERTIES_FROM_PREFERENCES", true);
    }
}

