/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.launching;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xsl.internal.launching.PreferenceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OutputPropertyPreferences {
    private final Map<String, Properties> typeProperties = new HashMap<String, Properties>();

    public Properties getOutputPropertyValues(String typeId) {
        return this.typeProperties.get(typeId);
    }

    public void setOutputPropertyValues(String typeId, Properties properties) {
        this.typeProperties.put(typeId, properties);
    }

    public String getAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = PreferenceUtil.getDocument();
        Element config = doc.createElement("outputPropertyPreferences");
        doc.appendChild(config);
        for (String type : this.typeProperties.keySet()) {
            Element processorTypeElement = OutputPropertyPreferences.typeAsElement(doc, type);
            Properties propertyValues = this.typeProperties.get(type);
            OutputPropertyPreferences.featureValuesAsElement(doc, processorTypeElement, propertyValues);
            config.appendChild(processorTypeElement);
        }
        return PreferenceUtil.serializeDocument(doc);
    }

    public static OutputPropertyPreferences fromXML(InputStream inputStream) throws CoreException {
        OutputPropertyPreferences prefs = new OutputPropertyPreferences();
        Document doc = PreferenceUtil.getDocument(inputStream);
        Element config = doc.getDocumentElement();
        Element[] processorTypeEls = PreferenceUtil.getChildElements(config, "processorType");
        int i = 0;
        while (i < processorTypeEls.length) {
            Element processorTypeEl = processorTypeEls[i];
            String type = OutputPropertyPreferences.elementAsType(processorTypeEl);
            Properties featureValues = OutputPropertyPreferences.elementAsPropertyValues(processorTypeEl);
            prefs.setOutputPropertyValues(type, featureValues);
            ++i;
        }
        return prefs;
    }

    private static String elementAsType(Element parent) {
        String id = parent.getAttribute("id");
        return id;
    }

    private static Element typeAsElement(Document doc, String type) {
        Element element = doc.createElement("processorType");
        element.setAttribute("id", type);
        return element;
    }

    private static Properties elementAsPropertyValues(Element element) {
        Element[] propertyEls = PreferenceUtil.getChildElements(element, "property");
        Properties propertyValues = new Properties();
        Element[] elementArray = propertyEls;
        int n = propertyEls.length;
        int n2 = 0;
        while (n2 < n) {
            Element featureEl = elementArray[n2];
            String name = featureEl.getAttribute("name");
            String value = featureEl.getAttribute("value");
            propertyValues.put(name, value);
            ++n2;
        }
        return propertyValues;
    }

    private static void featureValuesAsElement(Document doc, Element featuresEl, Properties propertyValues) {
        if (propertyValues != null) {
            for (Map.Entry<Object, Object> entry2 : propertyValues.entrySet()) {
                String name = (String)entry2.getKey();
                String value = (String)entry2.getValue();
                Element element = doc.createElement("property");
                element.setAttribute("name", name);
                element.setAttribute("value", value);
                featuresEl.appendChild(element);
            }
        }
    }
}

