/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.launching;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xsl.internal.launching.LaunchingPlugin;
import org.eclipse.wst.xsl.internal.launching.Messages;
import org.eclipse.wst.xsl.launching.IProcessorJar;
import org.osgi.framework.Bundle;

public class PluginProcessorJar
implements IProcessorJar {
    private final String pluginId;
    private final IPath path;

    public PluginProcessorJar(String pluginId, IPath path) {
        this.pluginId = pluginId;
        this.path = path;
    }

    public URL asURL() {
        URL url = null;
        try {
            if (this.path == null) {
                url = Platform.getBundle((String)this.pluginId).getEntry("/");
                String s = (url = FileLocator.resolve((URL)url)).getPath();
                if (s.endsWith("!/")) {
                    s = s.substring(0, s.length() - 2);
                }
                url = new URL(s);
            } else {
                Path jarPath;
                Bundle bundle = Platform.getBundle((String)this.pluginId);
                url = FileLocator.find((Bundle)bundle, (IPath)(jarPath = new Path("/" + this.path)), null);
                if (url != null) {
                    url = FileLocator.resolve((URL)url);
                }
            }
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
        }
        return url;
    }

    public IPath getPath() {
        return this.path;
    }

    public String toString() {
        return "Plugin " + this.pluginId + Messages.getString("PluginProcessorJar.0") + this.path;
    }
}

