/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.launching;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xsl.internal.launching.Messages;
import org.osgi.framework.Bundle;

public class Utils {
    public static String getFileLocation(String bundleId, String path) throws CoreException {
        String location = null;
        try {
            URL url = FileLocator.find((Bundle)Platform.getBundle((String)bundleId), (IPath)new Path(path), null);
            if (url != null) {
                URL fileUrl = FileLocator.toFileURL((URL)url);
                File file = new File(fileUrl.getFile());
                location = file.getAbsolutePath();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 4, String.valueOf(Messages.getString("Utils.0")) + path + Messages.getString("Utils.1") + bundleId, (Throwable)e));
        }
        return location;
    }

    public static String getPluginLocation(String bundleId) throws CoreException {
        String location = null;
        try {
            URL url = new URL("platform:/plugin/" + bundleId);
            if (url != null) {
                URL fileUrl = FileLocator.toFileURL((URL)url);
                File file = new File(fileUrl.getFile());
                location = file.getAbsolutePath();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 4, String.valueOf(Messages.getString("Utils.0")) + bundleId + Messages.getString("Utils.1") + bundleId, (Throwable)e));
        }
        return location;
    }
}

