/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.launching;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.xsl.internal.launching.LaunchingPlugin;
import org.eclipse.wst.xsl.internal.launching.Messages;
import org.eclipse.wst.xsl.launching.IDebugger;
import org.eclipse.wst.xsl.launching.IProcessorInstall;
import org.eclipse.wst.xsl.launching.IProcessorInvoker;
import org.eclipse.wst.xsl.launching.IProcessorJar;
import org.eclipse.wst.xsl.launching.XSLTRuntime;
import org.eclipse.wst.xsl.launching.config.LaunchHelper;
import org.eclipse.wst.xsl.launching.model.XSLDebugTarget;
import org.osgi.framework.Bundle;

public class XSLTLaunchConfigurationDelegate
extends JavaLaunchDelegate
implements IDebugEventSetListener {
    private String mode;
    private LaunchHelper launchHelper;

    public synchronized void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.mode = mode;
        this.launchHelper = new LaunchHelper(configuration);
        this.launchHelper.save(this.getLaunchConfigFile());
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)new XSLDebugEventSetListener(launch));
        final ISourceLocator configuredLocator = launch.getSourceLocator();
        launch.setSourceLocator(null);
        super.launch(configuration, mode, launch, monitor);
        final ISourceLocator javaSourceLookupDirector = launch.getSourceLocator();
        launch.setSourceLocator(new ISourceLocator(){

            public Object getSourceElement(IStackFrame stackFrame) {
                Object sourceElement = javaSourceLookupDirector.getSourceElement(stackFrame);
                if (sourceElement == null) {
                    sourceElement = configuredLocator.getSourceElement(stackFrame);
                }
                return sourceElement;
            }
        });
        IDebugTarget javaTarget = launch.getDebugTarget();
        XSLDebugTarget xslTarget = new XSLDebugTarget(launch, launch.getProcesses()[0], this.launchHelper);
        launch.removeDebugTarget(javaTarget);
        launch.addDebugTarget((IDebugTarget)xslTarget);
    }

    protected IBreakpoint[] getBreakpoints(ILaunchConfiguration configuration) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (!breakpointManager.isEnabled()) {
            return null;
        }
        IBreakpoint[] javaBreakpoints = super.getBreakpoints(configuration);
        IBreakpoint[] xslBreakpoints = breakpointManager.getBreakpoints("org.eclipse.wst.xsl.launching.XSLDebugModel");
        IBreakpoint[] breakpoints = new IBreakpoint[javaBreakpoints.length + xslBreakpoints.length];
        System.arraycopy(javaBreakpoints, 0, breakpoints, 0, javaBreakpoints.length);
        System.arraycopy(xslBreakpoints, 0, breakpoints, javaBreakpoints.length, xslBreakpoints.length);
        return breakpoints;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IProcessorInstall install;
        if (mode.equals("debug") && (install = XSLTLaunchConfigurationDelegate.getProcessorInstall(configuration, "run")).getDebugger() == null) {
            final boolean[] result = new boolean[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    String debuggingInstallId = LaunchingPlugin.getDefault().getPluginPreferences().getString("org.eclipse.wst.xsl.launching.ATTR_DEFAULT_DEBUGGING_INSTALL_ID");
                    IProcessorInstall processor = XSLTRuntime.getProcessor(debuggingInstallId);
                    IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    String title = Messages.getString("XSLTLaunchConfigurationDelegate.0");
                    String message = String.valueOf(Messages.getString("XSLTLaunchConfigurationDelegate.1")) + install.getName() + Messages.getString("XSLTLaunchConfigurationDelegate.2") + Messages.getString("XSLTLaunchConfigurationDelegate.3") + processor.getName() + Messages.getString("XSLTLaunchConfigurationDelegate.4");
                    MessageDialog dialog = new MessageDialog(dw.getShell(), title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    result[0] = dialog.open() == 0;
                }
            });
            return result[0];
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        return super.getVMRunner(configuration, mode);
    }

    private File getLaunchConfigFile() {
        IPath launchPath = Platform.getStateLocation((Bundle)LaunchingPlugin.getDefault().getBundle()).append(Messages.getString("XSLTLaunchConfigurationDelegate.5"));
        File launchDir = launchPath.toFile();
        if (!launchDir.exists()) {
            launchDir.mkdir();
        }
        File featuresFile = new File(launchDir, Messages.getString("XSLTLaunchConfigurationDelegate.6"));
        return featuresFile;
    }

    public IPath getWorkingDirectoryPath(ILaunchConfiguration configuration) throws CoreException {
        String path = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_PROCESSOR_WORKING_DIR", null);
        if (path != null) {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
            return new Path(path);
        }
        return null;
    }

    private IProcessorInvoker getProcessorInvokerDescriptor(ILaunchConfiguration configuration) throws CoreException {
        String invokerId = configuration.getAttribute("org.eclipse.wst.xsl.launching.INVOKER_DESCRIPTOR", null);
        if (invokerId == null) {
            invokerId = "org.eclipse.wst.xsl.launching.jaxp.invoke";
        }
        return XSLTRuntime.getProcessorInvoker(invokerId);
    }

    public static IProcessorInstall getProcessorInstall(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProcessorInstall install;
        boolean useDefaultProcessor = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_PROCESSOR", true);
        if (useDefaultProcessor) {
            install = XSLTRuntime.getDefaultProcessor();
        } else {
            String processorId = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_PROCESSOR", "");
            install = XSLTRuntime.getProcessor(processorId);
        }
        if (mode.equals("debug") && install.getDebugger() == null) {
            String debuggingInstallId = LaunchingPlugin.getDefault().getPluginPreferences().getString("org.eclipse.wst.xsl.launching.ATTR_DEFAULT_DEBUGGING_INSTALL_ID");
            install = XSLTRuntime.getProcessor(debuggingInstallId);
        }
        return install;
    }

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        if ("debug".equals(this.mode)) {
            return "org.eclipse.wst.xsl.debugger.DebugRunner";
        }
        return "org.eclipse.wst.xsl.invoker.Main";
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        IProcessorInstall install;
        IProcessorInvoker invoker = this.getProcessorInvokerDescriptor(configuration);
        String clazz = invoker.getInvokerClassName();
        StringBuffer sb = new StringBuffer();
        sb.append(clazz);
        sb.append(" ");
        sb.append("\"" + this.getLaunchConfigFile().getAbsolutePath() + "\"");
        sb.append(" ");
        sb.append("\"" + this.launchHelper.getSource() + "\"");
        sb.append(" ");
        sb.append("\"" + this.launchHelper.getTarget().getAbsolutePath() + "\"");
        if ("debug".equals(this.mode) && (install = XSLTLaunchConfigurationDelegate.getProcessorInstall(configuration, this.mode)).getDebugger() != null) {
            IDebugger debugger = install.getDebugger();
            String className = debugger.getClassName();
            sb.append(" -debug ").append(className).append(" ");
            sb.append(this.launchHelper.getRequestPort()).append(" ").append(this.launchHelper.getEventPort());
        }
        return sb.toString();
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] userClasspath = super.getClasspath(configuration);
        IProcessorInvoker invoker = this.getProcessorInvokerDescriptor(configuration);
        ArrayList<String> invokerCP = new ArrayList<String>();
        String[] stringArray = invoker.getClasspathEntries();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            invokerCP.add(entry);
            ++n2;
        }
        IProcessorInstall install = XSLTLaunchConfigurationDelegate.getProcessorInstall(configuration, this.mode);
        if ("debug".equals(this.mode) && install.getDebugger() != null) {
            String[] jars;
            String[] stringArray2 = jars = install.getDebugger().getClassPath();
            int n3 = jars.length;
            int n4 = 0;
            while (n4 < n3) {
                String jar = stringArray2[n4];
                invokerCP.add(jar);
                ++n4;
            }
        }
        String[] invokerClasspath = invokerCP.toArray(new String[0]);
        String[] classpath = new String[userClasspath.length + invokerClasspath.length];
        System.arraycopy(invokerClasspath, 0, classpath, 0, invokerClasspath.length);
        System.arraycopy(userClasspath, 0, classpath, invokerClasspath.length, userClasspath.length);
        return classpath;
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String vmargs = super.getVMArguments(configuration);
        IProcessorInstall install = XSLTLaunchConfigurationDelegate.getProcessorInstall(configuration, this.mode);
        if (install != null && !install.getProcessorType().isJREDefault()) {
            File tempDir = this.getEndorsedDir();
            if (tempDir.exists()) {
                File[] children;
                File[] fileArray = children = tempDir.listFiles();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    child.delete();
                    ++n2;
                }
                tempDir.delete();
            }
            tempDir.mkdir();
            IProcessorJar[] jars = install.getProcessorJars();
            int i = 0;
            while (i < jars.length) {
                URL entry = jars[i].asURL();
                if (entry == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 4, String.valueOf(Messages.getString("XSLTLaunchConfigurationDelegate.23")) + jars[i], null));
                }
                File file = new File(tempDir, "END_" + i + ".jar");
                XSLTLaunchConfigurationDelegate.moveFile(entry, file);
                ++i;
            }
            vmargs = String.valueOf(vmargs) + " -Djava.endorsed.dirs=\"" + tempDir.getAbsolutePath() + "\"";
            String tfactory = install.getProcessorType().getTransformerFactoryName();
            if (tfactory != null) {
                vmargs = String.valueOf(vmargs) + " -Djavax.xml.transform.TransformerFactory=" + install.getProcessorType().getTransformerFactoryName();
            }
        }
        return vmargs;
    }

    private File getEndorsedDir() {
        IPath tempLocation = Platform.getStateLocation((Bundle)LaunchingPlugin.getDefault().getBundle()).append("endorsed");
        return tempLocation.toFile();
    }

    private static void moveFile(URL src, File target) throws CoreException {
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            try {
                bos = new BufferedOutputStream(new FileOutputStream(target));
                bis = new BufferedInputStream(src.openStream());
                while (bis.available() > 0) {
                    int size = bis.available();
                    if (size > 1024) {
                        size = 1024;
                    }
                    byte[] b = new byte[size];
                    bis.read(b, 0, b.length);
                    bos.write(b);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 4, String.valueOf(Messages.getString("XSLTLaunchConfigurationDelegate.7")) + src + Messages.getString("XSLTLaunchConfigurationDelegate.31") + target, (Throwable)e));
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                }
            }
        }
    }

    private class XSLDebugEventSetListener
    implements IDebugEventSetListener {
        private ILaunch launch;

        public XSLDebugEventSetListener(ILaunch launch) {
            this.launch = launch;
        }

        public void handleDebugEvents(DebugEvent[] events) {
            if (this.launch.getProcesses().length > 0) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent debugEvent = debugEventArray[n2];
                    if (debugEvent.getSource() == this.launch.getProcesses()[0] && debugEvent.getKind() == 8) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        File file = XSLTLaunchConfigurationDelegate.this.launchHelper.getTarget();
                        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
                        if (ifile != null) {
                            try {
                                ifile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor(){

                                    public void done() {
                                        XSLDebugEventSetListener.this.openFileIfRequired();
                                    }
                                });
                            }
                            catch (CoreException e) {
                                LaunchingPlugin.log(e);
                            }
                        } else {
                            this.openFileIfRequired();
                        }
                    }
                    ++n2;
                }
            }
        }

        private void openFileIfRequired() {
            if (XSLTLaunchConfigurationDelegate.this.launchHelper.getOpenFileOnCompletion()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        try {
                            File file = XSLTLaunchConfigurationDelegate.this.launchHelper.getTarget();
                            Path path = new Path(file.getAbsolutePath());
                            IFileStore filestore = EFS.getLocalFileSystem().getStore((IPath)path);
                            IDE.openEditorOnFileStore((IWorkbenchPage)dw.getActivePage(), (IFileStore)filestore);
                        }
                        catch (PartInitException e) {
                            LaunchingPlugin.log((CoreException)((Object)e));
                        }
                    }
                });
            }
        }
    }
}

