/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.launching.registry;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xsl.internal.launching.LaunchingPlugin;
import org.eclipse.wst.xsl.internal.launching.ProcessorPreferences;
import org.eclipse.wst.xsl.internal.launching.registry.ProcessorRegistryReader;
import org.eclipse.wst.xsl.launching.IProcessorInstall;
import org.eclipse.wst.xsl.launching.IProcessorJar;
import org.eclipse.wst.xsl.launching.ProcessorInstall;

public class ProcessorRegistry {
    private final List<ProcessorInstall> contributedInstalls = new ArrayList<ProcessorInstall>();
    private List<IProcessorInstall> userInstalls = new ArrayList<IProcessorInstall>();
    private IProcessorInstall defaultProcessor;
    private IProcessorInstall jreDefaultProcessor;
    private IProcessorInstall[] installs;

    public ProcessorRegistry() {
        this.initializeFromStorage();
    }

    private void initializeFromStorage() {
        ProcessorRegistryReader registryReader = new ProcessorRegistryReader();
        registryReader.addConfigs(this);
        for (IProcessorInstall iProcessorInstall : this.contributedInstalls) {
            if (!iProcessorInstall.getId().equals("org.eclipse.wst.xsl.launching.jre.default")) continue;
            this.jreDefaultProcessor = iProcessorInstall;
            break;
        }
        this.addPersistedVMs();
    }

    private void addPersistedVMs() {
        String vmXMLString = LaunchingPlugin.getDefault().getPluginPreferences().getString("PREF_PROCESSOR_XML");
        if (vmXMLString.length() > 0) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(vmXMLString.getBytes());
                ProcessorPreferences prefs = ProcessorPreferences.fromXML(inputStream);
                String defaultProcessorId = prefs.getDefaultProcessorId();
                this.userInstalls = prefs.getProcessors();
                for (IProcessorInstall iProcessorInstall : this.userInstalls) {
                    if (!iProcessorInstall.getId().equals(defaultProcessorId)) continue;
                    this.defaultProcessor = iProcessorInstall;
                }
                if (this.defaultProcessor == null) {
                    for (IProcessorInstall iProcessorInstall : this.contributedInstalls) {
                        if (this.defaultProcessor != null || !iProcessorInstall.getId().equals(defaultProcessorId)) continue;
                        this.defaultProcessor = iProcessorInstall;
                    }
                }
            }
            catch (CoreException e) {
                LaunchingPlugin.log(e);
            }
        }
        if (this.defaultProcessor == null) {
            this.defaultProcessor = this.jreDefaultProcessor;
        }
    }

    public void addProcessor(String bundleId, String id, String label, String processorTypeId, String classpath, String debuggerId, String supports) {
        IProcessorJar[] jars = ProcessorInstall.createJars(bundleId, classpath);
        this.contributedInstalls.add(new ProcessorInstall(id, label, processorTypeId, jars, debuggerId, supports, true));
    }

    public void addProcessor(IProcessorInstall install) {
        if (!install.isContributed()) {
            this.userInstalls.add(install);
        }
        IProcessorInstall[] newinstalls = new IProcessorInstall[this.installs.length + 1];
        System.arraycopy(this.installs, 0, newinstalls, 0, this.installs.length);
        newinstalls[this.installs.length] = install;
        this.installs = newinstalls;
    }

    public void removeProcessor(int index) {
        IProcessorInstall removed = this.installs[index];
        if (!removed.isContributed()) {
            this.userInstalls.remove(removed);
        }
        IProcessorInstall[] newinstalls = new IProcessorInstall[this.installs.length - 1];
        System.arraycopy(this.installs, 0, newinstalls, 0, index);
        System.arraycopy(this.installs, index + 1, newinstalls, index, newinstalls.length - index);
        this.installs = newinstalls;
    }

    public IProcessorInstall[] getProcessors() {
        if (this.installs == null) {
            this.installs = new IProcessorInstall[this.contributedInstalls.size() + this.userInstalls.size()];
            int startIndex = 0;
            int i = 0;
            while (i < this.contributedInstalls.size()) {
                this.installs[i] = this.contributedInstalls.get(i);
                startIndex = i + 1;
                ++i;
            }
            i = 0;
            while (i < this.userInstalls.size()) {
                this.installs[startIndex + i] = this.userInstalls.get(i);
                ++i;
            }
        }
        return this.installs;
    }

    public IProcessorInstall[] getProcessors(String id) {
        IProcessorInstall[] installs = this.getProcessors();
        ArrayList<IProcessorInstall> result = new ArrayList<IProcessorInstall>();
        IProcessorInstall[] iProcessorInstallArray = installs;
        int n = installs.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorInstall type = iProcessorInstallArray[n2];
            if (type.getProcessorType().getId().equals(id)) {
                result.add(type);
            }
            ++n2;
        }
        return result.toArray(new IProcessorInstall[0]);
    }

    public void setDefaultProcessor(IProcessorInstall defaultInstall) {
        this.defaultProcessor = defaultInstall;
    }

    public IProcessorInstall getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public IProcessorInstall getJREDefaultProcessor() {
        return this.jreDefaultProcessor;
    }

    public IProcessorInstall[] getContributedProcessors() {
        return this.contributedInstalls.toArray(new IProcessorInstall[0]);
    }
}

