/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.config;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.xsl.internal.launching.LaunchingPlugin;
import org.eclipse.wst.xsl.internal.launching.PreferenceUtil;
import org.eclipse.wst.xsl.invoker.config.PipelineDefinition;
import org.eclipse.wst.xsl.invoker.config.TransformDefinition;
import org.eclipse.wst.xsl.invoker.config.TypedValue;
import org.eclipse.wst.xsl.launching.IFeature;
import org.eclipse.wst.xsl.launching.IOutputProperty;
import org.eclipse.wst.xsl.launching.IProcessorInstall;
import org.eclipse.wst.xsl.launching.IProcessorType;
import org.eclipse.wst.xsl.launching.XSLTRuntime;
import org.eclipse.wst.xsl.launching.config.LaunchAttribute;
import org.eclipse.wst.xsl.launching.config.LaunchFeatures;
import org.eclipse.wst.xsl.launching.config.LaunchPipeline;
import org.eclipse.wst.xsl.launching.config.LaunchProperties;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;
import org.eclipse.wst.xsl.launching.config.Messages;
import org.w3c.dom.Document;

public class LaunchHelper {
    private final URL source;
    private final File target;
    private final LaunchFeatures features;
    private final LaunchPipeline pipeline;
    private final LaunchProperties outputProperties;
    private int requestPort = -1;
    private int eventPort = -1;
    private final boolean openFileOnCompletion;

    public LaunchHelper(ILaunchConfiguration configuration) throws CoreException {
        this.source = LaunchHelper.hydrateSourceFileURL(configuration);
        this.target = LaunchHelper.hydrateOutputFile(configuration);
        this.features = this.hydrateFeatures(configuration);
        this.outputProperties = LaunchHelper.hydrateOutputProperties(configuration);
        this.pipeline = LaunchHelper.hydratePipeline(configuration);
        this.openFileOnCompletion = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OPEN_FILE", true);
    }

    public int getRequestPort() {
        if (this.requestPort == -1) {
            this.requestPort = LaunchHelper.findFreePort();
        }
        return this.requestPort;
    }

    public int getEventPort() {
        if (this.eventPort == -1) {
            this.eventPort = LaunchHelper.findFreePort();
        }
        return this.eventPort;
    }

    public LaunchProperties getProperties() {
        return this.outputProperties;
    }

    public LaunchFeatures getFeatures() {
        return this.features;
    }

    public LaunchPipeline getPipeline() {
        return this.pipeline;
    }

    public URL getSource() {
        return this.source;
    }

    public File getTarget() {
        return this.target;
    }

    public void save(File file) throws CoreException {
        BufferedWriter writer = null;
        try {
            try {
                file.createNewFile();
                writer = new BufferedWriter(new FileWriter(file));
                PipelineDefinition pdef = new PipelineDefinition();
                for (LaunchAttribute att : this.features.getFeatures()) {
                    pdef.addFeature(new TypedValue(att.uri, att.type, att.value));
                }
                Iterator<Object> iter = this.pipeline.getTransformDefs().iterator();
                while (iter.hasNext()) {
                    LaunchTransform lt = (LaunchTransform)iter.next();
                    TransformDefinition tdef = new TransformDefinition();
                    URL url = LaunchHelper.pathToURL(lt.getLocation());
                    tdef.setStylesheetURL(url.toExternalForm());
                    tdef.setResolverClass(lt.getResolver());
                    for (LaunchAttribute launchAttribute : lt.getParameters()) {
                        tdef.addParameter(new TypedValue(launchAttribute.uri, launchAttribute.type, launchAttribute.getResolvedValue()));
                    }
                    if (!iter.hasNext()) {
                        for (Map.Entry entry : this.outputProperties.getProperties().entrySet()) {
                            String name = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            if (name == null || value == null) continue;
                            tdef.setOutputProperty(name, value);
                        }
                    }
                    pdef.addTransformDef(tdef);
                }
                Document doc = pdef.toXML();
                String s = PreferenceUtil.serializeDocument(doc);
                writer.write(s);
            }
            catch (FileNotFoundException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 4, Messages.getString("LaunchHelper.0"), (Throwable)e));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 4, Messages.getString("LaunchHelper.1"), (Throwable)e));
            }
            catch (ParserConfigurationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 4, "ParserConfigurationException", (Throwable)e));
            }
            catch (TransformerException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 4, "TransformerException", (Throwable)e));
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                }
            }
        }
    }

    public static LaunchProperties hydrateOutputProperties(ILaunchConfiguration configuration) throws CoreException {
        LaunchProperties properties;
        block7: {
            IProcessorType pt;
            IProcessorType defaultType;
            block6: {
                String value;
                String name;
                Map.Entry<Object, Object> entry;
                Map.Entry<Object, Object> element;
                properties = null;
                boolean usePreferenceProperties = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_PROPERTIES_FROM_PREFERENCES", true);
                defaultType = XSLTRuntime.getJREDefaultProcessor().getProcessorType();
                pt = LaunchHelper.getProcessorInstall(configuration).getProcessorType();
                if (!usePreferenceProperties) break block6;
                properties = new LaunchProperties();
                Iterator<Map.Entry<Object, Object>> iterator = defaultType.getOutputPropertyValues().entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = element = iterator.next();
                    name = (String)entry.getKey();
                    value = (String)entry.getValue();
                    properties.setProperty(name, value);
                }
                if (pt.equals(defaultType)) break block7;
                iterator = pt.getOutputPropertyValues().entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = element = iterator.next();
                    name = (String)entry.getKey();
                    value = (String)entry.getValue();
                    properties.setProperty(name, value);
                }
                break block7;
            }
            String s = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_PROPERTIES", null);
            if (s != null && s.length() > 0) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes());
                properties = LaunchProperties.fromXML(inputStream);
                IOutputProperty[] defaultProps = defaultType.getOutputProperties();
                IOutputProperty[] specificProps = pt.getOutputProperties();
                IOutputProperty[] props = new IOutputProperty[specificProps.length + defaultProps.length];
                System.arraycopy(specificProps, 0, props, 0, specificProps.length);
                System.arraycopy(defaultProps, 0, props, specificProps.length, defaultProps.length);
                for (String key : properties.getProperties().keySet()) {
                    boolean found = false;
                    IOutputProperty[] iOutputPropertyArray = props;
                    int n = props.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IOutputProperty outputProperty = iOutputPropertyArray[n2];
                        if (outputProperty.getURI().equals(key)) {
                            found = true;
                        }
                        ++n2;
                    }
                    if (found) continue;
                    properties.removeProperty(key);
                }
            }
        }
        return properties;
    }

    private LaunchFeatures hydrateFeatures(ILaunchConfiguration configuration) throws CoreException {
        LaunchFeatures features = null;
        boolean useDefaultFeatures = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_FEATURES_FROM_PREFERENCES", true);
        if (useDefaultFeatures) {
            features = new LaunchFeatures();
            IProcessorType pt = LaunchHelper.getProcessorInstall(configuration).getProcessorType();
            Map<String, String> fvals = pt.getFeatureValues();
            for (Map.Entry<String, String> entry : fvals.entrySet()) {
                String uri = entry.getKey();
                IFeature feature = this.getFeature(pt.getFeatures(), uri);
                features.addFeature(new LaunchAttribute(uri, feature.getType(), entry.getValue()));
            }
        } else {
            String s = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_FEATURES", null);
            if (s != null && s.length() > 0) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes());
                features = LaunchFeatures.fromXML(inputStream);
            }
        }
        return features;
    }

    private IFeature getFeature(IFeature[] features, String uri) {
        IFeature[] iFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            if (feature.getURI().equals(uri)) {
                return feature;
            }
            ++n2;
        }
        return null;
    }

    private static LaunchPipeline hydratePipeline(ILaunchConfiguration configuration) throws CoreException {
        LaunchPipeline pipeline = null;
        String s = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_PIPELINE", null);
        if (s != null && s.length() > 0) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes());
            pipeline = LaunchPipeline.fromXML(inputStream);
        }
        return pipeline;
    }

    public static URL hydrateSourceFileURL(ILaunchConfiguration configuration) throws CoreException {
        IPath sourceFile = LaunchHelper.hydrateSourceFile(configuration);
        return LaunchHelper.pathToURL(sourceFile);
    }

    private static IPath hydrateSourceFile(ILaunchConfiguration configuration) throws CoreException {
        String sourceFileExpr = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", null);
        return LaunchHelper.getSubstitutedPath(sourceFileExpr);
    }

    private static URL pathToURL(IPath sourceFile) throws CoreException {
        URL url = null;
        try {
            url = sourceFile.toFile().toURL();
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 4, sourceFile.toString(), (Throwable)e));
        }
        return url;
    }

    public static File hydrateOutputFile(ILaunchConfiguration configuration) throws CoreException {
        IPath outputFile = null;
        boolean useDefaultOutputFile = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_OUTPUT_FILE", true);
        if (!useDefaultOutputFile) {
            String outputFileExpr = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FILE", null);
            outputFile = LaunchHelper.getSubstitutedPath(outputFileExpr);
        } else {
            outputFile = LaunchHelper.hydrateSourceFile(configuration);
            outputFile = outputFile.addFileExtension("out").addFileExtension("xml");
        }
        return outputFile.toFile();
    }

    private static IPath getSubstitutedPath(String path) throws CoreException {
        if (path != null) {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
            return new Path(path);
        }
        return null;
    }

    public static IProcessorInstall getProcessorInstall(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefaultProcessor = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_PROCESSOR", true);
        if (useDefaultProcessor) {
            return XSLTRuntime.getDefaultProcessor();
        }
        String processorId = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_PROCESSOR", "");
        IProcessorInstall processor = XSLTRuntime.getProcessor(processorId);
        return processor;
    }

    public static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                }
            }
        }
        return -1;
    }

    public boolean getOpenFileOnCompletion() {
        return this.openFileOnCompletion;
    }
}

